# Reproduce Results

## Training

### Training on TSP50

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp50_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp50_train_concorde.txt" \
  --validation_split "/your/tsp50_valid_concorde.txt" \
  --test_split "/your/tsp50_test_concorde.txt" \
  --batch_size 64 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 1
```

### Training on TSP100

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp100_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
    --training_split "/your/tsp100_train_concorde.txt" \
    --validation_split "/your/tsp100_valid_concorde.txt" \
    --test_split "/your/tsp100_test_concorde.txt" \
  --batch_size 32 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 1
```

### Training on TSP5000

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1,2,3

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp5000_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp5000_train_lkh.txt" \
  --validation_split "/your/tsp5000_valid_lkh.txt" \
  --test_split "/your/tsp5000_test_lkh.txt" \
  --sparse_factor 100 \
  --batch_size 3 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 1 \
  --use_activation_checkpoint
```

### Training on TSP8000

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1,2,3

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp8000_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp1000_train_lkh.txt" \
  --validation_split "/your/tsp1000_valid_lkh.txt" \
  --test_split "/your/tsp1000_test_lkh.txt" \
  --sparse_factor 100 \
  --batch_size 1 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 1 \
  --use_activation_checkpoint
```

### Training on TSP10000

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1,2,3

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp10000_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp10000_train_lkh.txt" \
  --validation_split "/your/tsp10000_valid_lkh.txt" \
  --test_split "/your/tsp10000_test_lkh.txt" \
  --sparse_factor 100 \
  --batch_size 1 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 1 \
  --two_opt_iterations 5000 \
  --use_activation_checkpoint
```

### Training on SATLIB graphs of the MIS problem

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1

python -u  disco/train.py \
  --task "mis" \
  --logger_name "mis_sat_train" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/train_mis_sat/*gpickle" \
  --validation_split "/your/test_mis_sat/*gpickle" \
  --test_split "/your/test_mis_sat/*gpickle" \
  --batch_size 16 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 50 \
  --use_activation_checkpoint
```

### Training on ER-[700-800] graphs of the MIS problem

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0,1

python -u  disco/train.py \
  --task "mis" \
  --logger_name "mis_er_train" \
  --diffusion_type "gaussian" \
  --do_train \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/data_er/train/*gpickle" \
  --training_split_label_dir "/your/data_er/train_annotations/" \
  --validation_split "/your/data_er/train/validation/*gpickle" \
  --test_split "/your/data_er/train/test/*gpickle" \
  --batch_size 4 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 50 \
  --use_activation_checkpoint
```

## Direct evaluation

Due to the various possible configurations for evaluation, we only provide a few examples of evaluation commands.

Please uncomment line 16 in `disco/train.py`

### Evaluation on TSP100

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp100_test" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp100_train_concorde.txt" \
  --validation_split "/your/tsp100_valid_concorde.txt" \
  --test_split "/your/tsp100_test_concorde.txt" \
  --batch_size 32 \
  --num_epochs 25 \
  --inference_diffusion_steps 1 \
  --ckpt_path "ckpts/tsp-100.ckpt" \
  --resume_weight_only
```

### Evaluation on TSP500, 4xparallel

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp5000_test_par4" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp5000_train_lkh.txt" \
  --validation_split "/your/tsp5000_valid_concorde.txt" \
  --test_split "/your/tsp5000_test_concorde.txt" \
  --sparse_factor 50 \
  --batch_size 32 \
  --num_epochs 25 \
  --validation_examples 8 \
  --inference_diffusion_steps 1 \
  --parallel_sampling 4 \
  --ckpt_path "ckpts/tsp-500.ckpt" \
  --resume_weight_only
```

### Evaluation on TSP10000, 4xsequential

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsp10k_test_seq4" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/tsp10000_train_lkh.txt" \
  --validation_split "/your/tsp10000_valid_concorde.txt" \
  --test_split "/your/tsp10000_test_concorde.txt" \
  --sparse_factor 100 \
  --batch_size 1 \
  --num_epochs 25 \
  --validation_examples 8 \
  --inference_diffusion_steps 1 \
  --sequential_sampling 4 \
  --two_opt_iterations 5000 \
  --ckpt_path "ckpts/tsp-10k.ckpt" \
  --resume_weight_only
```

### Evaluation on SATLIB graphs 

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "mis" \
  --logger_name "mis_sat_test" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/train_mis_sat/*gpickle" \
  --validation_split "/your/test_mis_sat/*gpickle" \
  --test_split "/your/test_mis_sat/*gpickle" \
  --batch_size 16 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 50 \
  --ckpt_path "ckpts/er.ckpt" \
  --resume_weight_only
```

### Evaluation on ER-[700-800] graphs 

```bash
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "mis" \
  --logger_name "mis_er_test" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --training_split "/your/data_er/train/*gpickle" \
  --training_split_label_dir "/your/data_er/train_annotations/" \
  --validation_split "/your/data_er/train/validation/*gpickle" \
  --test_split "/your/data_er/train/test/*gpickle" \
  --batch_size 4 \
  --num_epochs 50 \
  --validation_examples 8 \
  --inference_diffusion_steps 50 \
  --parallel_sampling 1 \
  --use_activation_checkpoint \
  --ckpt_path "ckpts/satlib.ckpt" \
  --resume_weight_only
```



## Multi-Modality Inspired Graph Search

Please uncomment line 17 in `disco/train.py`



### TSP-5000

```shell
python -u disco/train.py \
  --task "tsp" \
  --logger_name "tsp5k_MS" \
  --do_predict \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "./" \
  --training_split "/your/tsp5000_train_lkh.txt" \
  --validation_split "/your/tsp5000_valid_concorde.txt" \
  --test_split "/your/tsp5000_test_concorde.txt" \
  --predict_split "/your/tsp5000_test_concorde.txt" \
  --sparse_factor 100 \
  --batch_size 16 \
  --num_epochs 25 \
  --validation_examples 1 \
  --prediction_examples 16 \
  --inference_diffusion_steps 2 \
  --parallel_sampling 2 \
  --ckpt_path "ckpts/tsp-100.ckpt" \
  --resume_weight_only \
  --fusion_method "mean" \
  --sub_graph_size 100 \
  --min_visited 1 \
  --use_multi_processing \
  --num_trials 50 \
  --multip_batchsize 16
```



### TSP-10000

```shell
python -u disco/train.py \
  --task "tsp" \
  --logger_name "tsp10k_MS" \
  --do_predict \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "./" \
  --training_split "/your/tsp10000_train_lkh.txt" \
  --validation_split "/your/tsp10000_valid_concorde.txt" \
  --test_split "/your/tsp10000_test_concorde.txt" \
  --predict_split "data/tsp/tsp10000_test_concorde.txt" \
  --sparse_factor 100 \
  --batch_size 16 \
  --num_epochs 25 \
  --validation_examples 1 \
  --prediction_examples 16 \
  --inference_diffusion_steps 2 \
  --parallel_sampling 2 \
  --ckpt_path "ckpts/tsp-100.ckpt" \
  --resume_weight_only \
  --fusion_method "mean" \
  --sub_graph_size 100 \
  --min_visited 1 \
  --use_multi_processing \
  --num_trials 50 \
  --multip_batchsize 150 \
  --two_opt_iterations 5000
```



## TSPLib evaluation

Please uncomment line 18 in `disco/train.py` and lines with `*(for tsplib only)*` in `disco/co_datasets/tsp_graph_dataset.py`

```shell
export PYTHONPATH="$PWD:$PYTHONPATH"
export CUDA_VISIBLE_DEVICES=0

python -u  disco/train.py \
  --task "tsp" \
  --logger_name "tsplib_test" \
  --do_test \
  --learning_rate 0.0002 \
  --weight_decay 0.0001 \
  --lr_scheduler "cosine-decay" \
  --storage_path "/your/storage/path" \
  --validation_split "/your/tsp_realworld_test.txt" \
  --test_split "/your/tsp_realworld_test.txt" \
  --batch_size 1 \
  --num_epochs 25 \
  --inference_diffusion_steps 2 \
  --parallel_sampling 4 \
  --ckpt_path "ckpts/tsp-100.ckpt" \
  --resume_weight_only
```

