# DISCO: Efficient Diffusion Solver for Large-Scale Combinatorial Optimization Problems

## Setup

```bash
conda env create -f environment.yml
conda activate disco
```

Running TSP experiments requires installing the additional cython package for merging the diffusion heatmap results:

```bash
cd disco/utils/cython_merge
python setup.py build_ext --inplace
cd -
```

## Codebase Structure

* `disco/pl_meta_model_rddm.py`: the code for a meta pytorch-lightning model for training and evaluation.
* `disco/pl_tsp_model_rddm.py`: the code for training and evaluation of the small scale TSP problem (TSP-50 and TSP-100)
* `disco/pl_tsp_model_rddm_largescale.py`: the code for the large scale TSP problem (TSP-5000, TSP-8000 and TSP-10000)
* `disco/pl_tsp_model_rddm_tsplib.py`: the code for the evaluation of the TSPLib problems
* `disco/pl_mis_model_rddm.py`: the code for the MIS problem
* `disco/train.py`: the handler for training and evaluation

## Data

Please check the `data` folder.

## Reproduction

Please check the [reproducing_scripts](reproducing_scripts.md) for more details.

## Pretrained Checkpoints

Please download the pretrained model checkpoints from [here](https://github.com/ICLR-DISCO/ICLR-DISCO/releases/tag/0.1.0).