
Introduction of Argtable3
=========================

**Argtable3** is an open source ANSI C library that parses GNU-style command-line
options. It simplifies command-line parsing by defining a declarative-style API
that you can use to specify what your command-line syntax looks like. Argtable3
will automatically generate consistent error handling logic and textual
descriptions of the command line syntax, which are essential but tedious to
implement for a robust CLI program.


Quick Start
-----------

Argtable3 is a single-file ANSI-C library. All you have to do is adding
`argtable3.c` to your projects, and including `argtable3.h` in your source code.

If you have modified Argtable3 and want to quickly verify whether the
modifications break any existing code or not, you can run the following commands
in the project root directory to build both examples and unit tests and run unit
tests:

* If you use GCC (Linux, MinGW, Cygwin), type:

  ```
  $ make
  ```

  To cleanup, type:
  
  ```
  make cleanall
  ```

* If you use Microsoft Visual C++ compiler, type:

  ```
  $ nmake /f Makefile.nmake
  ```

  To cleanup, type:
  
  ```
  nmake /f Makefile.nmake cleanall
  ```

If you want to use CMake to generate Visual Studio 2017 x64 solution file, type:

```
$ mkdir build
$ cd build
$ cmake -G "Visual Studio 15 2017 Win64" ..
```
  
To cleanup, just remove the `build` directory.


Documentation and Examples
--------------------------

To learn how to use the Argtable3 API, you can see the documentation on the web
site, or examples in the `examples` folder.

To build the examples, open the console window of your favorite development
environments, go to the `examples` folder, and use the included Makefiles to build
the examples.

* If you use GCC (Linux, MinGW, Cygwin), type:

  ```
  $ make
  ```

  To cleanup, type:
  
  ```
  make cleanall
  ```


* If you use Microsoft Visual C++ compiler, type:

  ```
  $ nmake /f Makefile.nmake
  ```

  To cleanup, type:
  
  ```
  nmake /f Makefile.nmake cleanall
  ```
  

Unit Tests
----------

Argtable3 is a BSD-licensed open source library, so you can modify the library
anyway you want. However, before committing your code to your own repository or
the Argtable3 official repository, please make sure your changes can pass the
unit tests included in the distribution.

To build and run the unit tests, open the console window of your favorite
development environments, go to the `tests` folder, and use the included Makefiles
to build and run the unit tests.

* If you use GCC (Linux, MinGW, Cygwin), type:

  ```
  $ make
  ```

  To cleanup, type:
  
  ```
  make cleanall
  ```


* If you use Microsoft Visual C++ compiler, type:

  ```
  $ nmake /f Makefile.nmake
  ```

  To cleanup, type:
  
  ```
  nmake /f Makefile.nmake cleanall
  ```
  

Authors
-------

Argtable is Copyright (C) 1998-2001,2003-2011 Stewart Heitmann.
Parts are Copyright (C) 1989-1994, 1996-1999, 2001, 2003
  Free Software Foundation, Inc.

Argtable was written by Stewart Heitmann <sheitmann@users.sourceforge.net>

Argtable is now maintained by Tom G. Huang <tomghuang@gmail.com>
The project homepage of argtable 3.x is http://www.argtable.org
The project homepage of argtable 2.x is http://argtable.sourceforge.net/

Here is a list of contributors who have helped to improve argtable:

- **Nina Clemson**: Editing the original argtable-1.0 documentation.
- **Livio Bertacco**: For bug fixes and the argtable-2.x Visual C++ Makefiles.                              
- **Justin Dearing**: For bug fixes and Windows DLL support, plus code support for the Open Watcom compiler and help with the Mac OS X configuration.
- **Asa Packer**: Contributing bug fixes and upgrades to the Visual C++ Makefiles.
- **Danilo Cicerone**: For the Italian translation of "Introduction to Argtable-2x" on http://www.digitazero.org.
- **Uli Fouquet**: For configuration patches and documentation related to cross-compiling argtable from Unix to Windows, as well as providing the arg_print_glossary_gnu function.
- **Shachar Shemesh**: For Debian package integration and kick-starting the migration to automake/autoconf.
- **Jasper Lievisse Adriaanse**:  Maintaining the argtable package in OpenBSD ports.
- **Ulrich Mohr**: For bug fixes relating to Texas Instrument DSP platforms.
- **John Vickers**: For bug fixes relating to Solaris/Motorola platforms.
- **Steve O'Neil**: For bug fixes relating to Solaris/Motorola platforms.
- **Lori A. Pritchett-Sheats**: Fixing a makefile bug relating to "make dist".
- **Paolo Bormida**: For instructions on building argtable with date and regex support on Windows.
- **Michel Valin**: For bug fixes relating to the configure scripts on IBM AIX platforms and instructions on compiling the example code under AIX.
- **Steve Christensen**: Providing prebuilt packages for SPARC/Solaris and x86/Solaris platforms on www.sunfreeware.com.
- **Jess Portnoy**: Reworking the rpm package and integrating argtable into Fedora Linux.
- **Michael Brown**: Incorporating support for pkg-config into the autoconf scripts.
- **Alexander Lindert**: For extensions to the parser to support hex, octal and binary integer formats as well as KB/MB/GB suffixes.
- **Rob Zaborowski**: Providing build configuration files for CMake.
- **Moczik Gabor**: For bug fixes relating to the parsing of filepaths and filename extensions.
