import argparse
import pprint as pp
import time
import warnings
from multiprocessing import Pool

import lkh
import numpy as np
import tqdm
import tsplib95
from concorde.tsp import TSPSolver  # https://github.com/jvkersch/pyconcorde

filename = "./tsp/tsp5000_test_lkh.txt"
# filename = "./tsp/tsp50_test_concorde.txt"

with open(filename, "r") as f:
    filelines = f.readlines()

res = []

t1 = time.time()
for i in tqdm.tqdm(range(len(filelines))):
    line = filelines[i]
    line = line.strip()
    points = line.split(' output ')[0]
    points = points.split(' ')
    # points = points.split()
    nodes_coord = np.array([[float(points[i]), float(points[i + 1])] for i in range(0, len(points), 2)])
    scale = 1e6
    solver = TSPSolver.from_data(nodes_coord[:, 0] * scale, nodes_coord[:, 1] * scale, norm="EUC_2D")
    solution = solver.solve(verbose=False)
    tour = solution.tour
    print("The solution is: ")
    print(solution.optimal_value / scale)
    res.append(solution.optimal_value / scale)

t2 = time.time()
print("Final: ")
print(sum(res) / len(res))
print(t2 - t1)
