# Learning World Model with Identifiable Factorization

### Requirements
To install it, create a conda environment with `Python>=3.7` and follow the instructions below. Note, that the current implementation of IFactor requires a GPU.
```
conda create -n IFactor python=3.8
pip install -e .
```

All noisy environments require the driving_car class of the Kinetics-400 training dataset. Some instructions for downloading the dataset can be found [here](https://github.com/Showmax/kinetics-downloader). The downloaded videos should be put into this position: `~/.driving_car/*.mp4`. Instructions for installing the environments of variants of Robodesk and DMC can be found [here](https://github.com/facebookresearch/denoised_mdp).

### Run Experiments
Robodesk: `CUDA_VISIBLE_DEVICES=0 python script/train/d_robodesk.py`

DMC: `CUDA_VISIBLE_DEVICES=0 WANDB_MODE=offline python script/train/d_dmc.py --domain_name cheetah --variant noiseless`
where domain_name should be in [`cheetah`, `walker`, `reacher`], variant should be in [`noiseless`, `video_background`,  `video_background_noisy_sensor`]

Cartpole: `CUDA_VISIBLE_DEVICES=1 python script/train/d_cartpole.py`

We have anonymized all of the paths used in the project. To reproduce the results, change the path to your project path. 