
lF jP.M.}q (X   protocol_versionqMX
   little_endianqX
   type_sizesq}q(X   shortqKX   intqKX   longqKuu.(X   moduleq cmodels
GCN
qX)   E:\liyouqi\coding\pygcnV2\pygcn\models.pyqX  class GCN(nn.Module):
    def __init__(self, nfeat, nhid, nclass, dropout):
        super(GCN, self).__init__()

        self.gc1 = GraphConvolution(nfeat, nhid)
        self.gc2 = GraphConvolution(nhid, nclass)
        self.dropout = dropout

    def forward(self, x, adj):
        x = F.relu(self.gc1(x, adj))
        x = F.dropout(x, self.dropout, training=self.training)
        x = self.gc2(x, adj)
        return F.log_softmax(x, dim=1)
qtqQ)q}q(X   trainingqX   _parametersqccollections
OrderedDict
q	)Rq
X   _buffersqh	)RqX   _backward_hooksq
h	)RqX   _forward_hooksqh	)RqX   _forward_pre_hooksqh	)RqX   _state_dict_hooksqh	)RqX   _load_state_dict_pre_hooksqh	)RqX   _modulesqh	)Rq(X   gc1q(h clayers
GraphConvolution
qX)   E:\liyouqi\coding\pygcnV2\pygcn\layers.pyqX  class GraphConvolution(Module):
    """
    Simple GCN layer, similar to https://arxiv.org/abs/1609.02907
    """

    def __init__(self, in_features, out_features, bias=True):
        super(GraphConvolution, self).__init__()
        self.in_features = in_features
        self.out_features = out_features
        self.weight = Parameter(torch.FloatTensor(in_features, out_features))
        if bias:
            self.bias = Parameter(torch.FloatTensor(out_features))
        else:
            self.register_parameter('bias', None)
        self.reset_parameters()

    def reset_parameters(self):
        stdv = 1. / math.sqrt(self.weight.size(1))
        self.weight.data.uniform_(-stdv, stdv)
        if self.bias is not None:
            self.bias.data.uniform_(-stdv, stdv)

    def forward(self, input, adj):
        support = torch.mm(input, self.weight)
        output = torch.spmm(adj, support)
        if self.bias is not None:
            return output + self.bias
        else:
            return output

    def __repr__(self):
        return self.__class__.__name__ + ' (' \
               + str(self.in_features) + ' -> ' \
               + str(self.out_features) + ')'
qtqQ)q}q(hhh	)Rq (X   weightq!ctorch._utils
_rebuild_parameter
q"ctorch._utils
_rebuild_tensor_v2
q#((X   storageq$ctorch
FloatStorage
q%X
   2009516976240q&X   cuda:0q'M@Ntq(QK MKq)KKq*h	)Rq+tq,Rq-h	)Rq.q/Rq0X   biasq1h"h#((h$h%X
   2009516975088q2X   cuda:0q3KNtq4QK Kq5Kq6h	)Rq7tq8Rq9h	)Rq:q;Rq<uhh	)Rq=h
h	)Rq>hh	)Rq?hh	)Rq@hh	)RqAhh	)RqBhh	)RqCX   in_featuresqDMX   out_featuresqEKubX   gc2qFh)qG}qH(hhh	)RqI(h!h"h#((h$h%X
   2009516975184qJX   cuda:0qKK0NtqLQK KKqMKKqNh	)RqOtqPRqQh	)RqRqSRqTh1h"h#((h$h%X
   2009516975856qUX   cuda:0qVKNtqWQK KqXKqYh	)RqZtq[Rq\h	)Rq]q^Rq_uhh	)Rq`h
h	)Rqahh	)Rqbhh	)Rqchh	)Rqdhh	)Rqehh	)RqfhDKhEKubuX   dropoutqgG?      ub.]q (X
   2009516975088qX
   2009516975184qX
   2009516975856qX
   2009516976240qe.       4p=F"=ra==h>=ڈX>dݟ=K=Y=:=@<=u,$>/2> =0       $6u{9سƴ?(?ؿ:?xܿs!???ۿݿY?()>(W?=?o	l=4m?ID @lέ?ȿe:߿??lL (?A|?6+<ȳ??0D쿃^?]?!Ͽ
,??y?b#ֿ       }=т@      Mp???ɢ#?Ԅo7I޾EP?ɺ??Cc>?	6_A>ւrP==>1E澕X~>p"? yV>2g<	=+6
󉾾O=As諽C'>=ąX>>4>=2x_==<L~E6HTY'}|U==2=3>q=CGm"ڽ>>׽ٵL/v=Ҽk:+=K<.hZf=<==Q=j$?.=<L=k6#I엽r>>y z?)?]z>ѽUS_>>3x維>-<>>b,?[o;a`V&~6s>2>g>f>3PI=VL";\=#M=Μv===l]=_y8uN=<.'=!<95>)U? ?`B¿)ɾGzM%>F?a?D֑H?qŉ<F<<
S<s*O7;E=4T=1a!=H<;'<Ϊ<M="+6
X>Ľ%W >>l$9W>P撾XLb8>[=*=_F>kĥ|ܯ= -><U9iY>.RԼ%=n===xل `<*&>u%$<+1ɽ|>;#ݽ`R=Y=,:>[J>t<hW#>4yW>?@;}>0%=]%e:W>ִ<n/s<I>~ 
<kF=Y6$=y>0=0\O>ɢyhN;o=#o>x>ڕ=33>96>*?>| >pˡAZ*мic?A?&>
d#8?5@Ͱ>>U>>.*<>_+2e>ݨ=m>4(ǾԬ;>g>jȎ>>>eq?>Ó>$Gyw=eUp(>R=j}>P!> 9>$s===uW=Ѷ14=^=%='@4:4Q"D筽R~˼?==;Z=ӓKý=U6E۽Eҹ=4n=P=ݾ~>>`$<5M.#1>>F86%OyT>d=<I+
>n.!9=X=3e>={> <Af_B>*5n1=R$>s=@쇝==uҷr\<V=~.>+=A^	>]q6\=+۵Aa>>6>V>3>5ý VN/$>.4h=
ކ>=Qc<JO^S<#>:>4.=ncst>x5>sPK?Q7>y,>~ި(UVaXO>d>??{V F?}3>U=Q>7^=pD
jB>et=^?׽=>[DS,l >=66<=ݽ*e
>'<lr >S>S>a=f<w=s6>V`!>c>cx%y;f>~6v"	HU>&h=	=ԗt>5`>Ό>Od=d<>
e<U8@>Y>!jt,ýK&}> f6=˱>N>茶G>g9Kž=N8t=Ԣ>	>]=jn8>N5ۛ>S?>ջΆ. <5٨Mz({Gh>	H??y|R?A6>}>?y?.b>oV>ZQD?H?T(?
EWk7?JM6X>*>C>[UK>ϼ85="u=>T>d&>~(B>04N===5G<׽盼<J=ʽST0
=/>&X4<
uٻ>+=f>T>ј[Sb>ĶoގPڼB>5ڀ<
n:=C
6<
=q;6<S=6O=f
q<x=ZE= = ;= 4=;<=`n
<޺M==Dj=$q<&<-=Ay<Dëd=E=;4>d|?>3WDzD̖=`0`Z>1c?>?d?1#$NOg2_O<?I>.=E?q~?2?}"rb?">!פA>
?7s>K==Zh=b>K$?:>ξľ_?_$:=āL74>	w=:;>[:Z>l>#=oa6~=<<5u>*>cd><ؽ>
kzh=Su>LE'>}>L7#;->;^>;@ڶ<=>a%>{=Mg*>v5;cg/J*5=ky;=0D=Tr1=Y@=Sz 1eiA^=J%=U3R=.=x]׼Jzí=b$=oȽ|=l==<[@0:<kٺ=fس7ؽ޽4=09==4g= ==WH=eWӽ7A>,>MIal:>/=~q=m-;<`ja=A=P=J=/=AT8o!>~<6>/=\̽.=; <Jm=Ń>4>7=^-6>}*680=ZT=U=-=w=gB<1w={=^=7$=m=Ȇ=) r#=LۿN>>B}7><
+TĽ6>=~?3Fʂ=C> !n=>&6rqP R+ҽ4>F<ܟ=jB="%=kW=WϴypJƽUE>>tq. 9>i9>}>b<!Z( }Oj=K?VdXν.>
>tý꽄>ֳ?<ǽ>y=O>*>f=r:=j>LV>x4=;ڽ{`>V|˩f> n
o1>޻ay֭D>;@>tB>>Z?m]>p;M!r$>VѺt>`nܽ=c=c>Z>nŽ>G:3Tx+=6J ö<=Kfk<đ=t7@1buT=&=N͔=mEӶ=&쁽x=

>p̽ҧV=];>Zf푽pV=j/=b=R(ʵ!H>>떽<=N:>a,<3#>7/̽+7z'>I<<"-	63#í<7vd>t=g#q>G>^n>3P=Or45)=W=<'~6>4>L>;ݽٙ\8E=n 8M#1=>n۽>ېs륽>^~ټIo=ہ˼
<>+i=vռ%N===x1<ƨx$=o71r<,bE>J+>B>հ=ɽ=='̛E<5>$>
u_'=5lg==m}=>w-ϤĽ6!=V=>=x<)8=6<
d=sH<+<]@= ;<Y\<9S!;u=M=u=輰>'[=efNS>>?>ɩ.>j7Q<)=
8<|b>ܑ>FT&j.>6k*V>Q>*(>LִjV-۽JA=PĽ]n̽Gx=<->н;@mQ>=7~Q>c\=oX>3Ͽ<^=t=>v>'=:.L>9=0jU=r"=5?XJ<=^SW$I&D=Ӫ=n
=صGw{=N)=\=`=@F=X%$`=3+<&钸=<>_:=*<Vti=eS`S>	\c<H>X>Ԑ=>rz;G&>gA>ƣ>i}u5d>>HF>=A2	9>'5i%?ýFd>R*~>]֘2ӫ=C#<`,<v=?<< )=g֭=<w$<=@=T<g6k;m9;=F0;=(;<Y弲c0<xb<w<WBB˝5v=Mq>=C?U=83E׼g3J=D>d><ԃAb>L7l6.>檼>3>
	>]	99eE>O8<.=C6;}<K9g=[<xp M鑽6>={B%=8=<:+>q=*5E>t%N=#w& =O;-Z=D>!;z)=.6V>mE>N>Ɍ84;ٽv	W==+(>Եݽ>Yn6w;>< >=@l@EZ_>%
uyW<BU>o8:;eɴx<IT?=
7=1<<7y=?d$0O=<qH<=[b+f5=6a=/PO|,><Խo=A=M=c=E@ǻ9=[/=[={6S7>T<'B>ǥ<-&)
>>j_X>W*>|>0y>Œ62:A=L
<Q:t&:JZm="=y<;Dxݟ==K<vñG=aLO==S(=c<"=2,%ss;G===	d۬="6]>JX}>h>nǝӼW)?MK<;F5Xw>iS<=fwC>bfU3>p>(J<>;Hv8^V>2=}:=>86=8d=t=[2_=5=v;! <
]}G==d=Υ5]=NW=XF=_Mc =>n4ļnB%2\k=)TM=^=]˜6 ^cѾִ?Mmh>>>;8>}?@ <[	Z D?A/?ݿ\#6nzK#S<\>")>>C>@>ڤ8FY>;!>O\f<1iн=-$>Ն=ý=">D=7Zd=U=* [m>H'>Pf>x`;we5> s.sF>>WD<DT=.4>Ұ>UX>,:	=PΟK;Ow
>jŷ>`> 0u [>l-6j;	=Z	^7+r>Sh=N=\5>>>jM=u9<N:M(=j.6j>s==r=;4w<!>[R5SLM_= >$0BL=s=V<[==:3W">$M%)y0( >d.=?<Fcm=&b==E=DC͒=\]D<c=f8̛m
p=!.=>#=._>=>n->wd>$>=% =y<=q46HR==/q=;.0=b)\^<<w~=G=?7=%=Y]P_v͓?S J>-n=_b>%xY>k\>J<R>#=ڻ~4>B=	*[>w=9r}>4KFX<^ <]>]Ƚ}="o5> 
鹓>>Ⱦ?l ?F_m>b<=ȲMn5_>-%33>>ѬQ2>KdZ}XF
:r>=X=>	a҈3 `=p>į>x-U>}}>K>mk'ʐ>EB>D"=kI=4i=(:KA=`~S=8<T=:<=z=;̏l=dܝ(=h#.<=%=iw=C=<eyO=m;=6,=G}=5!ҵ=E>>kB|]=AOP=t
>Z܃=HU5OHK=	s=U'>t?#>z8>==ȿbHE[A>J>ý*ݼi=cgż<X=yu=g=I===m_%&b=k<%<74x=D>wA>ba	>[-iő>/<?/>;l>5RUJL>bW>>(
A>γ>#
?e>ɼ [>6>U];쑴=ԅ=۽04.;6R>g.>=|<G/G=׻|5<QO>4=}?5=7 _H;ZX=P=	%>UC=D=Q6Tý`xͽYϫ9E=4m=a-)=ڛ==żsҽ=뷄=Um 9ժ٨0>
FwB>1,>-1A>b>K>=@k.> >D/u$={=\C>{-ֽN=ua>=O<4c=	>a
>{N{9=l==R==.SF<=C~y%mU<'=[Uμqr<Oi{\=5-k=<=9,<Z=C/<qNFϚ=%=j/=2m[.>C>i>~E=]AE">H#`I0pH>_
?.7lZ>6SF=ɶeɿ ==Tp=b=sd1PF8Ő<g= ӡ=}={>>?ݽiO>ߌ>
>]Пf>
/>
,NI>1;>Όv=C'<^>:0KUF;>s`F,W57@?*$	?m>+	wX?8PKy|,?ꅼ`i=0f+sۭ\XTF0@=ח6=*=5s<=Vߑr;ť=J=OGE#5 Ƃ%<70sTF=<b
i<==9	ĮZ*<e*4=;6wY!|ơ<=?+= 
=K>=ϗ%Yua="=&y;Ȋ	O0+B==%>V>Z"v)>bo>>Ký/"3R>Y-:>5-Οڽ	>{$=f?M=;b=#<Cr"۽'L%>9$>6=d===%<l>o'섽؂CΈv=><@j=jZ{$XJ7M>
]=)b=WX;H-</F]mv]>|y=\6lK=u	6#<;>2+>e>7v=0f=\&=@6>@I>5fM3]N>_30>)[}=nc=D3>٪=
3i==g弉.3
1T;=XM=7z=7i=2R=m
5`<u=@ =h4 X{F1@=;=5*=0]==qn<Lh.Z=鰧=NLX/6>6Ž=YL>s}<gb>
@i1c1Խ>aIG<4A4"-9-zǼ&->k=zVl>&2>>f;)5	>h=zXB|5r=n۾>s=v>twrK=>0w",==M=ƚ86սǼrRh=i=E>/4.?>2>O=9%>.>@O6⾼=w΅I?:>	>1A??=g=侎3>}=8=<Yb6d=^h k=<ܽ=oG=K=f=ݥz<AKE=hS<o1>ㅗ=`>I>ޖ>Q=~n@=9zT=R;@=\ҶD>:>ș>iE=oS2C>Awpy3[{=\>yZ1@=X5V\G;RK2Z<:=ա=;כ=a=e=&aمӍ=}=oն6O\*_|117>>/>I-=RQrE$3.>eE>$ZF5ɫMX<:[<==H=ƪ=T=T<Q=ޕq==hVZ5b>^k>צ>
=5Ź>S-8f.=Gl>%>O(b>M͵^pt=򽽵 |v>T͙=9`>>>,j=HEo==Qh<X}6!
>WG=X.>1m`<f>ucdzbK
>P=݊=y3Й=d-=>"<Dz> =Obne>9>L>ٲ=,5;6W< <=Vwq5ua<ah=U<玼|=i<+"!3x=lr=?=$=jb}<Q-<@=;6V9>-7E=b?>\5E@>eLV~eg :_> <5hr򆽬Nv6m<=-L=w%g=.=."e=UĽ(޲=9ɔ=c!I/ Rh<=T<νȩ=r/	ո;<N=]P >$+<d娭=	5/=!UŴt
=
<sl=j=t>=k"$6n=q 0Ѽl=b<=q=&=Y=;=N=/=)=O>=f)Sn=Ow"½F;ɺ0=>k=ƽXR>L4k<}c=O=2P<v{<ZM|L]V<ǜ<}<<FZ:Vƶ
	$Kѽ"=O<h=˰<]D=ya=)=DKcl>I>
p5hjV!><2#ݘ>Hr	Ro=i=Ζ>>=S}~>5# (?!ݾ>i??PwJ??O
-"1vCN?p=,b>a )5~>>q=4
yļ.ؽɽ5;=(>'8cw>]e63ؾB9>J>|>9~Ge>>Ѕ>N٬澶>=>#dR-<\.匴=:j*a=:=<qc=MK!&V0=C=jhBko>qe>8>)]fۼ̼ѽ<b3,+=r8>4"?>{3M6;#>J\== =o'M=$<[mw==9懽'¼W= B> +<5=$>o*h
k>D^T^s<b7><ik/=/Q#2a{^==o=
t&;{4؟>Ja<\>K=;=6.NR=*>+X=	I2=1;[~=3z>c/X>u=⊼$>N>1>>k>hPm`.>Vr詾rz;>b?Q[þ>]A@6d>s?UK>HV>)n>s{TPF~ｎ>|!Jv=MH:;>$?g>$>y<lv>?y>W"?Rl.=->>z]1<_ a=GyFZ$l=*>!>Tܿ7ҽ
W>He
>>K=_/mjE=՛PƼȂ<C=P))>5Ƽ >
>/!=~`==YJ&Ҽs@>Frмv<=|Q`;Kn<k?8>V?`	>";˾j>>JҾOƾS="?ͪ>>};>ڻ-:z=b=X&|U">Bڽңr˽ɾO>+<<k>,=/=>vN=<v<d2ʇSPL=l=ۙҽ=15%,J= >F=eIlr=4(Tg`[W[=l=
D.Y=}6/PU>J>)4U>L<O1<s	!]ͽVս]=5>2>嘅쀒K>V?ܪ<g-`9;8>=Q> (>>GHx4U=j =cμ+̵n=<!?<b=+ՙ<>
<fkKS==B=۞\j25s=ʽ^< =zZ$x=?=_ErQ<LJ==ݽ#x=!>?o>6UH>uF\^f@u;B>>՞*>Xǧ	?U6T>lc?jj>N=8u9yM>̴V?9>k+_6(Z?'<>$4=*[f->۽F-<YZ=Q>f>=84?`ٙ>e)m׼ӀF/=){=DA==N
=?~4;s=ma=he4Q>>m<f>ֽ_"$h>vh!>.O>(cє>Q-4Ѳ=	s4=t>޾5=m%>?.eu/ls[=+]=7=#y9/!>`u=ї/>3zpB|9<9b)۽ɟ(m=m6>jG
~wY=ҵ^i(>TJ72>mA> 6FB.>Otg&_3y~O>[T<v=ڽkA<{@p=¼<9V
>
<u8!~c=g =F="=~s<<?;1=!=>7f>bw>=O1r>37~u^|1w->> 76>V5 =~M==c<e3;7w<`Z=BE=Z;=8=ģ==<Um=K+6>)W; ==2ֽctHC>!Žֽܻ`[>t;f
h3;E6)<
-pֽ?>>W t>e>Z>=d>BQ=N=J#;
N5Mx* Ud*q4?6w>EV ?;?+?ɾج>>A66w=Mh.~S_>"Ln{==r>=>͎zս#K潬>6́?>S-<JS>pk=ՎY_A.:>w%P;}ѻ!M>#;v6r=SJ4>L<s=Dgu 8<*k==>9&=_t<fiJ9@>6_B->}Khq>н|YMD> >6>霏>
YHŽ->!Ē6n=6&z }>_7t6=*>>w%<W<@5O^-=6Y>m>Fk=ZD>>&ֳ;H3"gr,ϽO=&>Zm>\0>
ص1m跽 H=!=b>m>\->mB>N=!sʥ&>'>P?n6==>e;~=E!Z=FW=2==>D=1>;^;t=&]ͼÎ۽BT>>]>L>>na=y-@^>>1逼Ya/<n<];=D<g=<F'=6%=޼13<~g;SǇCA+8	7޻v.-|=
l0=<޷;=	v='jEڼ0<-==fEjŶ5uB=`O=<or>b=>ꤑ=&Ͻ,<.<(5 _=A<3=[;Q
髡=8B.UlԹ<tj<5 3rٽ<Ǽ=[A=ƍ=<ՙ;ѽ؛qDs	>=KzB+>Oǽ=Q>r,߼
>
%i,>i=O=mcս75!:>=1>ġ-X<>$O%=*ξh4=)>d>^Bq5\(0m~>G=T>bD(Q~,!>YF>%Ze{xLQ\0U>"&>XL>>@>@'4>2=伃5?N`ҝj>(>楾{>2>\>P`w>>>nzt59ʼ>L>qUP0킽V0>	H=ra=c=->]=Tڙ<CM;RYh%=5=l"va={<>z<2^>F%4 =[=	=A=dF6HU>Y9^}=	$C>r5k=v>佅"_k6>=>Ԋ1>6s8>ke@>Y>׾m2=.?N㟾3ha>=nB>j{6G")/>n>$<=`I෨==x=b;½	=U=<I6෾,q*zF*>9x>JM>P<?
I>ohk䈾>SZ>Ѵ
*6==蔡<zv<$;$k2=F==Xt<O<<Y~=5=ӼiW%0=ƾ5\<-b>u3=jc>AN¦*=yޛ=,>b>,%<~*M
>n06CR+1h G>_=녾Z\_>r>z&.>?\
>5=SnǵH缼wYr*<+%B=ԺDû\<=\٫=ټ'*2:tb4`Bk̽ʮ> >Ѿ1>x>>&/uT>(>w15bYܥV===T(=+=3><
޽M3≯>/2~>n<C{>1u> ~j>rS
7ڦ>ه';/d9F6E*A=~=y ,=C=B<3=N:{=K=99еw	=wwG=(Q>`E<>䇽+LpbC
=[
=ZH=
62>$D>@>AU4+<xnM=֪>1!>KEP>q絾H>
~=J>{<j.=V ?*ܽ7TN	^>= S&>*Ǖ6g=*Zpom=+m=Ѽ2,>(;Ï&]} <:=,3wڻE!6d=8o\Y<P->^|b=>Wd	&5YvD=t`>+F>qX| ;?DQO>)?9OAcx?xپ<%˾{? ;=X>F&6ѯ>,}>>m-	 V@ևyOH<vA>>po>x2|;N>VO9
>v><>Mt
lz3>X];=Fs=Gޭcߋ6k>o1>H>,X6i> =?=Ad=hwp>?	K.>6A ?fo>P$?p*`X<i?ﾹ^A>ԾP>>n>پm>4
:>O>JqEݻ̚>+)quE>UT#=(`b55ʉ=8@n⻸!>:3_=	z[>cf;.;xA	 yV<#8>Y*>pEx槶*=1==n$Yv:`.{S:(߼
}ɼ<=6=<3߭=X67=㈜Ok=@>~ݽ~<OI>w0.bSሜ-l >OF=pI=]j2 >di>P>ʾ/<!?B\{̀5g>=.>[I5X랎~x=9_݉<ýU=M;3=j'ր\t]
=#=\5pj+7XSo>:=
F4>DR>k	>K)sh+>:>w0 `>>>^K>
?Zs>')?>%{$v6:>Ry>>Qo='>% :@ =>;YO>
6ٖp=hν$><# K*=nY
>C>=k|ѽ&J=Q6.=*=v=ld8=8c=>pӼj>R"=&=T<f;i&c=f6n>1žk^=)
?0W5>?gaVS1A پ!->u>> پ־kT"=q<Z<x=BI;:]=?=J=E=<{c=Od=;5B1>CZ=P>b==@ "j>4a>z3haSkw9B 7f6>ވ=߿h>S <M<*75Ԉ@>L?>dT
QW=./<>dd=)L@>ng A
O=]=ذ=,C"6-=݌<[w>F~=N>ESU	
ӽ*v=(=h=/_862IѼ@9-	3>=E>IR>'>3μJKT>֙=A%#h5E
/ȼ=s=	zU=Y׺/=u(>v= 
QH
4=&v=5.G=Y;&B,>H=hjrQ[>[>$X>$<RnV=U|=	s<4m2.S<_l,8e=u=ǣ=X=
='="L{><;a-=5?Znҽd><>L+h+?Qbh!0~e>\y=Z:_OԼ:ѽDwjz===<j='=C=摄
>s=r 5K
=hguU=|q=K\ =(=*=V<ihc=l<<
/6.iB>Uy':	=]>S8<>gIͼq8sb>)=	>qzs?=hAt =/>81<f>\mG2㽹|==!=<-kTK2B$>q߻i=#>}=Qbb=PURexLA>g==)3u[>>|Q>@whғU[}rn8<W>ֺ>YU9>
dDz"=ˢ==deL.>BA>>=/<2\)>=[ս]-#Ƭ\x?=y.=\=-=Y >ء>=o38}5>7&>+k86ؼ(a'p޽s>>pئ	=>|>{>)Q>d@>0 }/ɶ}%+o]`^>D=Atٖ->c>T4>(e'=3=7<3d>w¯OP=T>:/Ǿ=?kK `Zrξ
>H?>*lz>ȾqP>A>x	>vݽCi=y6`S</)9e>H>+{W>ǳ{Ӽ&4𠷼b==!,==Ʃϼ?=Ȫ 6)=2=7066"Hսν*"=5[<%==l=#Fy=Ҁ4PO>=ub6߸=>9A=#>0)<?D>׶｠`x=Ӭ
=#v=N":<=2=t=h<D8:G<sӗ=`9<Xa<p&lp[<
<m;ͯ^5R>޽$z=T9.>`[	;Rh>H+7Rx)===/OQ66N0춐=o=-lr==k}=8:<=
=d.]1%="0
l>\=:V
8>h>0><$j]3;">.=N06P2>g>A>N=1#I#UWoc> >-L>2)ۨ>,%t8< >8>V-Yҟ>>ʊ%>wŽ/	m>^>irה>)h>x>Q/<>Iq־ˬ:>[<<뾰O:T2:=S>=|[==">t?=Լ(>2%>+}O'5%>X??E Ͼ4>k~W+T-?0my?M ?*8p?|iN>&?ޔ>'C=DUw1lB&>?	>!Yg&?gL5=>u>tqry=lC<>
֒>6>Чo>!3B=ݛۻ;I=-3
=>S<Z=UHӼ䅽Y<X="=K&A)uK` 4>+>#J>2*>">WJ>>ظbZᦳ/>H1=Y[>aW>q_0^=>R=_L=Aqζ9<|>=<ϴ=>3׽h;.;5>sy>O=bnZ>2d>Gf}:=X>=7Ҏ=w/A༠=t=V\,>9=)#UZ>˶>>g$r
>">`>oɽyZ-u>h
<,\=VlLOۼ"9>F~="O>}M$9ý'={=߫Eyrr>q=A>]&>Bw l>w{0MCd<Ԃ>$^)=,wPMĽ]܃==4=u;[!>3>͹=JBW24>L3(>?U3D5wFuޗۼ*F=s=`=<7r=Q=n]=$; ==l3W5/'N=7>=ɽ=#'
g%Id=[B><=B
[!>0׃6!=KiE>0K=06C=:ȽH?pTf>&;`>0<7 5I>ad䶾Ӳɽ`L>g'>E>fV>qm>2dH>4h>m8l!#>=6X>гB=#$>9U+&F?=z=&=Y7Y6@Jҽ@=͛=_={Z[>605>F=yx/>V>Ư6i>Ť=6>8M-Tx>L<M$ e Hu֮T>n*<ʽ060=3;P,=gr]=PjA7=0!}c0f&=}<ɐ;nջu\=7>B&>4=Ŭ#iiУ>>+>%k􈾹>5_,>yDjx>T>fԾt>6^ZپHRC>I$&<wjN5Kf>$L>X><C彰=PL4Gf >>rǤ"> KE6W3=jb뼲<OY=IH;=X'м=@N;f%=rx䄶1A=u+Y,">v=̽[==Kq>4=t=j<[=o6C=:?=G¿=@{Җcr-=1IXP<==8U\P>*L>A>Z>iYW8ѽY=Xj̽ݖ>u>`&^u;8>Ro5	 >=>L=qQ{4+>eݽݽ߫Rq=5H>L@)M&Z=
5<]=52=y;؝=qݽ|<r)<=L=
>y=KZ]'{=2*Wq==<= ==n>=s/߽N*>X> 6=$.x.=*%|F=:=R=78<PLh6 ==er|DUR!=dŻ9M<ǳ>Ι=>Sv#Ѽq=4>L|>u}B81>(=8=²=
o^>?ǽ	 r<<>u<ŭ=.==zw6> ƽy=elR>Q5<Zr<ӰW
`'>->м69ͽ	l Do=<f-E=r$=X==* w=+<!OM=~ɽ<F&>I`v=05;>t-Ǽֽᷠ87<=s=	>oӽ4^+>>%>׬x.<ת>=P>F>kb{>ڼ:[FŬ=-<}=I=V=)L=pxSh=i=tQǽύ6Ľ<>_$b/{>t<Cj!=>ن>s>Ll߬Ƚ-=g.ؖ`f8>,W?	=H>?R=l=.A޽o0>rO+>'9	6ꈏ>k.+>1>m> +c3l@>,7r:4G=pZK>kH<nb>=>g=s?+Z;{=S6 \<<oҽK<)>]=>>0*>G=%㖡=2=~<XU>bɼ=|>>]޾37?m1¾D>!P;;<LսEM5m>dj=()
?-	>?Iy Ǿ?>>'>ˊ_=2+<O1=	=O}P'[&=3Z="qݼ_H<r==<h<B2~0b>v
>ϕ>5kD=cX>x5"q/f>kG= =CM5Z|>)_>?	2=\?t?վ~پ7)t|>3=cE><Ѩ<oy=1U=er;嬼0=R@m<5tU=x=(=i5?=a
>q=W.q='3̽,ļhֻ:aw<=yXu=0{peok=8
	"{ԋɽLa1/Ih>/=6@>'ր>":>׼ujA>3>{*4RXذ'˽0=-i=R= e=\ 
>W=9CFk,=>սD0>>l>K5D>MuϻE>0N=.c6=I><wv=UtFs676=E!- 2>)=GC>?<	=̽bEVT4)>n>4`$	B=à=Y=xD:.%aב<=O jn{==-g%'m=Њ6v5>=i>ە; 2=1]ob:I=->=r_A=+ؕ6&JE>Ĳ>$>fA\P;8XꚽH
0o۽˳=)S>tz>GT2lȃ>NaW==b=ƺ<(K<7ȼM=	d+<=ܑ=K=?AμUN<[5,>2h>(:ȓOY==j>R$=8CJjɽI*>˵ D!oZ>mû&=ټ*s-=<|>o8>@+<l(vG3>G`$6c>?Ai>H㩾2>dTkh& !>n
?>.ݎ oY>$6M`?H쾝>sv?VC],?= F:QyiQ?>`>`x.5}eѢ1нV<v_=
=,s>S#>/ >2-I=ȸ=Hm.j6|6Q4>	9dIP>wt7R==<>+>c,;2!2v=H=jz=:=s<1:ܢm<mѻw6<<L=5<t<y<6a%>=+=uɽ?E(/>`>a,Ȼ=>It0;~ꮌa=XRǼI>zRl=az>f<u=>ڽHv4^ =w'>$>R266ua>B>TK>)z<+7<uv~=w~><a>yꜾ{噾>deN_>>C>=JSSB<Kl5>L>>d;3;Z>.%Nѽ Ըa2<nf<<.	t==4=:E=wZ=
93'Y^C`=<i=D=w=y=j3)FV=m=nyҽ$>I@[>/<}ND-=>LW>'>G*
[I'>ٰ4C ^!%(>;>/24>->ڍ><Ӽʾmj>">ʽJ-57=_!>k= t=d,Gpߡ<
==4= ޽.+>$梵I>\8>,e\>!Խai{>6ڽ%9Sg>O<T= 6wܬ0Cp=>Us>}>hI>98>(t ?'>P 5Φ<8,鼏9<=hnͼRP== 
<Erz)=h	=h=zZ 5?;-Wռo=<R<w=|+*=Vz`<w=p<fqt;]5;= ={ x>r1>X>I3+#>	3
оa˽Qү>P&=i=?5t1>z6sO%>:4>|5-Zm>dѽmFER=zܼ< =͟:5=I>=P^H=3Fѯ
hݼtA==P>
>%]t
>O?<t4<8=&¼s=^V=
<pqLa]=.[=<=％H5't>ZA>ll>}YDfɼ{s=ml|>T>er@>U6s<=H>=͚	亻@{R$a=C=Vq>Ͻ7>=4:==Ͼ=4Z3|=Žp|"c,=c&<aO-6#>=?p>MJޟ= 0YBC=|>W-+ը=*൩|y>>bJ>g]Ks=e=2>->-Ssݽ)&_>:l6Er=F3=I=?;Wg*<Ja=8w^<1S=%!3=:=Y6=D_C> >Lݽy<'ZE2vνN":=j>S4>MX!2>f><=%>wM<!2>?͒՟-%<!>%=j=5fh58%>=
>&Kܽ>9m0!Zlo=l>,xm=FW[4U=C!?<= J$==<<ϻW=~=@a=2?4\_@so	=r0}=O|=	E=~==zB=Fޟ=A6~|Ty%J2GxI=к=Xd;L0=x>am==<jW(>=	c;
&6E=l~%<?ф>3t*?q-?)H?K:>Ћ>SE!6#=Xӏ[>U=%dK>{1N<i @Vx7C=",>9>^\6Px<.*=e=C<= AS1: \:==MUH=Fpr4x=Dl|=>A+=>m#(T"J+>S>J>;C@gy6i>1ٽ)=#>"9}aF>DнP>=^=A {5oi:>0>< f
>6b,̍<T>>C>J޽<FǽٽM>1c#5X&=kC˽ӻ>R叽==j9c󽁌===f߽O"';BO	ʽ?%L>#o==t>GQ>Kk>~T%>=`>\P=Y?L⾼>QN?bl'`ekL>_><> @aL=y<v==="ԛ=l鮽T$nȘﻪ=~ʻLD=du>^~>Q>,_#=~.A=c.^>P>u7>eW:>>g?PU>Rt;Ts=_밾K=.0>E>߾,>Kv	 h= 1=;=@<گ= <35א?=컽<F
=q@X=. >>-Xm0ڽ'x=۽m,_>K3>M\>Cd*z8T5oL=\>BL>/2>};>c>
Xe>M>"EYN[=Ȁ3z=ی
>y<tL@>5)t9:5c=d=UV=A)^4ƾe)7_kr>61>܋[WE>w> >HN¾P>Q>i?5ũ=M6~<=ѽǗK=m(=c<A<cHy6g9B␩E->=e2>>F>ħ
<
+>==ҐA#==!ɽ?=W===Q[Ă
="=C=@N*~YV$#>x=-mD>D>((>(
:.<=|T=qȍҵ-4"Q \qA==*,4>
>ޚ=ܯp)c=f~=Mq;5	bor=5>=ے>Z>>I=o=\|i='=l.~=)BP=&>c=Z>PR{*)dӽv=t8h=s=4<@;hw=<=ؼYrJ݆=m;=g&=;E5O">:P=F&>?7AlzX>l߃9ںk,=>'=	=#nN4Fm>0=v>C;q>Kx}H'i_>p=Z=$"kR==4={>">\=('>,B>
؎6[r;{)c7>4=0Ž >b56>_*>Oƻ
o>#=6mB>{3=>>}d9o؎>)ZO7nf><{=$؞t>ك>C>(RxY=fl98۽E .>>|>~3;>:J`4K=.(E=w=k2=;
+R=(x2;L=~=)Kǻ<F>cW>D->ϩ¾d>fSپG9>(k=RAk<IF<S<{N

!=>=x\<99=.=ܤ===<<z<rD=jP蚾e1޽l܉><|>R>>@}>>8e>znJ>>[`Td>KI>I>#53ʸ>Q@~ӬĽJ>5dL댼Z
ڃ5:VWyg*0fѽI>>㬅5s>>ļ>k=&gV>>p<8+>7Zj8=ף>ޥS=>e}%=5>zF>܊:
?C#>=:k.=@;~<5=<C<͍90~o=#(J=~V5#?>?	;9@?lоV L8ޕ	?Ǡ==;>U턾txz0=y@==^$<_=lKlKn'=>XN/=:M=n/N=2d=$=\;ǭ<mҼt=#0UBI[V=4>G*ʰg="52>>>2|p=Aeyf!
>+>(>I͇]f>d6f>yd=>)>ݑ\Ik?~c宾'>U<Rdy=o 21"U;|0Ͻ#JɽW>6>>}>>5>NNO"Vv>@4>V\cwbƎ=NQ>ߐ=K,A\0,[jJ{̍==0k=4.j='885_c>f>=2:=8=5>u=D|PXX=Eu<hh==N5[/=U=@=J^ڼ|Q=fYQ=lּd&6.󅲽H=\<GH=K=D=Hz=W
=<8k~b==t 49==m=g%=^0#t=@hv	3cM=->RU=bJ6T	L{й_-<=_><=n=X==Z!K۽$V=	r<*-%{yC,Dy>|=ΫL>#V>/8>/Q}O?>=ν6
ֽ%=knC+_dM=FX<0!J2Yo.kk;=W=hĶsa=<򃉽_=μLb4k+=,A)=Y=A2T9=ξ	>J>tx>GdC>{nk'ɽm>+>Chj>¾5˾>wn#:>߽Zd">7`# pN>6,x>ݑ>MG>ݽUJ	>Nʸd;ַμB,>쇿=0
5|>>唚><$z:@;fA#=l6E:6=F<Pf=QHۼ<:/N=#=^7}=;=}==s5Q=x>=+
)W=􉕽ƽBW)U=:&7>D=!"O>K5dP;>=|E>#=B3 н>@B<|qPd<6>U|=[5Zh\&>$~.=k:=;x}=7$Hh;N>I>ɽ,4y3y>=ޖ8n>Ԑ$z}=[u=Ӏ>ȩ>mP@k>#A4? ؽ]>>OƾiOq!?~nΫ3g>ռsF@=w`4j=AO
 ->0& {==8>=UY_Hs>lj5y
F?	>%A?.y
2?0~iX-?J=O>X~6e Olp9!e%?J>H;?O?u0?GJx28.>>="HY5W@jԶ3뼱>Ϩ=t >f>0=An?w=|=N6Jxz(Ld>U-a0=a>Gѽ? jr}=A<->čV>\hPA⾓ľɐ>>o>"mQ%>q
>
=Jξ?C>5.	6=VWgI~
">16<:Ob:>iF>^>W{">iɡƽ1>E0=-Or?{>EW?v?IZ?S@0S'?>ꉾH6o=s
s7ۼe=H=+@=>$<ޏ==iթBѡ;7>- >c*ߵ(*u]Ɛ>h&>':S<>f>ڧ>^y%ݼ~k>=>+x@>=B >=Z񶸺i
8>`eCS_CK3Y>#E?}u<·6릯޽K@>,===s=wڽ#<F=fh=νv4W>L>=uxZVE>%B0]vxJ>qb4 ©<PaP@=<L }H>`C;==>ӅL>wʫ=׽
R<Ty5=6{=Մ#>W=AC/r8<xfaI;a+>>3Ͻ"=@
5ϸb3%l5} ?z/>n¾p2?r?>\ھܩ>Gg>ǽ\Ƕ=ML=\:
>;?H<>OWܥmHԼSk=-=b=2
5@dV}<^n@%;^^;goP<m߬;a;1p':R<x::=Ί:ಽ:ڽ!,
>#v=3|oպ='>k=:7H/=%=ϼZw vEFN1>
+=Jh W>Oz'>2>I<CWf=c^==m6= ?=O=d0=@hPݻ=;ͣDOS<V>kHp
=(RxM><v>O=sY#dB>xꬽʖj,>[4MQI5@ب>+q=D$?=lB?JgJNB4ST!{>>[>Ce6ɝ<ʬ[-[jE)<w80+<|λҒ<uR=Լ^:<MCP=v=>d;=Q'>gS"06?La>FW>nscC>Bo:>$9>
<)eӍ=|Gy<|V->
%.>> @@>DS!<9_<]V=@<`cu><<<|M<;&9;<)HȻ<v6>h&/=	>$>q_8M>;O|D:hA5><=f<#I>rrj=B>F<,>i.] =vl<ȟX=rlu6 1!(=Θk¾0?2>J?e)?B?I=&B="Y=|=6/5f9 >O>r?0??>yK>v>wE}%}68ݩ==8t=:;><q\<yE0'=,=~<=.h#.=i6.>EA>qS>־K=?ˋqpCw>u+=c=)zs= =᷻=ƒ<Wȴ3M@=jxܽ~z\=P=ʖm0V$ko=6YA<,;_2= P=1R>K
=\<[Bmr=-=k34<K?=	?sʽӤM}>am>A??%
n=5𾫠>	=8w>3=u<0ڽk@Ž$e4>{u>Dx=h?tJaz6>Ek>RT>?s>P>⹾]nT'XC1>A?'R> t+4?M8)=M=p=Ò=[8Ӕ=rͼPJ<ql=Zq<~Z/>Q>A>퀽м彷<, <0[>%o>ÝKMf>>܍6$iy|=P$@Uh><®>͔@>[>(>>ǘ>>V1t:⫽'q<w=#@=C= =T=pW``!==!Ù5(Jp'Ռ5,> L>*|>>*g>&<J>Z2>Be5{=}#==7[p)E>?&?˽tn= =<n.d3Ъ	ED) dx<>=!O\}>ƥ>k>Ƀ<BW==j]Be=U>l= ˈsM*ֽRf<sL>]3>y*<>SP624c16f=̎=z=ќ=<<趈=..<vc='>u3o=>q=ĩw=|ѽ jqVO<*>C>+~=XS>],6^===l57l;:|;O2=U=d5=Fi<i`<J>`6f7=ޕ;UY=r[=w݉=TWhӽR=;n=)u=6aݻ}6F>@<$=N޵=`=;>'&/?=0\#><敽]Vu"Շ#	6>6=b>DZ.= >@.ln>4ڳ==\kXGx>c}uɸ>`0>Bͥ>I>f>=E1k>!0>Deͽ}5 X%<>S=6x0>v>B=I>=zT<*El	+(u?F4>꾗K??#y?nE?@"%?4 ?Qy6?>|?D#=ч뾶ϱ>/4?B S?@S6>!>-c,{>I>>㏠$žx㾃oe>dFqS8Sl)eUͼh\ӽw>R=V!>m>6a>~=J=g=4ļ