"""Config class for input hyperparameters"""
import os
import ast
import json


class Config(object):
	def __init__(self, cur_config_path, kwargs=None):
		# SA Hyperparameters
		self.vec_dir = 'vectors/foo'
		self.rseed = 1
		self.T_min = 5
		self.r_temp = 208074.409
		self.iter_min = 135
		self.iter_max = 270
		self.n_out_loop = 200
		self.n_in_loop = 1500
		self.low_tem = 0.95

		# Objective Hyperparameters
		self.k = 4000   # smoothing factor for PMI computation
		self.beta = 0.3 # control bias
		self.tau = 0.02 # control PMI
		self.num_w = 30    # weight scale

		if cur_config_path:
			self.__dict__.update(json.load(open(cur_config_path)))

		if kwargs:
			self.update_kwargs(kwargs)
			if self.vec_dir:
				vec_name = self.vec_dir.split('/')[-1]
				self.out_dir = os.path.join("exp_params/", vec_name)
				if not os.path.exists(self.out_dir):
					 os.makedirs(self.out_dir)
				if self.out_dir is not None:
					self.save_config(os.path.join(self.out_dir, "config.json"))
			else:
				print("Please enter a valid vector datapath.")

	def update_kwargs(self, kwargs):
		for (k, v) in kwargs.items():
			try:
				v = ast.literal_eval(v)
			except:
				v = v
			setattr(self, k, v)

	def save_config(self, filename):
		with open(filename, 'w+') as f:
			f.write(json.dumps(self.__dict__, indent=4, sort_keys=True))
			f.write('\n')

