import argparse as args 
import cv2
import random
import numpy as np

def mask_generate(mask_num, patch_width, mask_ratio, path):
    for i in range(mask_num):
        mask=np.zeros((512,512,3))
        patch_num=512//patch_width
        for x in range(int(patch_num)):
            for y in range(int(patch_num)):
                seed=random.random()
                if seed<mask_ratio:
                    mask[x*patch_width:(x+1)*patch_width,y*patch_width:(y+1)*patch_width,:]=255
        cv2.imwrite(path+"/"+str(i)+".png",mask)



    return 1
def main(args):
    mask_generate(args.mask_num,args.patch_width,args.mask_ratio,args.path)

if __name__=="__main__":
    args=args.ArgumentParser()
    args.add_argument("--mask_num",type=int,default=100,help="the number of masks to generate")
    args.add_argument("--path",type=str,default="mask_patch",help="the path to store the generated masks")
    args.add_argument("--patch_width",type=int,default=16,help="the width of the patch in the form of pixels")
    args.add_argument("--mask_ratio",type=float,default=0.4,help="the ratio that a patch is masked")
    main(args.parse_args())
