# Black-Prom tinyimagnet Usage

## Training
Example .sh environmnet variables as shown below:

```
export num_sample=<number of samples: 1000 or 50000>
export num_shadow=<number of models: 20 or 15>
export poison_rate=0.200
export dataset=<type of dataset: cifar10, gtsrb, tinyimagenet, imagenet>
export attack=<type of attack: none, badnet, adaptive_blend, adaptive_patch, SIG, TaCT, trojan, WaNet...>
export model=<type of model: shadow or target>
export exp_name="${model}_${dataset}_${num_sample}_${attack}"
```

**Modify `dataset=<cifar10, gtsrb, tinyimagenet, imagenet>` when trainning with a differen dataset.**
### Train Shadow models
1. Open `badnet.sh` and set `num_sample=1000`, `num_shadow=20`, `attack=badnet`, `model=shadow`.

Run:
```
bash ./backdoor/badnet.sh
```

2. Open `none.sh` and repeat the steps in **1**, but change `attack=none`.

Run:
```
bash ./backdoor/none.sh
```
### Train Target models
3. Open `badnet.sh` and set `num_sample=50000`, `num_shadow=15`, `attack=badnet`, `model=target`.

Run:
```
bash ./backdoor/badnet.sh
```

4. Open `none.sh` and repeat the steps in **3**, but change `attack=none`.

Run:
```
bash ./backdoor/none.sh
```

5. Open `blend.sh` and repeat the steps in **3**, but change `attack=blend`. (**NOT** work in `tinyimagenet`, `imagenet` )

Run:
```
bash ./backdoor/blend.sh
```

6. Open `trojan.sh` and repeat the steps in **3**, but change `attack=trojan`.

Run:
```
bash ./backdoor/trojan.sh

```

7. Open `SIG.sh` and repeat the steps in **3**, but change `attack=SIG`. (**NOT** work in `imagenet` )

Run:
```
bash ./backdoor/SIG.sh
```

8. Open `WaNet.sh` and repeat the steps in **3**, but change `attack=WaNet`. (**NOT** work in `imagenet` )

Run:
```
bash ./backdoor/WaNet.sh
```

9. Open `dynamic.sh` and repeat the steps in **3**, but change `attack=Dynamic`. (**NOT** work in `tinyimagenet`, `imagenet` )

Run:
```
bash ./backdoor/dynamic.sh
```

10. Open `TaCT.sh` and repeat the steps in **3**, but change `attack=TaCT`. (**NOT** work in `imagenet` )

Run:
```
bash ./backdoor/TaCT.sh
```

11. Open `adaptive_blend.sh` and repeat the steps in **3**, but change `attack=adaptive_blend`.

Run:
```
bash ./backdoor/adaptive_blend.sh
```

12. Open `adaptive_patch.sh` and repeat the steps in **3**, but change `attack=adaptive_blend`. 

Run:
```
bash ./backdoor/adaptive_patch.sh
```

**The backdoor models will be stored in `./backdoor/poisoned_train_set`, the reprogramming models will be stored in  `./Reprogramming/models`.**

## Get Results
Open `stl10-auroc.ipynb`, and modify the variable `b` to read the corresponding path.
For <attack=none, badnet, adaptive_blend, adaptive_patch, SIG, TaCT, trojan, WaNet...>,

```
b = pd.read_csv('models/target_tinyimagenet_50000_<attack>/b_train.csv',header=None)
```

The AUROC will be shown on the last line.
