/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Node;
import java.util.Iterator;

final class BayesImDistanceFunction {
    BayesImDistanceFunction() {
    }

    public static double distance(BayesIm firstBn, BayesIm secondBn) {
        if (!firstBn.getBayesPm().equals(secondBn.getBayesPm())) {
            throw new IllegalArgumentException("BayesPms must be equal.");
        }
        Dag graph = firstBn.getBayesPm().getDag();
        Node[] nodes = new Node[graph.getNumNodes()];
        Iterator<Node> it = graph.getNodes().iterator();
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = it.next();
        }
        double sum = 0.0;
        for (int i = 0; i < nodes.length; ++i) {
            int numRows = firstBn.getNumRows(i);
            for (int j = 0; j < numRows; ++j) {
                int numCols = firstBn.getNumColumns(i);
                for (int k = 0; k < numCols; ++k) {
                    double diff = firstBn.getProbability(i, j, k) - secondBn.getProbability(i, j, k);
                    sum += diff * diff;
                }
            }
        }
        return Math.sqrt(sum);
    }
}

