/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesImProbs;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DataSetProbs;
import edu.cmu.tetrad.bayes.MlBayesEstimator;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.HashMap;
import java.util.List;

public final class BayesProperties {
    private DataSet dataSet;
    private BayesPm bayesPm;
    private Graph graph;
    private MlBayesIm blankBayesIm;
    private int pValueDf;
    private double chisq;
    private Estimator estimator = new Estimator(){

        @Override
        public BayesIm estimate(BayesPm bayesPm, DataSet dataSet) {
            MlBayesEstimator estimator = new MlBayesEstimator();
            return estimator.estimate(bayesPm, dataSet);
        }
    };

    public BayesProperties(DataSet dataSet, Graph graph) {
        this.setDataSet(dataSet);
        this.setGraph(graph);
    }

    public final void setGraph(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        List<Node> vars = this.dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            GraphNode node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node1 : nodes) {
            Node var = (Node)nodesToVars.get(node1.getName());
            if (!(var instanceof DiscreteVariable)) continue;
            DiscreteVariable var2 = (DiscreteVariable)var;
            List<String> categories = var2.getCategories();
            bayesPm.setCategories(node1, categories);
        }
        this.graph = graph;
        this.bayesPm = bayesPm;
        this.blankBayesIm = new MlBayesIm(bayesPm);
    }

    public final double getBic() {
        return this.logProbDataGivenStructure() - this.parameterPenalty();
    }

    public final double getLikelihoodRatioP() {
        Graph graph1 = this.getGraph();
        List<Node> nodes = this.getGraph().getNodes();
        Dag graph0 = new Dag();
        for (Node node : nodes) {
            graph0.addNode(node);
        }
        BayesProperties scorer1 = new BayesProperties(this.getDataSet(), graph1);
        BayesProperties scorer0 = new BayesProperties(this.getDataSet(), graph0);
        double l1 = scorer1.logProbDataGivenStructure();
        double l0 = scorer0.logProbDataGivenStructure();
        System.out.println("l1 = " + l1);
        System.out.println("l0 = " + l0);
        double chisq = -2.0 * (l0 - l1);
        int n1 = scorer1.numNonredundantParams();
        int n0 = scorer0.numNonredundantParams();
        int df = n1 - n0;
        double pValue = 1.0 - ProbUtils.chisqCdf(chisq, df);
        this.pValueDf = df;
        this.chisq = chisq;
        return pValue;
    }

    public final double getVuongP() {
        Graph gg = this.getGraph();
        List<Node> nodes = this.getGraph().getNodes();
        Dag gf = new Dag();
        for (Node node : nodes) {
            gf.addNode(node);
        }
        BayesProperties scorerf = new BayesProperties(this.getDataSet(), gg);
        BayesProperties scorerg = new BayesProperties(this.getDataSet(), gf);
        double[] scoresf = scorerf.logsProbDataGivenStructure();
        double[] scoresg = scorerg.logsProbDataGivenStructure();
        int kf = scorerf.numNonredundantParams();
        int kg = scorerg.numNonredundantParams();
        int n = this.getDataSet().getNumRows();
        double v1 = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = scoresg[i] - scoresf[i];
            v1 += v * v;
        }
        double lf = 0.0;
        for (int i = 0; i < n; ++i) {
            lf += scoresg[i];
        }
        double lg = 0.0;
        for (int i = 0; i < n; ++i) {
            lg += scoresf[i];
        }
        double lr = 0.0;
        for (int i = 0; i < n; ++i) {
            lr += scoresg[i] - scoresf[i];
        }
        double w2 = v1 / (double)n - Math.pow(lr / (double)n, 2.0);
        double stat = lr / Math.pow((double)n * w2, 0.5);
        System.out.println("v1 = " + v1 + " lr = " + lr + " w2 = " + w2 + " stat = " + stat);
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, Math.abs(stat)));
    }

    public final double logProbDataGivenStructure2() {
        DataSetProbs probs = new DataSetProbs(this.getDataSet());
        double r = this.dataSet.getNumRows();
        double score = 0.0;
        List<String> dataVarNames = this.dataSet.getVariableNames();
        for (int j = 0; j < this.blankBayesIm.getNumNodes(); ++j) {
            block1: for (int k = 0; k < this.blankBayesIm.getNumRows(j); ++k) {
                Proposition condition = Proposition.tautology(this.blankBayesIm);
                int[] parents = this.blankBayesIm.getParents(j);
                int[] parentValues = this.blankBayesIm.getParentValues(j, k);
                for (int v = 0; v < this.blankBayesIm.getNumParents(j); ++v) {
                    int parent = parents[v];
                    int dataVar = this.translate(parent, dataVarNames);
                    condition.setCategory(dataVar, parentValues[v]);
                }
                double p1 = probs.getProb(condition);
                for (int v = 0; v < this.blankBayesIm.getNumColumns(j); ++v) {
                    Proposition assertion = Proposition.tautology(this.blankBayesIm);
                    int _j = this.translate(j, dataVarNames);
                    assertion.setCategory(_j, v);
                    double p2 = probs.getConditionalProb(assertion, condition);
                    if (Double.isNaN(p2) || p2 == 0.0) continue block1;
                    double numCases = r * p1 * p2;
                    score += numCases * Math.log(p2);
                }
            }
        }
        return score;
    }

    public final BayesPm getBayesPm() {
        return this.bayesPm;
    }

    public final int getPValueDf() {
        return this.pValueDf;
    }

    public final double getPValueChisq() {
        return this.chisq;
    }

    public Estimator getEstimator() {
        return this.estimator;
    }

    public void setEstimator(Estimator estimator) {
        this.estimator = estimator;
    }

    private double logProbDataGivenStructure() {
        BayesIm bayesIm = this.estimator.estimate(this.bayesPm, this.dataSet);
        BayesImProbs probs = new BayesImProbs(bayesIm);
        List<Node> variables = bayesIm.getVariables();
        DataSet reorderedDataSet = this.dataSet.subsetColumns(variables);
        int n = reorderedDataSet.getNumRows();
        int m = reorderedDataSet.getNumColumns();
        double score = 0.0;
        int[] _case = new int[m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                _case[j] = reorderedDataSet.getInt(i, j);
            }
            score += Math.log(probs.getCellProb(_case));
        }
        return score;
    }

    private double[] logsProbDataGivenStructure() {
        BayesIm bayesIm = this.estimator.estimate(this.bayesPm, this.dataSet);
        BayesImProbs probs = new BayesImProbs(bayesIm);
        List<Node> variables = bayesIm.getVariables();
        DataSet reorderedDataSet = this.dataSet.subsetColumns(variables);
        int n = reorderedDataSet.getNumRows();
        int m = reorderedDataSet.getNumColumns();
        double[] scores = new double[n];
        int[] _case = new int[m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                _case[j] = reorderedDataSet.getInt(i, j);
            }
            scores[i] = Math.log(probs.getCellProb(_case));
        }
        return scores;
    }

    private int numNonredundantParams() {
        this.setGraph(this.getGraph());
        int numParams = 0;
        for (int j = 0; j < this.blankBayesIm.getNumNodes(); ++j) {
            int numColumns = this.blankBayesIm.getNumColumns(j);
            int numRows = this.blankBayesIm.getNumRows(j);
            if (numColumns <= 1) continue;
            numParams += (numColumns - 1) * numRows;
        }
        return numParams;
    }

    private double parameterPenalty() {
        int numParams = this.numNonredundantParams();
        double r = this.dataSet.getNumRows();
        return (double)numParams * Math.log(r) / 2.0;
    }

    private Graph getGraph() {
        return this.graph;
    }

    private int translate(int parent, List<String> dataVarNames) {
        String imName = this.blankBayesIm.getNode(parent).getName();
        return dataVarNames.indexOf(imName);
    }

    private DataSet getDataSet() {
        return this.dataSet;
    }

    private void setDataSet(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.bayesPm = null;
        this.blankBayesIm = null;
        this.graph = null;
        this.pValueDf = -1;
        this.chisq = Double.NaN;
        this.dataSet = dataSet;
    }

    public static interface Estimator {
        public BayesIm estimate(BayesPm var1, DataSet var2);
    }
}

