/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.Arrays;
import java.util.List;

public final class DirichletDataSetProbs
implements DiscreteProbs {
    private DataSet dataSet;
    private int[] dims;
    private boolean boundsEnforced = true;
    private int numRows;
    private double symmValue;

    public DirichletDataSetProbs(DataSet dataSet, double symmValue) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        if (symmValue < 0.0) {
            throw new IllegalArgumentException();
        }
        this.dataSet = dataSet;
        this.symmValue = symmValue;
        this.dims = new int[dataSet.getNumColumns()];
        for (int i = 0; i < this.dims.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            this.dims[i] = variable.getNumCategories();
        }
        this.numRows = dataSet.getNumRows();
    }

    @Override
    public double getCellProb(int[] variableValues) {
        int[] point = new int[this.dims.length];
        int count = 0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
            }
            if (!Arrays.equals(point, variableValues)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] point = new int[this.dims.length];
        int count = 0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
            }
            if (!assertion.isPermissibleCombination(point)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        int i;
        List<Node> dataVars;
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        List<Node> assertionVars = assertion.getVariableSource().getVariables();
        if (!((Object)assertionVars).equals(dataVars = this.dataSet.getVariables())) {
            throw new IllegalArgumentException("Assertion variable and data variables are either different or in a different order: \n\tAssertion vars: " + assertionVars + "\n\tData vars: " + dataVars);
        }
        int[] point = new int[this.dims.length];
        double count1 = 1.0;
        double count2 = 1.0;
        for (i = 0; i < this.dims.length; ++i) {
            if (!condition.isConditioned(i) && !assertion.isConditioned(i)) continue;
            count2 *= (double)condition.getNumAllowedCategories(i) * this.symmValue;
            if (!assertion.isConditioned(i)) continue;
            count1 *= (double)assertion.getNumAllowedCategories(i) * this.symmValue;
        }
        for (i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
            }
            if (!condition.isPermissibleCombination(point)) continue;
            count1 += 1.0;
            if (!assertion.isPermissibleCombination(point)) continue;
            count2 += 1.0;
        }
        return count2 / count1;
    }

    @Override
    public boolean isMissingValueCaseFound() {
        return false;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public List<Node> getVariables() {
        return null;
    }

    public boolean isBoundsEnforced() {
        return this.boundsEnforced;
    }

    public void setBoundsEnforced(boolean boundsEnforced) {
        this.boundsEnforced = boundsEnforced;
    }
}

