/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesUtils;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;

public final class DirichletEstimator {
    public static DirichletBayesIm estimate(DirichletBayesIm prior, DataSet dataSet) {
        if (prior == null) {
            throw new NullPointerException();
        }
        if (dataSet == null) {
            throw new NullPointerException();
        }
        BayesUtils.ensureVarsInData(prior.getVariables(), dataSet);
        BayesPm bayesPm = prior.getBayesPm();
        DirichletBayesIm posterior = DirichletBayesIm.blankDirichletIm(bayesPm);
        int numPoints = dataSet.getNumRows();
        for (int n = 0; n < prior.getNumNodes(); ++n) {
            int[] varIndices = new int[prior.getNumParents(n) + 1];
            Node node = prior.getNode(n);
            String name = node.getName();
            varIndices[0] = dataSet.getColumn(dataSet.getVariable(name));
            for (int p = 0; p < prior.getNumParents(n); ++p) {
                Node parentNode = prior.getNode(prior.getParent(n, p));
                name = parentNode.getName();
                varIndices[p + 1] = dataSet.getColumn(dataSet.getVariable(name));
            }
            for (int row = 0; row < prior.getNumRows(n); ++row) {
                int i;
                int numCategories = bayesPm.getNumCategories(node);
                int[] nCount = new int[numCategories];
                int[] pVals = prior.getParentValues(n, row);
                for (i = 0; i < numPoints; ++i) {
                    boolean satisfied = true;
                    for (int p = 0; p < prior.getNumParents(n); ++p) {
                        if (dataSet.getInt(i, varIndices[p + 1]) == -99) {
                            satisfied = false;
                            break;
                        }
                        if (pVals[p] == dataSet.getInt(i, varIndices[p + 1])) continue;
                        satisfied = false;
                        break;
                    }
                    if (dataSet.getInt(i, varIndices[0]) == -99) {
                        satisfied = false;
                    }
                    if (!satisfied) continue;
                    int n2 = dataSet.getInt(i, varIndices[0]);
                    nCount[n2] = nCount[n2] + 1;
                }
                for (i = 0; i < numCategories; ++i) {
                    double priorValue = prior.getPseudocount(n, row, i);
                    double value = (double)nCount[i] + priorValue;
                    posterior.setPseudocount(n, row, i, value);
                }
            }
        }
        return posterior;
    }
}

