/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesProperties;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestBayesBicScorer
extends TestCase {
    public TestBayesBicScorer(String name) {
        super(name);
    }

    public static void testPValue() {
        Graph graph1 = GraphConverter.convert("X1,X2-->X3,X4,X5-->X6,X7,X8");
        Graph graph2 = GraphConverter.convert("X1,X2-->X3,X4,X5,X6,X7-->X8");
        Dag dag2 = new Dag(graph2);
        BayesPm bayesPm2 = new BayesPm(dag2);
        MlBayesIm bayesIm2 = new MlBayesIm(bayesPm2, 1);
        int n = 1000;
        DataSet dataSet2Discrete = bayesIm2.simulateData(n, false);
        BayesProperties scorer = new BayesProperties(dataSet2Discrete, graph1);
        System.out.println("P-value = " + scorer.getLikelihoodRatioP());
    }

    public static Test suite() {
        return new TestSuite(TestBayesBicScorer.class);
    }
}

