/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestBayesPm
extends TestCase {
    public TestBayesPm(String name) {
        super(name);
    }

    public static void testInitializeFixed() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag, 3, 3);
        List<Node> nodes = dag.getNodes();
        for (Node node1 : nodes) {
            TestBayesPm.assertEquals(3, bayesPm.getNumCategories(node1));
        }
    }

    public static void testInitializeRandom() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag, 2, 5);
        List<Node> nodes = dag.getNodes();
        for (Node node1 : nodes) {
            int numValues = bayesPm.getNumCategories(node1);
            TestBayesPm.assertTrue("Number of values out of range: " + numValues, numValues >= 2 && numValues <= 5);
        }
    }

    public static void testChangeNumValues() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        Node x1 = dag.getNode("X1");
        Node x2 = dag.getNode("X2");
        BayesPm bayesPm = new BayesPm(dag, 3, 3);
        bayesPm.setNumCategories(x1, 5);
        TestBayesPm.assertEquals(5, bayesPm.getNumCategories(x1));
        TestBayesPm.assertEquals(3, bayesPm.getNumCategories(x2));
    }

    public static void testEquals() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag, 3, 3);
        TestBayesPm.assertEquals(bayesPm, bayesPm);
    }

    public static void testMeasuredNodes() {
        Dag dag = new Dag();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        x1.setNodeType(NodeType.LATENT);
        dag.addNode(x1);
        dag.addNode(x2);
        dag.addNode(x3);
        dag.addNode(x4);
        dag.addDirectedEdge(x1, x2);
        System.out.println(dag);
        BayesPm bayesPm = new BayesPm(dag, 3, 3);
        System.out.println(bayesPm);
        System.out.println(bayesPm.getMeasuredNodes());
    }

    public static Test suite() {
        return new TestSuite(TestBayesPm.class);
    }
}

