/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.EmBayesEstimator;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestEmBayesEstimator
extends TestCase {
    public TestEmBayesEstimator(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public static void testEstimate1() {
        Dag graph = new Dag();
        GraphNode L1 = new GraphNode("L1");
        GraphNode X1 = new GraphNode("X1");
        GraphNode X2 = new GraphNode("X2");
        L1.setNodeType(NodeType.LATENT);
        X1.setNodeType(NodeType.MEASURED);
        X2.setNodeType(NodeType.MEASURED);
        graph.addNode(L1);
        graph.addNode(X1);
        graph.addNode(X2);
        graph.addDirectedEdge(L1, X1);
        graph.addDirectedEdge(L1, X2);
        BayesPm pm = new BayesPm(graph);
        pm.setNumCategories(L1, 2);
        pm.setNumCategories(X1, 2);
        pm.setNumCategories(X2, 2);
        MlBayesIm im = new MlBayesIm(pm, 1);
        DataSet dataSet = im.simulateData(10000, false);
        EmBayesEstimator emb = new EmBayesEstimator(im, dataSet);
        emb.expectationOnly();
        BayesIm estimatedIm = emb.getEstimatedIm();
        System.out.println(im);
        System.out.println(estimatedIm);
    }

    public void test2() {
        Dag graph = new Dag();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        x2.setNodeType(NodeType.LATENT);
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addDirectedEdge(x2, x1);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x1, x3);
        BayesPm pm = new BayesPm(graph);
        MlBayesIm im = new MlBayesIm(pm, 1);
        System.out.println(im);
        DataSet data = im.simulateData(1000, false);
        EmBayesEstimator estimator = new EmBayesEstimator(pm, data);
        estimator.expectationOnly();
        estimator.maximization(1.0E-4);
        System.out.println(estimator.getEstimatedIm());
    }

    public static Test suite() {
        return new TestSuite(TestEmBayesEstimator.class);
    }
}

