/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.CptInvariantMarginalCalculator;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.UpdatedBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestUpdatedBayesIm
extends TestCase {
    public TestUpdatedBayesIm(String name) {
        super(name);
    }

    public static void testCompound() {
        GraphNode x0Node = new GraphNode("X0");
        GraphNode x1Node = new GraphNode("X1");
        GraphNode x2Node = new GraphNode("X2");
        GraphNode x3Node = new GraphNode("X3");
        GraphNode x4Node = new GraphNode("X4");
        Dag graph = new Dag();
        graph.addNode(x0Node);
        graph.addNode(x1Node);
        graph.addNode(x2Node);
        graph.addNode(x3Node);
        graph.addNode(x4Node);
        graph.addDirectedEdge(x0Node, x1Node);
        graph.addDirectedEdge(x0Node, x2Node);
        graph.addDirectedEdge(x1Node, x3Node);
        graph.addDirectedEdge(x2Node, x3Node);
        graph.addDirectedEdge(x4Node, x0Node);
        graph.addDirectedEdge(x4Node, x2Node);
        System.out.println(graph);
        BayesPm bayesPm = new BayesPm(graph);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        UpdatedBayesIm updatedIm1 = new UpdatedBayesIm(bayesIm);
        TestUpdatedBayesIm.assertEquals(bayesIm, updatedIm1);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                System.out.println("*** i = " + i + ", j = " + j);
                Evidence evidence1 = updatedIm1.getEvidence();
                evidence1.getProposition().disallowComplement(i, 0);
                UpdatedBayesIm updatedIm2 = new UpdatedBayesIm(updatedIm1, evidence1);
                Evidence evidence2 = updatedIm2.getEvidence();
                evidence2.getProposition().setToTautology();
                evidence2.getProposition().disallowComplement(j, 0);
                CptInvariantMarginalCalculator marginals1 = new CptInvariantMarginalCalculator(updatedIm2, evidence2);
                double marginal1 = marginals1.getMarginal(0, 0);
                Evidence evidence3 = updatedIm1.getEvidence();
                evidence3.getProposition().disallowComplement(i, 0);
                evidence3.getProposition().disallowComplement(j, 0);
                CptInvariantMarginalCalculator marginals2 = new CptInvariantMarginalCalculator(updatedIm1, evidence3);
                double marginal2 = marginals2.getMarginal(0, 0);
                TestUpdatedBayesIm.assertEquals(marginal1, marginal2, 1.0E-5);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestUpdatedBayesIm.class);
    }
}

