/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.Dissimilarity;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ECast
implements ClusteringAlgorithm {
    private Dissimilarity dissimilarity = new SquaredErrorLoss();
    private List<List<Integer>> clusters;
    private boolean verbose = true;
    private Set<Integer> storedCluster;
    private double[] affinity;
    private Set<Integer> cOpen = new LinkedHashSet<Integer>();
    private DoubleMatrix2D data;

    public void cluster1(DoubleMatrix2D data) {
        this.data = data;
        ArrayList<List<Integer>> clusters = new ArrayList<List<Integer>>();
        LinkedHashSet<Integer> setU = new LinkedHashSet<Integer>();
        for (int i = 0; i < data.rows(); ++i) {
            setU.add(i);
        }
        this.affinity = new double[data.rows()];
        while (!setU.isEmpty()) {
            int u;
            double threshold = this.calculateT(setU);
            System.out.println("threshold = " + threshold);
            for (u = 0; u < this.affinity.length; ++u) {
                this.affinity[u] = 0.0;
            }
            this.cOpen = new LinkedHashSet<Integer>();
            u = this.maximalSimilarity(setU);
            this.cOpen.add(u);
            setU.remove(u);
            Iterator i$ = setU.iterator();
            while (i$.hasNext()) {
                int x;
                int n = x = ((Integer)i$.next()).intValue();
                this.affinity[n] = this.affinity[n] + this.similarity(x, u);
            }
            System.out.println("Initially adding " + u);
            boolean changed = true;
            while (changed) {
                int x;
                Iterator<Object> i$2;
                changed = false;
                while (!setU.isEmpty() && this.affinity[u = this.maxAffineElement(setU)] >= threshold * (double)this.cOpen.size()) {
                    System.out.println("Adding " + u + " affinity = " + this.affinity[u]);
                    this.cOpen.add(u);
                    setU.remove(u);
                    changed = true;
                    i$2 = setU.iterator();
                    while (i$2.hasNext()) {
                        int n = x = ((Integer)i$2.next()).intValue();
                        this.affinity[n] = this.affinity[n] + this.similarity(x, u);
                    }
                    i$2 = this.cOpen.iterator();
                    while (i$2.hasNext()) {
                        int n = x = ((Integer)i$2.next()).intValue();
                        this.affinity[n] = this.affinity[n] + this.similarity(x, u);
                    }
                }
                while (!this.cOpen.isEmpty() && this.affinity[u = this.minAffineElement(this.cOpen)] < threshold * (double)this.cOpen.size()) {
                    System.out.println("Removing " + u + " affinity = " + this.affinity[u]);
                    this.cOpen.remove(u);
                    setU.add(u);
                    changed = true;
                    i$2 = setU.iterator();
                    while (i$2.hasNext()) {
                        int n = x = ((Integer)i$2.next()).intValue();
                        this.affinity[n] = this.affinity[n] - this.similarity(x, u);
                    }
                    i$2 = this.cOpen.iterator();
                    while (i$2.hasNext()) {
                        int n = x = ((Integer)i$2.next()).intValue();
                        this.affinity[n] = this.affinity[n] - this.similarity(x, u);
                    }
                }
            }
            System.out.println("CLOSE");
            clusters.add(new ArrayList<Integer>(this.cOpen));
        }
        this.clusters = clusters;
    }

    @Override
    public void cluster(DoubleMatrix2D data) {
        int x;
        this.data = data;
        ArrayList<List<Integer>> clusters = new ArrayList<List<Integer>>();
        LinkedHashSet<Integer> setU = new LinkedHashSet<Integer>();
        for (int i = 0; i < data.rows(); ++i) {
            setU.add(i);
        }
        LinkedHashSet<Integer> cOpen = new LinkedHashSet<Integer>();
        this.affinity = new double[data.rows()];
        double threshold = this.calculateT(setU);
        int u = this.maximalSimilarity(setU);
        cOpen.add(u);
        setU.remove(u);
        Iterator i$ = setU.iterator();
        while (i$.hasNext()) {
            int n = x = ((Integer)i$.next()).intValue();
            this.affinity[n] = this.affinity[n] + this.similarity(x, u);
        }
        System.out.println("Initially adding " + u);
        while (!setU.isEmpty() || !cOpen.isEmpty()) {
            u = this.maxAffineElement(setU);
            if (u != -1 && this.affinity[u] >= threshold * (double)cOpen.size()) {
                System.out.println("Adding " + u + " affinity = " + this.affinity[u]);
                cOpen.add(u);
                setU.remove(u);
                i$ = setU.iterator();
                while (i$.hasNext()) {
                    int n = x = ((Integer)i$.next()).intValue();
                    this.affinity[n] = this.affinity[n] + this.similarity(x, u);
                }
                i$ = cOpen.iterator();
                while (i$.hasNext()) {
                    x = (Integer)i$.next();
                    if (x == u) continue;
                    int n = x;
                    this.affinity[n] = this.affinity[n] + this.similarity(x, u);
                }
                continue;
            }
            u = this.minAffineElement(cOpen);
            if (u != -1 && this.affinity[u] < threshold * (double)(cOpen.size() - 1)) {
                System.out.println("Removing " + u + " affinity = " + this.affinity[u]);
                cOpen.remove(u);
                setU.add(u);
                i$ = setU.iterator();
                while (i$.hasNext()) {
                    int n = x = ((Integer)i$.next()).intValue();
                    this.affinity[n] = this.affinity[n] - this.similarity(x, u);
                }
                i$ = cOpen.iterator();
                while (i$.hasNext()) {
                    x = (Integer)i$.next();
                    if (x == u) continue;
                    int n = x;
                    this.affinity[n] = this.affinity[n] - this.similarity(x, u);
                }
                continue;
            }
            System.out.println("Closing.");
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            clusters.add(new ArrayList<Integer>(cOpen));
            cOpen = new LinkedHashSet();
            for (int i = 0; i < data.rows(); ++i) {
                this.affinity[i] = 0.0;
            }
        }
        this.clusters = clusters;
    }

    private double calculateT(Set<Integer> U) {
        double a = 0.0;
        int count = 0;
        for (int i : U) {
            for (int j : U) {
                double s;
                if (i >= j || !((s = this.similarity(i, j)) > 0.5)) continue;
                a += s - 0.5;
                ++count;
            }
        }
        return a / (double)count;
    }

    @Override
    public List<List<Integer>> getClusters() {
        return this.clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private int minAffineElement(Set<Integer> set) {
        int p = -1;
        double min = Double.POSITIVE_INFINITY;
        for (int q : set) {
            if (!(this.affinity[q] < min)) continue;
            min = this.affinity[q];
            p = q;
        }
        return p;
    }

    private int maximalSimilarity(Set<Integer> set) {
        int p = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i : set) {
            for (int j : set) {
                if (i > j || !(this.similarity(i, j) > max)) continue;
                max = this.similarity(i, j);
                p = i;
            }
        }
        return p;
    }

    private int maxAffineElement(Set<Integer> setU) {
        int p = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int q : setU) {
            if (!(this.affinity[q] > max)) continue;
            max = this.affinity[q];
            p = q;
        }
        return p;
    }

    private double similarity(int i, int j) {
        DoubleMatrix1D vi = this.data.viewRow(i);
        DoubleMatrix1D vj = this.data.viewRow(j);
        return Math.exp(-this.getDissimilarity().dissimilarity(vi, vj));
    }

    public Dissimilarity getDissimilarity() {
        return this.dissimilarity;
    }

    public void setDissimilarity(Dissimilarity dissimilarity) {
        this.dissimilarity = dissimilarity;
    }
}

