/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.util.NamingProtocol;

abstract class AbstractVariable
implements Variable {
    static final long serialVersionUID = 23L;
    private String name = "??";

    public AbstractVariable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new NullPointerException(NamingProtocol.getProtocolDescription() + ": " + name);
        }
        this.name = name;
    }

    @Override
    public abstract Object getMissingValueMarker();

    @Override
    public abstract boolean isMissingValue(Object var1);

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("AbstractVariable name must not be null.");
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean checkValue(Object value) {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

