/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import java.util.Arrays;

public class AndersonDarlingTest {
    private double[] data;
    private double aSquared;
    private double aSquaredStar;
    private double p;

    public AndersonDarlingTest(double[] data) {
        this.data = data;
        this.runTest();
    }

    public double[] getData() {
        double[] data2 = new double[this.data.length];
        System.arraycopy(this.data, 0, data2, 0, this.data.length);
        return data2;
    }

    public double getASquared() {
        return this.aSquared;
    }

    public double getASquaredStar() {
        return this.aSquaredStar;
    }

    public double getP() {
        return this.p;
    }

    private void runTest() {
        int n = this.data.length;
        double[] x = new double[this.data.length];
        System.arraycopy(this.data, 0, x, 0, this.data.length);
        Arrays.sort(x);
        double mean = StatUtils.mean(x);
        double sd = StatUtils.standardDeviation(x);
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = (x[i] - mean) / sd;
        }
        double h = 0.0;
        int numSummed = 0;
        for (int i = 0; i < n; ++i) {
            double y1 = y[i];
            double a1 = Math.log(RandomUtil.getInstance().normalCdf(0.0, 1.0, y1));
            double y2 = y[n - i - 1];
            double a2 = Math.log(1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, y2));
            if (Double.isInfinite(a1) || Double.isInfinite(a2)) continue;
            h += (double)(2 * (i + 1) - 1) * (a1 + a2);
            ++numSummed;
        }
        double a = (double)(-numSummed) - 1.0 / (double)numSummed * h;
        double aa = (1.0 + 0.75 / (double)n + 2.25 / Math.pow(numSummed, 2.0)) * a;
        double p = aa < 0.2 ? 1.0 - Math.exp(-13.436 + 101.14 * aa - 223.73 * aa * aa) : (aa < 0.34 ? 1.0 - Math.exp(-8.318 + 42.796 * aa - 59.938 * aa * aa) : (aa < 0.6 ? Math.exp(0.9177 - 4.279 * aa - 1.38 * aa * aa) : Math.exp(1.2937 - 5.709 * aa + 0.0186 * aa * aa)));
        this.aSquared = a;
        this.aSquaredStar = aa;
        this.p = p;
    }
}

