/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.RandomUtil;

public final class BootstrapSampler {
    public DataSet sample(DataSet dataSet, int newSampleSize) {
        if (newSampleSize < 1) {
            throw new IllegalArgumentException("Sample size must be > 0.");
        }
        if (dataSet.getNumRows() < 1) {
            throw new IllegalArgumentException("Dataset must contain samples.");
        }
        int oldSampleSize = dataSet.getNumRows();
        int ncols = dataSet.getNumColumns();
        ColtDataSet newDataSet = new ColtDataSet(newSampleSize, dataSet.getVariables());
        for (int row = 0; row < newSampleSize; ++row) {
            int oldCase = RandomUtil.getInstance().nextInt(oldSampleSize);
            for (int col = 0; col < ncols; ++col) {
                newDataSet.setObject(row, col, dataSet.getObject(oldCase, col));
            }
        }
        return newDataSet;
    }
}

