/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CaseExpander;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ColtDataSet
implements DataSet,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private Map<String, String> columnToTooltip;
    private String name;
    private List<Node> variables = new ArrayList<Node>();
    private DoubleMatrix2D data;
    private Set<Node> selection = new HashSet<Node>();
    private Map<Integer, String> caseIds = new HashMap<Integer, String>();
    private Map<Integer, Integer> multipliers = new HashMap<Integer, Integer>();
    private Knowledge knowledge = new Knowledge();
    private boolean newCategoriesAccomodated = true;
    private transient NumberFormat nf;
    private char outputDelimiter = (char)9;
    private boolean lineNumbersWritten;

    @Override
    public Map<String, String> getColumnToTooltip() {
        return this.columnToTooltip;
    }

    @Override
    public void setColumnToTooltip(Map<String, String> columnToTooltip) {
        this.columnToTooltip = columnToTooltip;
    }

    public ColtDataSet(int rows, List<Node> variables) {
        this.data = new DenseDoubleMatrix2D(rows, variables.size());
        this.variables = new LinkedList<Node>(variables);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < variables.size(); ++j) {
                this.data.set(i, j, Double.NaN);
            }
        }
    }

    public ColtDataSet(ColtDataSet dataSet) {
        this.name = dataSet.name;
        this.variables = new LinkedList<Node>(dataSet.variables);
        this.data = dataSet.data.copy();
        this.selection = new HashSet<Node>(dataSet.selection);
        this.multipliers = new HashMap<Integer, Integer>(dataSet.multipliers);
        this.knowledge = new Knowledge(dataSet.knowledge);
        this.newCategoriesAccomodated = dataSet.newCategoriesAccomodated;
    }

    public static ColtDataSet makeContinuousData(List<Node> variables, DoubleMatrix2D data) {
        if (variables.size() != data.columns()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Node> convertedVars = new ArrayList<Node>();
        for (Node node : variables) {
            if (!(node instanceof ContinuousVariable)) {
                ContinuousVariable continuousVariable = new ContinuousVariable(node.getName());
                continuousVariable.setNodeType(node.getNodeType());
                convertedVars.add(continuousVariable);
                continue;
            }
            convertedVars.add(node);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node variable : convertedVars) {
            nodes.add(variable);
        }
        for (Node node : convertedVars) {
            if (node instanceof ContinuousVariable) continue;
            throw new IllegalArgumentException();
        }
        ColtDataSet dataSet = new ColtDataSet(data.rows(), nodes);
        dataSet.data = data.copy();
        return dataSet;
    }

    public static ColtDataSet makeData(List<Node> variables, DoubleMatrix2D data) {
        if (variables.size() != data.columns()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Node> convertedVars = new ArrayList<Node>(variables);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node variable : convertedVars) {
            nodes.add(variable);
        }
        ColtDataSet dataSet = new ColtDataSet(data.rows(), nodes);
        dataSet.data = data.copy();
        return dataSet;
    }

    public DataSet concatenateDataRowwise(ColtDataSet dataSet1, ColtDataSet dataSet2) {
        if (!((Object)dataSet1.variables).equals(dataSet2.variables)) {
            throw new IllegalArgumentException();
        }
        int rows1 = dataSet1.getNumRows();
        int rows2 = dataSet2.getNumRows();
        int cols = dataSet1.getNumColumns();
        ColtDataSet concat = new ColtDataSet(rows1 + rows2, dataSet1.variables);
        DoubleMatrix2D concatMatrix = concat.data;
        DoubleMatrix2D matrix1 = dataSet1.data;
        DoubleMatrix2D matrix2 = dataSet2.data;
        for (int i = 0; i < cols; ++i) {
            int j;
            for (j = 0; j < rows1; ++j) {
                concatMatrix.set(j, i, matrix1.get(j, i));
            }
            for (j = 0; j < rows2; ++j) {
                concatMatrix.set(j + rows1, i, matrix2.get(j, i));
            }
        }
        return concat;
    }

    public static DataSet serializableInstance() {
        return new ColtDataSet(0, new LinkedList<Node>());
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
    }

    @Override
    public final int getNumColumns() {
        return this.variables.size();
    }

    @Override
    public final int getNumRows() {
        return this.data.rows();
    }

    @Override
    public final void setInt(int row, int column, int value) {
        Node variable = this.getVariable(column);
        if (!(variable instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Can only set ints for discrete columns.");
        }
        DiscreteVariable _variable = (DiscreteVariable)variable;
        if (value < 0 && value != -99) {
            throw new IllegalArgumentException("Value must be a positive integer: " + value);
        }
        if (value >= _variable.getNumCategories()) {
            if (_variable.isAccommodateNewCategories()) {
                this.accomodateIndex(_variable, value);
            } else {
                throw new IllegalArgumentException("Not a value for that variable: " + value);
            }
        }
        try {
            this.setIntPrivate(row, column, value);
        }
        catch (Exception e) {
            if (row < 0 || column < 0) {
                throw new IllegalArgumentException("Row and column must be >= 0.");
            }
            int newRows = Math.max(row + 1, this.data.rows());
            int newCols = Math.max(column + 1, this.data.columns());
            this.resize(newRows, newCols);
            this.setIntPrivate(row, column, value);
        }
    }

    @Override
    public final void setDouble(int row, int column, double value) {
        if (!(this.getVariable(column) instanceof ContinuousVariable)) {
            throw new IllegalArgumentException("Can only set ints for discrete columns: " + this.getVariable(column));
        }
        try {
            this.data.set(row, column, value);
        }
        catch (Exception e) {
            if (row < 0 || column < 0) {
                throw new IllegalArgumentException("Row and column must be >= 0.");
            }
            int newRows = Math.max(row + 1, this.data.rows());
            int newCols = Math.max(column + 1, this.data.columns());
            this.resize(newRows, newCols);
            this.data.set(row, column, value);
        }
    }

    @Override
    public final Object getObject(int row, int col) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            return this.getDouble(row, col);
        }
        if (variable instanceof DiscreteVariable) {
            DiscreteVariable _variable = (DiscreteVariable)variable;
            if (_variable.isCategoryNamesDisplayed()) {
                return _variable.getCategory(this.getInt(row, col));
            }
            return this.getInt(row, col);
        }
        throw new IllegalArgumentException("Not a row/col in this data set.");
    }

    @Override
    public final void setObject(int row, int col, Object value) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            this.setDouble(row, col, ColtDataSet.getValueFromObjectContinuous(value));
        } else if (variable instanceof DiscreteVariable) {
            this.setInt(row, col, this.getValueFromObjectDiscrete(value, (DiscreteVariable)variable));
        } else {
            throw new IllegalArgumentException("Expecting either a continuous or a discrete variable.");
        }
    }

    @Override
    public final int[] getSelectedIndices() {
        List<Node> variables = this.getVariables();
        Set<Node> selection = this.getSelection();
        int[] indices = new int[selection.size()];
        int j = -1;
        for (int i = 0; i < variables.size(); ++i) {
            if (!selection.contains(variables.get(i))) continue;
            indices[++j] = i;
        }
        return indices;
    }

    public final Set<Node> getSelectedVariables() {
        return new HashSet<Node>(this.selection);
    }

    @Override
    public final void addVariable(Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable: " + variable);
        }
        this.variables.add(variable);
        this.resize(this.data.rows(), this.variables.size());
        int col = this.data.columns() - 1;
        for (int i = 0; i < this.data.rows(); ++i) {
            this.data.set(i, col, Double.NaN);
        }
    }

    @Override
    public final void addVariable(int index, Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable.");
        }
        if (index < 0 || index > this.variables.size()) {
            throw new IndexOutOfBoundsException("Index must in (0, #vars).");
        }
        this.variables.add(index, variable);
        this.resize(this.data.rows(), this.variables.size());
        DenseDoubleMatrix2D _data = new DenseDoubleMatrix2D(this.data.rows(), this.data.columns() + 1);
        for (int j = 0; j < this.data.columns() + 1; ++j) {
            int i;
            if (j < index) {
                for (i = 0; i < this.data.rows(); ++i) {
                    _data.set(i, j, this.data.get(i, j));
                }
                continue;
            }
            if (j == index) {
                for (i = 0; i < this.data.rows(); ++i) {
                    _data.set(i, j, Double.NaN);
                }
                continue;
            }
            for (i = 0; i < this.data.rows(); ++i) {
                _data.set(i, j, this.data.get(i, j - 1));
            }
        }
    }

    @Override
    public final Node getVariable(int col) {
        return this.variables.get(col);
    }

    @Override
    public final int getColumn(Node variable) {
        return this.variables.indexOf(variable);
    }

    @Override
    public final void changeVariable(Node from, Node to) {
        int i;
        if (!(from instanceof DiscreteVariable) || !(to instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Only discrete variables supported.");
        }
        DiscreteVariable _from = (DiscreteVariable)from;
        DiscreteVariable _to = (DiscreteVariable)to;
        int col = this.variables.indexOf(_from);
        List<String> oldCategories = _from.getCategories();
        List<String> newCategories = _to.getCategories();
        int[] indexArray = new int[oldCategories.size()];
        for (i = 0; i < oldCategories.size(); ++i) {
            indexArray[i] = newCategories.indexOf(oldCategories.get(i));
        }
        for (i = 0; i < this.getNumRows() && !Double.isNaN(this.data.get(i, col)); ++i) {
            int value = this.getInt(i, col);
            int newIndex = 0;
            try {
                newIndex = indexArray[value];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newIndex == -1) {
                this.data.set(i, col, Double.NaN);
                continue;
            }
            this.setInt(i, col, newIndex);
        }
        this.variables.set(col, _to);
    }

    @Override
    public final Node getVariable(String varName) {
        for (Node variable1 : this.variables) {
            if (!variable1.getName().equals(varName)) continue;
            return variable1;
        }
        return null;
    }

    @Override
    public final List<Node> getVariables() {
        return new LinkedList<Node>(this.variables);
    }

    @Override
    public final Knowledge getKnowledge() {
        return new Knowledge(this.knowledge);
    }

    @Override
    public final void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public final List<String> getVariableNames() {
        List<Node> vars = this.getVariables();
        ArrayList<String> names = new ArrayList<String>();
        for (Node variable : vars) {
            String name = variable.getName();
            names.add(name);
        }
        return names;
    }

    @Override
    public final void setSelected(Node variable, boolean selected) {
        if (selected) {
            if (this.variables.contains(variable)) {
                this.getSelection().add(variable);
            }
        } else if (this.variables.contains(variable)) {
            this.getSelection().remove(variable);
        }
    }

    @Override
    public final void clearSelection() {
        this.getSelection().clear();
    }

    @Override
    public void ensureRows(int rows) {
        if (rows > this.getNumRows()) {
            this.resize(rows, this.getNumColumns());
        }
    }

    @Override
    public void ensureColumns(int columns, List<String> excludedVariableNames) {
        for (int col = this.getNumColumns(); col < columns; ++col) {
            String _name;
            int i = 0;
            while (this.getVariable(_name = "X" + ++i) != null || excludedVariableNames.contains(_name)) {
            }
            ContinuousVariable variable = new ContinuousVariable(_name);
            this.addVariable(variable);
        }
    }

    @Override
    public final boolean isSelected(Node variable) {
        return this.getSelection().contains(variable);
    }

    @Override
    public final void removeColumn(int index) {
        if (index < 0 || index >= this.variables.size()) {
            throw new IllegalArgumentException("Not a column in this data set: " + index);
        }
        this.variables.remove(index);
        int[] rows = new int[this.data.rows()];
        for (int i = 0; i < this.data.rows(); ++i) {
            rows[i] = i;
        }
        int[] cols = new int[this.data.columns() - 1];
        int m = -1;
        for (int i = 0; i < this.data.columns(); ++i) {
            if (i == index) continue;
            cols[++m] = i;
        }
        this.data = this.data.viewSelection(rows, cols).copy();
    }

    @Override
    public final void removeColumn(Node variable) {
        int index = this.variables.indexOf(variable);
        if (index != -1) {
            this.removeColumn(index);
        }
    }

    @Override
    public final DataSet subsetColumns(List<Node> vars) {
        if (!this.getVariables().containsAll(vars)) {
            ArrayList<Node> missingVars = new ArrayList<Node>(vars);
            missingVars.removeAll(this.getVariables());
            throw new IllegalArgumentException("All vars must be original vars: " + missingVars);
        }
        int[] rows = new int[this.data.rows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        int[] columns = new int[vars.size()];
        for (int j = 0; j < columns.length; ++j) {
            columns[j] = this.getVariables().indexOf(vars.get(j));
        }
        DoubleMatrix2D _data = this.data.viewSelection(rows, columns).copy();
        ColtDataSet _dataSet = new ColtDataSet(0, new LinkedList<Node>());
        _dataSet.data = _data;
        _dataSet.variables = vars;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = new Knowledge(this.knowledge);
        return _dataSet;
    }

    @Override
    public final boolean isMulipliersCollapsed() {
        for (int i : this.getMultipliers().keySet()) {
            if (this.getMultipliers().get(i) == 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getMultiplier(int caseNumber) {
        Integer multiplierInt = this.getMultipliers().get(caseNumber);
        return multiplierInt == null ? 1 : multiplierInt;
    }

    @Override
    public final void setCaseId(int caseNumber, String id) {
        if (id == null) {
            this.caseIds.remove(caseNumber);
        } else {
            if (this.caseIds.values().contains(id)) {
                throw new IllegalArgumentException("Case ID's must be unique; that one has already been used: " + id);
            }
            this.caseIds.put(caseNumber, id);
        }
    }

    @Override
    public final String getCaseId(int caseNumber) {
        return this.caseIds.get(caseNumber);
    }

    @Override
    public final boolean isContinuous() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node variable = this.variables.get(i);
            if (variable instanceof ContinuousVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isDiscrete() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof DiscreteVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isMixed() {
        int numContinuous = 0;
        int numDiscrete = 0;
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof ContinuousVariable) {
                ++numContinuous;
                continue;
            }
            if (column instanceof DiscreteVariable) {
                ++numDiscrete;
                continue;
            }
            throw new IllegalArgumentException("Column not of type continuousor of type discrete; can't classify this data set.");
        }
        return numContinuous > 0 && numDiscrete > 0;
    }

    @Override
    public final DoubleMatrix2D getCorrelationMatrix() {
        return Statistic.correlation(Statistic.covariance(this.data));
    }

    @Override
    public final DoubleMatrix2D getCovarianceMatrix() {
        DenseDoubleMatrix2D cov = new DenseDoubleMatrix2D(this.data.columns(), this.data.columns());
        for (int i = 0; i < this.data.columns(); ++i) {
            for (int j = 0; j < this.data.columns(); ++j) {
                cov.set(i, j, StatUtils.covariance(this.data.viewColumn(i).toArray(), this.data.viewColumn(j).toArray()));
            }
        }
        return cov;
    }

    @Override
    public final int getInt(int row, int column) {
        double value = this.data.get(row, column);
        if (Double.isNaN(value)) {
            return -99;
        }
        return (int)Math.round(value);
    }

    @Override
    public final double getDouble(int row, int column) {
        return this.data.get(row, column);
    }

    @Override
    public final void setMultiplier(int caseNumber, int multiplier) {
        if (caseNumber < 0) {
            throw new IllegalArgumentException("Case numbers must be >= 0: " + caseNumber);
        }
        if (multiplier < 0) {
            throw new IllegalArgumentException("Multipliers must be >= 0: " + multiplier);
        }
        if (multiplier == 1) {
            this.getMultipliers().remove(caseNumber);
        } else {
            this.getMultipliers().put(caseNumber, multiplier);
        }
    }

    @Override
    public final String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        List<Node> variables = this.getVariables();
        buf.append("\n");
        if (this.isLineNumbersWritten()) {
            buf.append("\t");
        }
        for (i = 0; i < this.getNumColumns(); ++i) {
            buf.append(variables.get(i));
            if (i >= this.getNumColumns() - 1) continue;
            buf.append(this.outputDelimiter);
        }
        buf.append("\n");
        for (i = 0; i < this.getNumRows(); ++i) {
            if (this.isLineNumbersWritten()) {
                buf.append(i + 1 + ".\t");
            }
            for (int j = 0; j < this.getNumColumns(); ++j) {
                Node variable = this.getVariable(j);
                if (variable instanceof ContinuousVariable) {
                    if (Double.isNaN(this.getDouble(i, j))) {
                        buf.append("*");
                    } else {
                        buf.append(this.getNumberFormat().format(this.getDouble(i, j)));
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                if (variable instanceof DiscreteVariable) {
                    DiscreteVariable _variable = (DiscreteVariable)variable;
                    int value = this.getInt(i, j);
                    if (value == -99) {
                        buf.append("*");
                    } else {
                        String category = _variable.getCategory(value);
                        if (category.indexOf(this.outputDelimiter) == -1) {
                            buf.append(category);
                        } else {
                            buf.append("\"" + category + "\"");
                        }
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                throw new IllegalStateException("Expecting either a continuous variable or a discrete variable.");
            }
            buf.append("\n");
        }
        buf.append("\n");
        if (this.knowledge != null && !this.knowledge.isEmpty()) {
            buf.append(this.knowledge);
        }
        return buf.toString();
    }

    @Override
    public final DoubleMatrix2D getDoubleData() {
        if (!this.isMulipliersCollapsed()) {
            return this.data.copy();
        }
        System.out.println("Expanding case multipliers.");
        CaseExpander expander = new CaseExpander();
        return ((ColtDataSet)expander.filter((DataSet)this)).data;
    }

    public final DoubleMatrix2D getDoubleDataRaw() {
        return this.data;
    }

    @Override
    public final DataSet subsetColumns(int[] indices) {
        List<Node> variables = this.getVariables();
        LinkedList<Node> _variables = new LinkedList<Node>();
        for (int index : indices) {
            _variables.add(variables.get(index));
        }
        int[] rows = new int[this.data.rows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        DoubleMatrix2D _data = this.data.viewSelection(rows, indices).copy();
        ColtDataSet _dataSet = new ColtDataSet(0, new LinkedList<Node>());
        _dataSet.data = _data;
        _dataSet.name = this.name + "_copy";
        _dataSet.variables = _variables;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = new Knowledge(this.knowledge);
        return _dataSet;
    }

    @Override
    public final DataSet subsetRows(int[] rows) {
        int[] cols = new int[this.data.columns()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        ColtDataSet _data = new ColtDataSet(this);
        _data.data = this.data.viewSelection(rows, cols);
        return _data;
    }

    @Override
    public final void shiftColumnDown(int row, int col, int numRowsShifted) {
        int i;
        if (row >= this.getNumRows() || col >= this.getNumColumns()) {
            throw new IllegalArgumentException("Out of range:  row = " + row + " col = " + col);
        }
        int lastRow = -1;
        for (i = this.getNumRows() - 1; i >= row; --i) {
            if (Double.isNaN(this.data.get(i, col))) continue;
            lastRow = i;
            break;
        }
        if (lastRow == -1) {
            return;
        }
        this.resize(this.getNumRows() + numRowsShifted, this.getNumColumns());
        for (i = this.getNumRows() - 1; i >= row + numRowsShifted; --i) {
            this.data.set(i, col, this.data.get(i - numRowsShifted, col));
            this.data.set(i - numRowsShifted, col, Double.NaN);
        }
    }

    @Override
    public final void removeCols(int[] cols) {
        int[] rows = new int[this.data.rows()];
        for (int i = 0; i < this.data.rows(); ++i) {
            rows[i] = i;
        }
        int[] retainedCols = new int[this.variables.size() - cols.length];
        int i = -1;
        for (int j = 0; j < this.variables.size(); ++j) {
            if (Arrays.binarySearch(cols, j) >= 0) continue;
            retainedCols[++i] = j;
        }
        LinkedList<Node> retainedVars = new LinkedList<Node>();
        for (int retainedCol : retainedCols) {
            retainedVars.add(this.variables.get(retainedCol));
        }
        this.data = this.data.viewSelection(rows, retainedCols).copy();
        this.variables = retainedVars;
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = new Knowledge(this.knowledge);
    }

    @Override
    public final void removeRows(int[] selectedRows) {
        int[] cols = new int[this.data.columns()];
        for (int i = 0; i < this.data.columns(); ++i) {
            cols[i] = i;
        }
        int[] retainedRows = new int[this.data.rows() - selectedRows.length];
        int i = -1;
        for (int j = 0; j < this.data.rows(); ++j) {
            if (Arrays.binarySearch(selectedRows, j) >= 0) continue;
            retainedRows[++i] = j;
        }
        this.data = this.data.viewSelection(retainedRows, cols).copy();
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = new Knowledge(this.knowledge);
    }

    public final boolean equals(Object obj) {
        int i;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet _dataSet = (DataSet)obj;
        if (this.getVariables().size() != _dataSet.getVariables().size()) {
            return false;
        }
        for (i = 0; i < this.getVariables().size(); ++i) {
            Node _node;
            Node node = this.getVariables().get(i);
            if (((Object)node).equals(_node = _dataSet.getVariables().get(i))) continue;
            return false;
        }
        if (_dataSet.getNumRows() != this.getNumRows()) {
            return false;
        }
        for (i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                double _value;
                double value;
                Node variable = this.getVariable(j);
                if (variable instanceof ContinuousVariable) {
                    if (Double.isNaN(this.getDouble(i, j)) && !Double.isNaN(_dataSet.getDouble(i, j))) {
                        return false;
                    }
                    if (!Double.isNaN(this.getDouble(i, j)) && Double.isNaN(_dataSet.getDouble(i, j))) {
                        return false;
                    }
                    if (Double.isNaN(this.getDouble(i, j)) && Double.isNaN(_dataSet.getDouble(i, j))) {
                        return true;
                    }
                    value = Double.parseDouble(nf.format(this.getDouble(i, j)));
                    if (!(Math.abs(value - (_value = Double.parseDouble(nf.format(_dataSet.getDouble(i, j))))) > 0.0)) continue;
                    return false;
                }
                value = this.getInt(i, j);
                if (value == (_value = (double)_dataSet.getInt(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNewCategoriesAccomodated() {
        return this.newCategoriesAccomodated;
    }

    @Override
    public final void setNewCategoriesAccomodated(boolean newCategoriesAccomodated) {
        this.newCategoriesAccomodated = newCategoriesAccomodated;
    }

    @Override
    public void setNumberFormat(NumberFormat nf) {
        if (nf == null) {
            throw new NullPointerException();
        }
        this.nf = nf;
    }

    @Override
    public void setOutputDelimiter(Character character) {
        this.outputDelimiter = character.charValue();
    }

    @Override
    public void permuteRows() {
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumRows(); ++i) {
            permutation.add(i);
        }
        Collections.shuffle(permutation);
        DoubleMatrix2D data2 = this.data.like();
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                data2.set(i, j, this.data.get((Integer)permutation.get(i), j));
            }
        }
        this.data = data2;
    }

    private void setIntPrivate(int row, int col, int value) {
        if (value == -99) {
            this.data.set(row, col, Double.NaN);
        } else {
            this.data.set(row, col, value);
        }
    }

    private void resize(int rows, int cols) {
        DenseDoubleMatrix2D _data = new DenseDoubleMatrix2D(rows, cols);
        for (int i = 0; i < _data.rows(); ++i) {
            for (int j = 0; j < _data.columns(); ++j) {
                if (i < this.data.rows() && j < this.data.columns()) {
                    _data.set(i, j, this.data.get(i, j));
                    continue;
                }
                _data.set(i, j, Double.NaN);
            }
        }
        this.data = _data;
    }

    private Map<Integer, Integer> getMultipliers() {
        return this.multipliers;
    }

    private static void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    private Set<Node> getSelection() {
        if (this.selection == null) {
            this.selection = new HashSet<Node>();
        }
        return this.selection;
    }

    private static double getValueFromObjectContinuous(Object element) {
        if ("*".equals(element) || "".equals(element)) {
            return ContinuousVariable.getDoubleMissingValue();
        }
        if (element instanceof Number) {
            return ((Number)element).doubleValue();
        }
        if (element instanceof String) {
            try {
                return Double.parseDouble((String)element);
            }
            catch (NumberFormatException e) {
                return ContinuousVariable.getDoubleMissingValue();
            }
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    private int getValueFromObjectDiscrete(Object element, DiscreteVariable variable) {
        if ("*".equals(element) || "".equals(element)) {
            return -99;
        }
        if (variable.isAccommodateNewCategories()) {
            if (element instanceof Number) {
                int index = ((Number)element).intValue();
                if (!variable.checkValue(index)) {
                    if (index >= variable.getNumCategories()) {
                        this.accomodateIndex(variable, index);
                    } else {
                        throw new IllegalArgumentException("Variable " + variable + " is not accepting " + "new categories. Problem category is " + ".");
                    }
                }
                return index;
            }
            if (element instanceof String) {
                String label = (String)element;
                if ("".equals(label)) {
                    throw new IllegalArgumentException("Blank category names not permitted.");
                }
                int index = (variable = this.accomodateCategory(variable, label)).getIndex(label);
                if (index == -1) {
                    throw new IllegalArgumentException("Not a category for this variable: " + index);
                }
                return index;
            }
            throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
        }
        if (element instanceof Number) {
            int index = ((Number)element).intValue();
            if (!variable.checkValue(index)) {
                return -99;
            }
            return index;
        }
        if (element instanceof String) {
            String label = (String)element;
            int index = variable.getIndex(label);
            if (index == -1) {
                return -99;
            }
            return index;
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    private DiscreteVariable accomodateCategory(DiscreteVariable variable, String category) {
        if (category == null) {
            throw new NullPointerException();
        }
        List<String> categories = variable.getCategories();
        if (!categories.contains(category)) {
            LinkedList<String> newCategories = new LinkedList<String>(categories);
            newCategories.add(category);
            DiscreteVariable newVariable = new DiscreteVariable(variable.getName(), newCategories);
            this.changeVariable(variable, newVariable);
            return newVariable;
        }
        return variable;
    }

    private void accomodateIndex(DiscreteVariable variable, int index) {
        if (!variable.isAccommodateNewCategories()) {
            throw new IllegalArgumentException("This variable is not set to accomodate new categories.");
        }
        if (index >= variable.getNumCategories()) {
            this.adjustCategories(variable, index + 1);
        }
    }

    private void adjustCategories(DiscreteVariable variable, int numCategories) {
        int i;
        LinkedList<String> categories = new LinkedList<String>(variable.getCategories());
        LinkedList<String> newCategories = new LinkedList<String>(categories);
        if (categories.size() > numCategories) {
            for (i = variable.getCategories().size() - 1; i >= numCategories; ++i) {
                newCategories.remove(i);
            }
        } else if (categories.size() < numCategories) {
            for (i = categories.size(); i < numCategories; ++i) {
                String category = DataUtils.defaultCategory(i);
                if (categories.contains(category)) continue;
                newCategories.add(category);
            }
        }
        DiscreteVariable to = new DiscreteVariable(variable.getName(), newCategories);
        this.changeVariable(variable, to);
    }

    private NumberFormat getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormatUtil.getInstance().getNumberFormat();
        }
        return this.nf;
    }

    private int lastInterestingRow() {
        for (int lastRow = this.data.rows() - 1; lastRow >= 0; --lastRow) {
            for (int j = 0; j < this.data.columns(); ++j) {
                if (Double.isNaN(this.data.get(lastRow, j))) continue;
                return lastRow + 1;
            }
        }
        return -1;
    }

    public boolean isLineNumbersWritten() {
        return this.lineNumbersWritten;
    }

    public void setLineNumbersWritten(boolean lineNumbersWritten) {
        this.lineNumbersWritten = lineNumbersWritten;
    }
}

