/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class ContinuousVariable
extends AbstractVariable
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private static final double MISSING_VALUE = Double.NaN;
    private NodeType nodeType = NodeType.MEASURED;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;

    public ContinuousVariable(String name) {
        super(name);
    }

    public ContinuousVariable(ContinuousVariable variable) {
        super(variable.getName());
        this.nodeType = variable.nodeType;
        this.centerX = variable.centerX;
        this.centerY = variable.centerY;
    }

    public static ContinuousVariable serializableInstance() {
        return new ContinuousVariable("X");
    }

    @Override
    public boolean checkValue(Object value) {
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof String) {
            try {
                Double.parseDouble((String)value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getMissingValueMarker() {
        return Double.NaN;
    }

    public static double getDoubleMissingValue() {
        return Double.NaN;
    }

    public static boolean isDoubleMissingValue(double value) {
        return Double.isNaN(value);
    }

    @Override
    public boolean isMissingValue(Object value) {
        if (value instanceof Double) {
            double doubleValue = (Double)value;
            return Double.isNaN(doubleValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 63;
        hashCode = 17 * hashCode + this.getName().hashCode();
        hashCode = 17 * hashCode + this.getNodeType().hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ContinuousVariable)) {
            return false;
        }
        ContinuousVariable variable = (ContinuousVariable)o;
        if (this.getNodeType() != variable.getNodeType()) {
            return false;
        }
        if (this.getName().hashCode() != variable.getName().hashCode()) {
            return false;
        }
        return this.getName().equals(variable.getName());
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public int getCenterX() {
        return this.centerX;
    }

    @Override
    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }
}

