/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CorrelationMatrix
extends CovarianceMatrix
implements TetradSerializable {
    static final long serialVersionUID = 23L;

    public CorrelationMatrix(CovarianceMatrix matrix) {
        this(matrix.getVariables(), matrix.getMatrix(), matrix.getSampleSize());
    }

    public CorrelationMatrix(DataSet dataSet) {
        super(Collections.unmodifiableList(dataSet.getVariables()), dataSet.getCorrelationMatrix(), dataSet.getNumRows());
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set not continuous.");
        }
    }

    public CorrelationMatrix(List<Node> variables, DoubleMatrix2D matrix, int sampleSize) {
        super(variables, MatrixUtils.convertCovToCorr(matrix), sampleSize);
    }

    public static CorrelationMatrix serializableInstance() {
        return new CorrelationMatrix(new LinkedList<Node>(), new DenseDoubleMatrix2D(0, 0), 1);
    }

    @Override
    public final void setMatrix(DoubleMatrix2D matrix) {
        MatrixUtils.isSquareC(matrix);
        for (int i = 0; i < matrix.rows(); ++i) {
            if (!(Math.abs(matrix.getQuick(i, i) - 1.0) > 1.0E-5)) continue;
            throw new IllegalArgumentException("For a correlation matrix, variances (diagonal elements) must be 1.0");
        }
        super.setMatrix(matrix);
    }

    public CorrelationMatrix getSubCorrMatrix(String[] submatrixVarNames) {
        CovarianceMatrix covarianceMatrix = this.getSubmatrix(submatrixVarNames);
        return new CorrelationMatrix(covarianceMatrix);
    }

    public CorrelationMatrix getSubCorrMatrix(int[] indices) {
        CovarianceMatrix covarianceMatrix = this.getSubmatrix(indices);
        return new CorrelationMatrix(covarianceMatrix);
    }
}

