/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import java.util.ArrayList;
import java.util.Collections;

public final class RandomSampler {
    public static DataSet sample(DataSet dataSet, int newSampleSize) {
        if (newSampleSize < 1) {
            throw new IllegalArgumentException("Sample size must be > 0.");
        }
        if (dataSet.getNumRows() < 1) {
            throw new IllegalArgumentException("Dataset must contain samples.");
        }
        if (dataSet.getNumRows() < newSampleSize) {
            throw new IllegalArgumentException("Not enough cases in data to generate " + newSampleSize + " samples without replacement.");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(dataSet.getNumRows());
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            indices.add(i);
        }
        Collections.shuffle(indices);
        int ncols = dataSet.getNumColumns();
        ColtDataSet newDataSet = new ColtDataSet(newSampleSize, dataSet.getVariables());
        for (int i = 0; i < newSampleSize; ++i) {
            int oldCase = (Integer)indices.get(i);
            for (int j = 0; j < ncols; ++j) {
                newDataSet.setObject(i, j, dataSet.getObject(oldCase, j));
            }
        }
        return newDataSet;
    }
}

