/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.CellTable;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestCellTable
extends TestCase {
    private CellTable table;
    private final int[] dims = new int[]{2, 2, 2, 2};
    private final int[][] data = new int[][]{{1, 1, 1, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 0}, {1, 1, 1, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {1, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 0, 0, 1}, {1, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 1, 0}, {0, 1, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 0, 1, 0}, {0, 0, 1, 1}, {0, 0, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 1, 0, 1}, {1, 1, 0, 1}, {1, 1, 0, 1}, {1, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 0, 1, 1}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {1, 1, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {1, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {1, 0, 1, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {1, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 1, 1}, {0, 0, 1, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 1, 1, 0}, {1, 0, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {1, 0, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 1}, {1, 1, 1, 0}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 0}, {1, 1, 0, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {1, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 0, 1, 1}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 1, 1}, {0, 1, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 1, 1}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 1, 0}, {0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {1, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 0}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {1, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 1, 0}, {1, 1, 0, 1}, {1, 1, 0, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 0, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {1, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 0, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 1, 1}, {0, 1, 1, 0}, {1, 0, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {1, 1, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 1}, {1, 1, 1, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {1, 1, 0, 0}, {0, 0, 1, 0}, {1, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 1}, {0, 1, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 0, 1, 1}, {1, 1, 1, 0}, {1, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 0, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 1, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 0}, {1, 1, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 1}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {1, 0, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}, {0, 0, 1, 1}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {0, 0, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 1, 0}, {0, 0, 1, 1}, {1, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 1, 0, 1}, {0, 1, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 1}, {1, 1, 1, 0}, {0, 0, 1, 0}, {0, 1, 0, 1}, {1, 1, 1, 0}, {0, 1, 0, 1}, {0, 1, 0, 1}, {0, 0, 0, 1}};

    /*
     * Opcode count of 21029 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public TestCellTable(String name) {
        super(name);
    }

    @Override
    public final void setUp() {
        this.table = new CellTable(this.dims);
        LinkedList<Node> variables = new LinkedList<Node>();
        variables.add(new DiscreteVariable("X1", 2));
        variables.add(new DiscreteVariable("X2", 2));
        variables.add(new DiscreteVariable("X3", 2));
        variables.add(new DiscreteVariable("X4", 2));
        ColtDataSet dataSet = new ColtDataSet(this.data.length, variables);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                dataSet.setInt(i, j, this.data[i][j]);
            }
        }
        int[] indices = new int[]{0, 1, 2, 3};
        this.table.addToTable(dataSet, indices);
    }

    public final void testCount() {
        for (int c = 0; c < 8; ++c) {
            int[] testCell = TestCellTable.pickRandomCell(4);
            int myCount = 0;
            for (int[] aData : this.data) {
                boolean inCell = true;
                for (int j = 0; j < this.data[0].length; ++j) {
                    if (aData[j] == testCell[j]) continue;
                    inCell = false;
                }
                if (!inCell) continue;
                ++myCount;
            }
            TestCellTable.assertEquals((long)myCount, this.table.getValue(testCell));
        }
    }

    public final void testMargins() {
        for (int m = 0; m < 15; ++m) {
            int[] cell = TestCellTable.pickRandomCell(4);
            int numMargin = RandomUtil.getInstance().nextInt(4);
            int[] marginVars = new int[numMargin];
            for (int i = 0; i < numMargin; ++i) {
                marginVars[i] = RandomUtil.getInstance().nextInt(4);
                for (int j = 0; j < i; ++j) {
                    if (marginVars[j] != marginVars[i]) continue;
                    --i;
                }
            }
            int[] testCell = new int[4];
            System.arraycopy(cell, 0, testCell, 0, 4);
            for (int i = 0; i < numMargin; ++i) {
                testCell[marginVars[i]] = -1;
            }
            int myCount = 0;
            for (int[] aData : this.data) {
                boolean inMargin = true;
                for (int j = 0; j < this.data[0].length; ++j) {
                    if (testCell[j] == -1 || aData[j] == testCell[j]) continue;
                    inMargin = false;
                }
                if (!inMargin) continue;
                ++myCount;
            }
            TestCellTable.assertEquals((long)myCount, this.table.calcMargin(testCell));
            TestCellTable.assertEquals((long)myCount, this.table.calcMargin(cell, marginVars));
        }
    }

    private static int[] pickRandomCell(int size) {
        int[] cell = new int[size];
        for (int i = 0; i < size; ++i) {
            cell[i] = RandomUtil.getInstance().nextInt(2);
        }
        return cell;
    }

    public static Test suite() {
        return new TestSuite(TestCellTable.class);
    }
}

