/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.history;

import edu.cmu.tetrad.gene.history.PolynomialTerm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class Polynomial
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private List<PolynomialTerm> terms;

    public Polynomial(List<PolynomialTerm> terms) {
        if (terms == null) {
            throw new NullPointerException("Terms list cannot be null.");
        }
        this.terms = new ArrayList<PolynomialTerm>(terms);
    }

    public static Polynomial serializableInstance() {
        return new Polynomial(new ArrayList<PolynomialTerm>());
    }

    public int getNumTerms() {
        return this.terms.size();
    }

    public PolynomialTerm getTerm(int index) {
        return this.terms.get(index);
    }

    public PolynomialTerm findTerm(int[] variables) {
        for (PolynomialTerm term1 : this.terms) {
            if (!term1.isVariableListEqual(variables)) continue;
            return term1;
        }
        return null;
    }

    public int getMaxIndex() {
        int max = 0;
        for (PolynomialTerm term1 : this.terms) {
            int termMax = term1.getMaxIndex();
            if (termMax <= max) continue;
            max = termMax;
        }
        return max;
    }

    public double evaluate(double[] values) {
        double sum = 0.0;
        for (PolynomialTerm term1 : this.terms) {
            sum += term1.evaluate(values);
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.terms.size(); ++i) {
            buf.append(this.terms.get(i));
            if (i >= this.terms.size() - 1) continue;
            buf.append(" + ");
        }
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.terms == null) {
            throw new NullPointerException();
        }
    }
}

