/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.history;

import edu.cmu.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.history.IndexedLagGraph;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndexedLagGraph
extends TestCase {
    public TestIndexedLagGraph(String name) {
        super(name);
    }

    public void testConstruction() {
        BasicLagGraph lagGraph = new BasicLagGraph();
        lagGraph.addFactor("G1");
        lagGraph.addFactor("G2");
        lagGraph.addFactor("G3");
        lagGraph.addEdge("G1", new LaggedFactor("G3", 1));
        lagGraph.addEdge("G2", new LaggedFactor("G1", 2));
        lagGraph.addEdge("G3", new LaggedFactor("G2", 3));
        lagGraph.addEdge("G3", new LaggedFactor("G3", 4));
        System.out.println(lagGraph);
        IndexedLagGraph indexedLagGraph = new IndexedLagGraph(lagGraph);
        System.out.println(indexedLagGraph);
        TestIndexedLagGraph.assertEquals("G1", indexedLagGraph.getFactor(0));
        TestIndexedLagGraph.assertEquals("G2", indexedLagGraph.getFactor(1));
        TestIndexedLagGraph.assertEquals("G3", indexedLagGraph.getFactor(2));
        TestIndexedLagGraph.assertEquals(2, indexedLagGraph.getParent(0, 0).getIndex());
        TestIndexedLagGraph.assertEquals(0, indexedLagGraph.getParent(1, 0).getIndex());
        TestIndexedLagGraph.assertEquals(1, indexedLagGraph.getParent(2, 0).getIndex());
        TestIndexedLagGraph.assertEquals(2, indexedLagGraph.getParent(2, 1).getIndex());
        TestIndexedLagGraph.assertEquals(1, indexedLagGraph.getParent(0, 0).getLag());
        TestIndexedLagGraph.assertEquals(2, indexedLagGraph.getParent(1, 0).getLag());
        TestIndexedLagGraph.assertEquals(3, indexedLagGraph.getParent(2, 0).getLag());
        TestIndexedLagGraph.assertEquals(4, indexedLagGraph.getParent(2, 1).getLag());
    }

    public static Test suite() {
        return new TestSuite(TestIndexedLagGraph.class);
    }
}

