/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.simulation;

import edu.cmu.tetrad.gene.history.DishModel;
import edu.cmu.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class MeasurementSimulator
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private GeneHistory history = null;
    private int numDishes = 1;
    private int numCellsPerDish = 10000;
    private int stepsGenerated = 4;
    private int firstStepStored = 1;
    private int interval = 1;
    private boolean rawDataSaved = false;
    private boolean measuredDataSaved = true;
    private boolean initSync = true;
    private double dishDishVariability = 10.0;
    private int numSamplesPerDish = 4;
    private double sampleSampleVariability = 0.025;
    private double chipChipVariability = 0.1;
    private double pixelDigitalization = 0.025;
    private boolean antilogCalculated = false;
    private int[] timeSteps = null;
    private double[][][] rawData = null;
    private double[][][] measuredData = null;
    private int dishNumber = -1;
    private int cellNumber = -1;

    public MeasurementSimulator() {
        this.constructTimeSteps();
    }

    public static MeasurementSimulator serializableInstance() {
        return new MeasurementSimulator();
    }

    public GeneHistory getHistory() {
        return this.history;
    }

    public void setHistory(GeneHistory history) {
        if (history == null) {
            throw new NullPointerException();
        }
        this.history = history;
    }

    public void setNumDishes(int numDishes) {
        if (numDishes <= 0) {
            throw new IllegalArgumentException("Number of dishes must be > 0: " + numDishes);
        }
        this.numDishes = numDishes;
    }

    public int getNumDishes() {
        return this.numDishes;
    }

    public void setNumCellsPerDish(int numCellsPerDish) {
        if (numCellsPerDish <= 0) {
            throw new IllegalArgumentException("Number of cells per dish must be > 0:" + numCellsPerDish);
        }
        this.numCellsPerDish = numCellsPerDish;
    }

    public int getNumCellsPerDish() {
        return this.numCellsPerDish;
    }

    public void setStepsGenerated(int stepsGenerated) {
        if (stepsGenerated <= 0) {
            throw new IllegalArgumentException("Steps generated must be > 0:" + stepsGenerated);
        }
        this.stepsGenerated = stepsGenerated;
        this.constructTimeSteps();
    }

    public int getStepsGenerated() {
        return this.stepsGenerated;
    }

    public void setFirstStepStored(int firstStepStored) {
        if (firstStepStored <= 0) {
            throw new IllegalArgumentException("First step stored must be > 0: " + firstStepStored);
        }
        this.firstStepStored = firstStepStored;
        this.constructTimeSteps();
    }

    public int getFirstStepStored() {
        return this.firstStepStored;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval must be > 0: " + interval);
        }
        this.interval = interval;
        this.constructTimeSteps();
    }

    public int getInterval() {
        return this.interval;
    }

    public void setRawDataSaved(boolean rawDataSaved) {
        this.rawDataSaved = rawDataSaved;
    }

    public boolean isRawDataSaved() {
        return this.rawDataSaved;
    }

    public void setMeasuredDataSaved(boolean measuredDataSaved) {
        this.measuredDataSaved = measuredDataSaved;
    }

    public boolean isMeasuredDataSaved() {
        return this.measuredDataSaved;
    }

    public void setInitSync(boolean initSync) {
        this.initSync = initSync;
    }

    public boolean isInitSync() {
        return this.initSync;
    }

    public void setAntilogCalculated(boolean antilogCalculated) {
        this.antilogCalculated = antilogCalculated;
    }

    public boolean isAntilogCalculated() {
        return this.antilogCalculated;
    }

    public void setDishDishVariability(double dishDishVariability) {
        if (!(dishDishVariability > 0.0) || !(dishDishVariability < 100.0)) {
            throw new IllegalArgumentException("Dish variability must be > 0.0 and < 100.0: " + dishDishVariability);
        }
        this.dishDishVariability = dishDishVariability;
    }

    public double getDishDishVariability() {
        return this.dishDishVariability;
    }

    public void setNumSamplesPerDish(int numSamplesPerDish) {
        if (numSamplesPerDish <= 0) {
            throw new IllegalArgumentException("Number of samples per dish must be > 0: " + numSamplesPerDish);
        }
        this.numSamplesPerDish = numSamplesPerDish;
    }

    public int getNumSamplesPerDish() {
        return this.numSamplesPerDish;
    }

    public void setSampleSampleVariability(double sampleSampleVariability) {
        if (!(sampleSampleVariability > 0.0) || !(sampleSampleVariability < 1.0)) {
            throw new IllegalArgumentException("Sample variability must be > 0.0: " + sampleSampleVariability);
        }
        this.sampleSampleVariability = sampleSampleVariability;
    }

    public double getSampleSampleVariability() {
        return this.sampleSampleVariability;
    }

    public void setChipChipVariability(double chipChipVariability) {
        if (!(chipChipVariability > 0.0) || !(chipChipVariability < 1.0)) {
            throw new IllegalArgumentException("Chip to chip variability must be > 0.0 and < 1.0: " + chipChipVariability);
        }
        this.chipChipVariability = chipChipVariability;
    }

    public double getChipChipVariability() {
        return this.chipChipVariability;
    }

    public void setPixelDigitalization(double pixelDigitalization) {
        if (!(pixelDigitalization > 0.0) || !(pixelDigitalization < 1.0)) {
            throw new IllegalArgumentException("Pixel digitalization must be > 0.0 and < 1.0: " + pixelDigitalization);
        }
        this.pixelDigitalization = pixelDigitalization;
    }

    public double getPixelDigitalization() {
        return this.pixelDigitalization;
    }

    public double[][][] getRawData() {
        return this.rawData;
    }

    public double[][][] getMeasuredData() {
        return this.measuredData;
    }

    private void constructTimeSteps() {
        int numTimeSteps = (1 + this.stepsGenerated - this.firstStepStored) / this.interval;
        this.timeSteps = new int[numTimeSteps];
        for (int i = 0; i < this.timeSteps.length; ++i) {
            this.timeSteps[i] = this.firstStepStored + i * this.interval;
        }
    }

    public int[] getTimeSteps() {
        return this.timeSteps;
    }

    public int getDishNumber() {
        return this.dishNumber;
    }

    public int getCellNumber() {
        return this.cellNumber;
    }

    public void simulate(GeneHistory history) {
        int numSteps;
        this.setHistory(history);
        history.reset();
        UpdateFunction updateFunction = history.getUpdateFunction();
        int numFactors = updateFunction.getNumFactors();
        DishModel dishModel = new DishModel(this.numDishes, this.getDishDishVariability());
        history.setInitSync(this.isInitSync());
        history.setDishModel(dishModel);
        int numChips = this.getNumSamplesPerDish();
        if (this.measuredDataSaved) {
            numSteps = this.timeSteps.length;
            int numSamples = this.numDishes * numChips;
            this.measuredData = new double[numFactors][numSteps][numSamples];
        }
        this.rawData = null;
        if (this.isRawDataSaved()) {
            numSteps = this.timeSteps.length;
            int numCells = this.numDishes * this.getNumCellsPerDish();
            this.rawData = new double[numFactors][numSteps][numCells];
        }
        double sampleSd = this.getSampleSampleVariability();
        double chipSd = this.getChipChipVariability();
        double pixelSd = this.getPixelDigitalization();
        Normal sampleErrorDist = new Normal(0.0, sampleSd);
        Normal chipErrorDist = new Normal(0.0, chipSd);
        Normal pixelErrorDist = new Normal(0.0, pixelSd);
        double[][] chipErrors = new double[this.numDishes][numChips];
        double[][] sampleErrors = new double[this.numDishes][numChips];
        for (int d = 0; d < this.numDishes; ++d) {
            for (int ch = 0; ch < numChips; ++ch) {
                chipErrors[d][ch] = chipErrorDist.nextRandom();
                sampleErrors[d][ch] = sampleErrorDist.nextRandom();
            }
        }
        double[][] cellData = new double[this.timeSteps.length][numFactors];
        double[][] aggregation = new double[cellData.length][cellData[0].length];
        for (int d = 0; d < this.numDishes; ++d) {
            int sIndex;
            dishModel.setDishNumber(d);
            for (sIndex = 0; sIndex < this.timeSteps.length; ++sIndex) {
                Arrays.fill(aggregation[sIndex], 0.0);
            }
            for (int c = 0; c < this.numCellsPerDish; ++c) {
                if ((c + 1) % 50 == 0) {
                    this.dishNumber = d;
                    this.cellNumber = c;
                }
                for (int sIndex2 = 0; sIndex2 < this.timeSteps.length; ++sIndex2) {
                    Arrays.fill(cellData[sIndex2], 0.0);
                }
                history.initialize();
                int s = -1;
                int sIndex3 = 0;
                while (++s < this.stepsGenerated) {
                    if (s > 0) {
                        history.update();
                    }
                    if (s != this.timeSteps[sIndex3] - 1) continue;
                    double[][] historyArray = history.getHistoryArray();
                    for (int f = 0; f < numFactors; ++f) {
                        cellData[sIndex3][f] = historyArray[0][f];
                        if (this.isAntilogCalculated()) {
                            cellData[sIndex3][f] = Math.exp(cellData[sIndex3][f]);
                        }
                        if (!this.isRawDataSaved()) continue;
                        int row = d * this.numCellsPerDish + c;
                        this.rawData[f][sIndex3][row] = cellData[sIndex3][f];
                    }
                    if (++sIndex3 < this.timeSteps.length) continue;
                    break;
                }
                for (int i = 0; i < cellData.length; ++i) {
                    for (int j = 0; j < cellData[0].length; ++j) {
                        double[] dArray = aggregation[i];
                        int n = j;
                        dArray[n] = dArray[n] + cellData[i][j];
                    }
                }
            }
            if (!this.measuredDataSaved) continue;
            for (sIndex = 0; sIndex < this.timeSteps.length; ++sIndex) {
                for (int f = 0; f < numFactors; ++f) {
                    for (int ch = 0; ch < numChips; ++ch) {
                        double measurement;
                        double average = aggregation[sIndex][f] / (double)this.numCellsPerDish;
                        double pixelError = pixelErrorDist.nextRandom();
                        this.measuredData[f][sIndex][d * numChips + ch] = measurement = average + sampleErrors[d][ch] + chipErrors[d][ch] + pixelError;
                    }
                }
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.timeSteps == null) {
            throw new NullPointerException();
        }
        if (this.chipChipVariability <= 0.0 || this.chipChipVariability >= 1.0) {
            throw new IllegalStateException();
        }
        if (this.sampleSampleVariability <= 0.0 || this.sampleSampleVariability >= 1.0) {
            throw new IllegalStateException();
        }
        if (this.pixelDigitalization <= 0.0 || this.pixelDigitalization >= 1.0) {
            throw new IllegalStateException();
        }
        if (this.dishDishVariability <= 0.0 || this.dishDishVariability >= 100.0) {
            throw new IllegalStateException();
        }
        if (this.numDishes <= 0) {
            throw new IllegalStateException();
        }
        if (this.numCellsPerDish <= 0) {
            throw new IllegalStateException();
        }
        if (this.stepsGenerated <= 0) {
            throw new IllegalStateException();
        }
        if (this.firstStepStored <= 0) {
            throw new IllegalStateException();
        }
        if (this.interval <= 0) {
            throw new IllegalStateException();
        }
        if (this.numSamplesPerDish <= 0) {
            throw new IllegalStateException();
        }
    }
}

