/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.simulation;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.gene.history.BasalInitializer;
import edu.cmu.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.history.BooleanGlassFunction;
import edu.cmu.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.history.PreviousStepOnly;
import edu.cmu.tetrad.gene.simulation.MeasurementSimulator;
import edu.cmu.tetrad.util.RandomUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMeasurementSimulator
extends TestCase {
    private MeasurementSimulator simulator = null;
    private BooleanGlassFunction updateFunction;
    private GeneHistory history = null;

    public TestMeasurementSimulator(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        BasicLagGraph lagGraph = new BasicLagGraph();
        lagGraph.addFactor("G1");
        lagGraph.addFactor("G2");
        lagGraph.addFactor("G3");
        PreviousStepOnly graphInitializer = new PreviousStepOnly();
        graphInitializer.initialize(lagGraph);
        lagGraph.addEdge("G2", new LaggedFactor("G1", 1));
        lagGraph.addEdge("G3", new LaggedFactor("G1", 1));
        lagGraph.addEdge("G3", new LaggedFactor("G2", 1));
        this.updateFunction = new BooleanGlassFunction(lagGraph);
        BasalInitializer historyInitializer = new BasalInitializer(this.updateFunction, 0.0, 1.0);
        this.history = new GeneHistory(historyInitializer, this.updateFunction);
        this.simulator = new MeasurementSimulator();
        RandomUtil.getInstance().setSeed(-1349902993443L);
    }

    private void setDefaultParameters() {
        this.updateFunction.setDecayRate(0.1);
        this.updateFunction.setBooleanInfluenceRate(0.5);
        this.simulator.setDishDishVariability(10.0);
        this.simulator.setNumSamplesPerDish(4);
        this.simulator.setSampleSampleVariability(0.025);
        this.simulator.setChipChipVariability(0.1);
        this.simulator.setPixelDigitalization(0.025);
        this.simulator.setNumDishes(1);
        this.simulator.setNumCellsPerDish(10000);
        this.simulator.setStepsGenerated(4);
        this.simulator.setFirstStepStored(1);
        this.simulator.setInterval(1);
        this.simulator.setRawDataSaved(false);
        this.simulator.setInitSync(true);
    }

    public void testDefaultParameterSettings() {
        this.setDefaultParameters();
        TestMeasurementSimulator.assertEquals(10.0, this.simulator.getDishDishVariability(), 1.0E-4);
        TestMeasurementSimulator.assertEquals(4, this.simulator.getNumSamplesPerDish());
        TestMeasurementSimulator.assertEquals(0.025, this.simulator.getSampleSampleVariability(), 1.0E-4);
        TestMeasurementSimulator.assertEquals(0.1, this.simulator.getChipChipVariability(), 1.0E-4);
        TestMeasurementSimulator.assertEquals(0.025, this.simulator.getPixelDigitalization(), 1.0E-4);
        TestMeasurementSimulator.assertEquals(1, this.simulator.getNumDishes());
        TestMeasurementSimulator.assertEquals(10000, this.simulator.getNumCellsPerDish());
        TestMeasurementSimulator.assertEquals(4, this.simulator.getStepsGenerated());
        TestMeasurementSimulator.assertEquals(1, this.simulator.getFirstStepStored());
        TestMeasurementSimulator.assertEquals(1, this.simulator.getInterval());
        TestMeasurementSimulator.assertEquals(false, this.simulator.isRawDataSaved());
        TestMeasurementSimulator.assertEquals(true, this.simulator.isInitSync());
        int[] timeSteps = this.simulator.getTimeSteps();
        TestMeasurementSimulator.assertEquals(4, timeSteps.length);
        for (int i = 0; i < timeSteps.length; ++i) {
            TestMeasurementSimulator.assertEquals(i + 1, timeSteps[i]);
        }
    }

    public void testTranscriptionError() {
        this.setDefaultParameters();
        this.simulator.setRawDataSaved(true);
        this.simulator.setMeasuredDataSaved(false);
        this.simulator.simulate(this.history);
        double[][][] rawData = this.simulator.getRawData();
        TestMeasurementSimulator.assertEquals(3, rawData.length);
        TestMeasurementSimulator.assertEquals(4, rawData[0].length);
        TestMeasurementSimulator.assertEquals(10000, rawData[0][0].length);
        DoubleArrayList doubleArrayList = new DoubleArrayList(rawData[0][1]);
        double sum = Descriptive.sum(doubleArrayList);
        double sumOfSquares = Descriptive.sumOfSquares(doubleArrayList);
        double stdev = Descriptive.standardDeviation(Descriptive.variance(rawData[0][1].length, sum, sumOfSquares));
        TestMeasurementSimulator.assertEquals(0.05, stdev, 0.01);
    }

    public void testDishToDishVariability() {
        this.setDefaultParameters();
        this.simulator.setNumDishes(100);
        this.simulator.setStepsGenerated(2);
        this.simulator.setNumSamplesPerDish(1);
        this.simulator.setSampleSampleVariability(1.0E-4);
        this.simulator.setChipChipVariability(1.0E-4);
        this.simulator.setPixelDigitalization(1.0E-4);
        this.simulator.setNumCellsPerDish(100);
        this.simulator.simulate(this.history);
        double[][][] measuredData = this.simulator.getMeasuredData();
        DoubleArrayList doubleArrayList = new DoubleArrayList(measuredData[1][0]);
        double sum = Descriptive.sum(doubleArrayList);
        double sumOfSquares = Descriptive.sumOfSquares(doubleArrayList);
        double gene2time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][0].length, sum, sumOfSquares));
        DoubleArrayList doubleArrayList1 = new DoubleArrayList(measuredData[2][0]);
        double sum1 = Descriptive.sum(doubleArrayList1);
        double sumOfSquares1 = Descriptive.sumOfSquares(doubleArrayList1);
        double gene3time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[2][0].length, sum1, sumOfSquares1));
        double gene2time1mean = Descriptive.mean(new DoubleArrayList(measuredData[1][0]));
        double gene3time1mean = Descriptive.mean(new DoubleArrayList(measuredData[2][0]));
        TestMeasurementSimulator.assertEquals(Math.abs(0.1 * gene2time1mean), gene2time1sd, 0.03);
        TestMeasurementSimulator.assertEquals(Math.abs(0.1 * gene3time1mean), gene3time1sd, 0.03);
    }

    public void testSampleToSampleError() {
        this.setDefaultParameters();
        this.simulator.setNumSamplesPerDish(1000);
        this.simulator.setSampleSampleVariability(0.2);
        this.simulator.setChipChipVariability(1.0E-4);
        this.simulator.setPixelDigitalization(1.0E-4);
        this.simulator.setStepsGenerated(2);
        this.simulator.setNumCellsPerDish(100);
        this.simulator.simulate(this.history);
        double[][][] measuredData = this.simulator.getMeasuredData();
        DoubleArrayList doubleArrayList = new DoubleArrayList(measuredData[1][0]);
        double sum = Descriptive.sum(doubleArrayList);
        double sumOfSquares = Descriptive.sumOfSquares(doubleArrayList);
        double gene2time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][0].length, sum, sumOfSquares));
        DoubleArrayList doubleArrayList1 = new DoubleArrayList(measuredData[2][0]);
        double sum1 = Descriptive.sum(doubleArrayList1);
        double sumOfSquares1 = Descriptive.sumOfSquares(doubleArrayList1);
        double gene3time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[2][0].length, sum1, sumOfSquares1));
        TestMeasurementSimulator.assertEquals(0.2, gene2time1sd, 0.02);
        TestMeasurementSimulator.assertEquals(0.2, gene3time1sd, 0.02);
    }

    public void testChipToChipError() {
        this.setDefaultParameters();
        this.simulator.setDishDishVariability(1.0E-4);
        this.simulator.setNumSamplesPerDish(1000);
        this.simulator.setSampleSampleVariability(1.0E-4);
        this.simulator.setChipChipVariability(0.3);
        this.simulator.setPixelDigitalization(1.0E-4);
        this.simulator.setStepsGenerated(2);
        this.simulator.setNumCellsPerDish(100);
        this.simulator.simulate(this.history);
        double[][][] measuredData = this.simulator.getMeasuredData();
        DoubleArrayList doubleArrayList = new DoubleArrayList(measuredData[1][0]);
        double sum = Descriptive.sum(doubleArrayList);
        double sumOfSquares = Descriptive.sumOfSquares(doubleArrayList);
        double gene2time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][0].length, sum, sumOfSquares));
        DoubleArrayList doubleArrayList1 = new DoubleArrayList(measuredData[2][0]);
        double sum1 = Descriptive.sum(doubleArrayList1);
        double sumOfSquares1 = Descriptive.sumOfSquares(doubleArrayList1);
        double gene3time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[2][0].length, sum1, sumOfSquares1));
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(measuredData[1][1]);
        double sum2 = Descriptive.sum(doubleArrayList2);
        double sumOfSquares2 = Descriptive.sumOfSquares(doubleArrayList2);
        double gene1time2sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][1].length, sum2, sumOfSquares2));
        TestMeasurementSimulator.assertEquals(0.3, gene2time1sd, 0.02);
        TestMeasurementSimulator.assertEquals(0.3, gene3time1sd, 0.02);
        TestMeasurementSimulator.assertEquals(0.3, gene1time2sd, 0.02);
    }

    public void testPixelError() {
        this.setDefaultParameters();
        this.simulator.setDishDishVariability(1.0E-4);
        this.simulator.setNumSamplesPerDish(1000);
        this.simulator.setSampleSampleVariability(1.0E-4);
        this.simulator.setChipChipVariability(1.0E-4);
        this.simulator.setPixelDigitalization(0.3);
        this.simulator.setStepsGenerated(2);
        this.simulator.setNumCellsPerDish(100);
        this.simulator.simulate(this.history);
        double[][][] measuredData = this.simulator.getMeasuredData();
        DoubleArrayList doubleArrayList = new DoubleArrayList(measuredData[1][0]);
        double sum = Descriptive.sum(doubleArrayList);
        double sumOfSquares = Descriptive.sumOfSquares(doubleArrayList);
        double gene2time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][0].length, sum, sumOfSquares));
        DoubleArrayList doubleArrayList1 = new DoubleArrayList(measuredData[2][0]);
        double sum1 = Descriptive.sum(doubleArrayList1);
        double sumOfSquares1 = Descriptive.sumOfSquares(doubleArrayList1);
        double gene3time1sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[2][0].length, sum1, sumOfSquares1));
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(measuredData[1][1]);
        double sum2 = Descriptive.sum(doubleArrayList2);
        double sumOfSquares2 = Descriptive.sumOfSquares(doubleArrayList2);
        double gene1time2sd = Descriptive.standardDeviation(Descriptive.variance(measuredData[1][1].length, sum2, sumOfSquares2));
        TestMeasurementSimulator.assertEquals(0.3, gene2time1sd, 0.1);
        TestMeasurementSimulator.assertEquals(0.3, gene3time1sd, 0.1);
        TestMeasurementSimulator.assertEquals(0.3, gene1time2sd, 0.1);
    }

    public static Test suite() {
        return new TestSuite(TestMeasurementSimulator.class);
    }
}

