/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Edge
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private Node node1;
    private Node node2;
    private Endpoint endpoint1;
    private Endpoint endpoint2;

    public Edge(Node node1, Node node2, Endpoint endpoint1, Endpoint endpoint2) {
        if (node1 == null || node2 == null) {
            throw new NullPointerException("Nodes must not be null.");
        }
        if (endpoint1 == null || endpoint2 == null) {
            throw new NullPointerException("Endpoints must not be null.");
        }
        if (this.pointingLeft(endpoint1, endpoint2)) {
            this.node1 = node2;
            this.node2 = node1;
            this.endpoint1 = endpoint2;
            this.endpoint2 = endpoint1;
        } else {
            this.node1 = node1;
            this.node2 = node2;
            this.endpoint1 = endpoint1;
            this.endpoint2 = endpoint2;
        }
    }

    public Edge(Edge edge) {
        this(edge.node1, edge.node2, edge.endpoint1, edge.endpoint2);
    }

    public static Edge serializableInstance() {
        return new Edge(GraphNode.serializableInstance(), GraphNode.serializableInstance(), Endpoint.ARROW, Endpoint.ARROW);
    }

    public final Node getNode1() {
        return this.node1;
    }

    public final Node getNode2() {
        return this.node2;
    }

    public final Endpoint getEndpoint1() {
        return this.endpoint1;
    }

    public final Endpoint getEndpoint2() {
        return this.endpoint2;
    }

    public final void setEndpoint1(Endpoint e) {
        this.endpoint1 = e;
    }

    public final void setEndpoint2(Endpoint e) {
        this.endpoint2 = e;
    }

    public final Endpoint getProximalEndpoint(Node node) {
        if (((Object)this.getNode1()).equals(node)) {
            return this.getEndpoint1();
        }
        if (((Object)this.getNode2()).equals(node)) {
            return this.getEndpoint2();
        }
        throw new IllegalArgumentException();
    }

    public final Endpoint getDistalEndpoint(Node node) {
        if (((Object)this.getNode1()).equals(node)) {
            return this.getEndpoint2();
        }
        if (((Object)this.getNode2()).equals(node)) {
            return this.getEndpoint1();
        }
        throw new IllegalArgumentException();
    }

    public final Node getDistalNode(Node node) {
        if (((Object)this.getNode1()).equals(node)) {
            return this.getNode2();
        }
        if (((Object)this.getNode2()).equals(node)) {
            return this.getNode1();
        }
        throw new IllegalArgumentException();
    }

    public boolean isDirected() {
        Endpoint endpt1 = this.getEndpoint1();
        Endpoint endpt2 = this.getEndpoint2();
        return endpt1 == Endpoint.TAIL && endpt2 == Endpoint.ARROW || endpt1 == Endpoint.ARROW && endpt2 == Endpoint.TAIL;
    }

    public boolean pointsTowards(Node node) {
        Endpoint proximal = this.getProximalEndpoint(node);
        Endpoint distal = this.getDistalEndpoint(node);
        return proximal == Endpoint.ARROW && (distal == Endpoint.TAIL || distal == Endpoint.CIRCLE);
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        Endpoint endptTypeA = this.getEndpoint1();
        Endpoint endptTypeB = this.getEndpoint2();
        buf.append(this.getNode1());
        buf.append(" ");
        if (endptTypeA == Endpoint.TAIL) {
            buf.append("-");
        } else if (endptTypeA == Endpoint.ARROW) {
            buf.append("<");
        } else if (endptTypeA == Endpoint.CIRCLE) {
            buf.append("o");
        }
        buf.append("-");
        if (endptTypeB == Endpoint.TAIL) {
            buf.append("-");
        } else if (endptTypeB == Endpoint.ARROW) {
            buf.append(">");
        } else if (endptTypeB == Endpoint.CIRCLE) {
            buf.append("o");
        }
        buf.append(" ");
        buf.append(this.getNode2());
        return buf.toString();
    }

    public final int hashCode() {
        int hashCode = 61;
        hashCode = 17 * hashCode;
        hashCode += ((Object)this.node1).hashCode() * this.endpoint1.hashCode();
        return hashCode += ((Object)this.node2).hashCode() * this.endpoint2.hashCode();
    }

    public final boolean equals(Object o) {
        Edge edge = (Edge)o;
        if (edge.getNode1().getName().equals(this.getNode1().getName()) && edge.getNode2().getName().equals(this.getNode2().getName())) {
            return this.getEndpoint1() == edge.getEndpoint1() && this.getEndpoint2() == edge.getEndpoint2();
        }
        if (edge.getNode1().getName().equals(this.getNode2().getName()) && edge.getNode2().getName().equals(this.getNode1().getName())) {
            return this.getEndpoint1() == edge.getEndpoint2() && this.getEndpoint2() == edge.getEndpoint1();
        }
        return false;
    }

    private boolean pointingLeft(Endpoint endpoint1, Endpoint endpoint2) {
        return endpoint1 == Endpoint.ARROW && (endpoint2 == Endpoint.TAIL || endpoint2 == Endpoint.CIRCLE);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.node1 == null) {
            throw new NullPointerException();
        }
        if (this.node2 == null) {
            throw new NullPointerException();
        }
        if (this.endpoint1 == null) {
            throw new NullPointerException();
        }
        if (this.endpoint2 == null) {
            throw new NullPointerException();
        }
    }
}

