/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.FruchtermanReingoldLayout;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.KamadaKawaiLayout;
import edu.cmu.tetrad.graph.LayeredDrawing;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.graph.UniformGraphGenerator;
import edu.cmu.tetrad.graph.UniformGraphGenerator2;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

public final class GraphUtils {
    private static final int NODE_GAP = 50;

    public static void arrangeInCircle(Graph graph, int centerx, int centery, int radius) {
        List<Node> nodes = graph.getNodes();
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        double rad = 6.28 / (double)nodes.size();
        double phi = 4.71;
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node1;
            Node node = node1 = i$.next();
            int centerX = centerx + (int)((double)radius * Math.cos(phi));
            int centerY = centery + (int)((double)radius * Math.sin(phi));
            node.setCenterX(centerX);
            node.setCenterY(centerY);
            phi += rad;
        }
    }

    public static void arrangeByGraphTiers(Graph graph) {
        List<List<Node>> tiers = GraphUtils.getTiers(graph);
        int y = 0;
        for (List<Node> tier1 : tiers) {
            y += 50;
            int x = 0;
            for (Node aTier : tier1) {
                Node node = aTier;
                node.setCenterX(x += 90);
                node.setCenterY(y);
            }
        }
    }

    public static void hierarchicalLayout(Graph graph) {
        LayeredDrawing layout = new LayeredDrawing(graph);
        layout.doLayout();
    }

    public static void kamadaKawaiLayout(Graph graph, boolean randomlyInitialized, double naturalEdgeLength, double springConstant, double stopEnergy) {
        KamadaKawaiLayout layout = new KamadaKawaiLayout(graph);
        layout.setRandomlyInitialized(randomlyInitialized);
        layout.setNaturalEdgeLength(naturalEdgeLength);
        layout.setSpringConstant(springConstant);
        layout.setStopEnergy(stopEnergy);
        layout.doLayout();
    }

    public static void fruchtermanReingoldLayout(Graph graph) {
        FruchtermanReingoldLayout layout = new FruchtermanReingoldLayout(graph);
        layout.doLayout();
    }

    public static List<List<Node>> getTiers(Graph graph) {
        HashSet found = new HashSet();
        HashSet<Node> notFound = new HashSet<Node>();
        LinkedList<List<Node>> tiers = new LinkedList<List<Node>>();
        notFound.addAll(graph.getNodes());
        int notFoundSize = 0;
        boolean jumpstart = false;
        while (!notFound.isEmpty()) {
            LinkedList<Node> thisTier = new LinkedList<Node>();
            Iterator i$ = notFound.iterator();
            while (i$.hasNext()) {
                Node _node;
                Node aNotFound;
                Node node = aNotFound = (Node)i$.next();
                List<Node> adj = graph.getAdjacentNodes(node);
                LinkedList<Node> parents = new LinkedList<Node>();
                for (Node anAdj : adj) {
                    _node = anAdj;
                    Edge edge = graph.getEdge(node, _node);
                    if (edge.getProximalEndpoint(node) != Endpoint.ARROW || edge.getDistalEndpoint(node) != Endpoint.TAIL) continue;
                    parents.add(_node);
                }
                if (found.containsAll(parents)) {
                    thisTier.add(node);
                    continue;
                }
                if (!jumpstart) continue;
                for (Node parent : parents) {
                    _node = parent;
                    if (found.contains(_node)) continue;
                    thisTier.add(_node);
                }
                if (!found.contains(node)) {
                    thisTier.add(node);
                }
                jumpstart = false;
            }
            notFound.removeAll(thisTier);
            found.addAll(thisTier);
            if (notFoundSize == notFound.size()) {
                jumpstart = true;
            }
            notFoundSize = notFound.size();
            if (thisTier.isEmpty()) continue;
            tiers.add(thisTier);
        }
        return tiers;
    }

    public static void arrangeClustersInCircle(Graph graph) {
        LinkedList<Node> latents = new LinkedList<Node>();
        LinkedList<List<Node>> partition = new LinkedList<List<Node>>();
        int totalSize = GraphUtils.getMeasurementModel(graph, latents, partition);
        boolean[] gaps = new boolean[totalSize];
        LinkedList nodes = new LinkedList();
        int count = 0;
        for (int i = latents.size() - 1; i >= 0; --i) {
            nodes.add(latents.get(i));
            gaps[count++] = i == 0;
        }
        Iterator i$ = partition.iterator();
        while (i$.hasNext()) {
            List aPartition;
            List cluster = aPartition = (List)i$.next();
            for (int i = 0; i < cluster.size(); ++i) {
                nodes.add(cluster.get(i));
                gaps[count++] = i == cluster.size() - 1;
            }
        }
        double rad = 6.28 / (double)(nodes.size() + partition.size() + 1);
        double phi = 4.71;
        for (int i = 0; i < nodes.size(); ++i) {
            Node n1 = (Node)nodes.get(i);
            int centerX = 200 + (int)(150.0 * Math.cos(phi));
            int centerY = 200 + (int)(150.0 * Math.sin(phi));
            n1.setCenterX(centerX);
            n1.setCenterY(centerY);
            if (gaps[i]) {
                phi += 2.0 * rad;
                continue;
            }
            phi += rad;
        }
    }

    public static void arrangeClustersInLine(Graph graph, boolean jitter) {
        LinkedList<Node> latents = new LinkedList<Node>();
        LinkedList<List<Node>> partition = new LinkedList<List<Node>>();
        GraphUtils.getMeasurementModel(graph, latents, partition);
        LinkedList nodes = new LinkedList();
        double[] clusterWidth = new double[partition.size()];
        double[][] indicatorWidth = new double[partition.size()][];
        double[] latentWidth = new double[partition.size()];
        for (int i = 0; i < latents.size(); ++i) {
            nodes.add(latents.get(i));
            latentWidth[i] = 60.0;
        }
        int k = 0;
        while (k < partition.size()) {
            List cluster = (List)partition.get(k);
            clusterWidth[k] = 0.0;
            indicatorWidth[k] = new double[cluster.size()];
            for (int i = 0; i < cluster.size(); ++i) {
                nodes.add(cluster.get(i));
                indicatorWidth[k][i] = 60.0;
                int n = k;
                clusterWidth[n] = clusterWidth[n] + 60.0;
            }
            int n = k++;
            clusterWidth[n] = clusterWidth[n] + ((double)cluster.size() - 1.0) * 50.0;
        }
        int currentPos = 50;
        for (int k2 = 0; k2 < partition.size(); ++k2) {
            Node nl = (Node)latents.get(k2);
            nl.setCenterX(currentPos + (int)(clusterWidth[k2] / 2.0));
            int noise = 0;
            if (jitter) {
                noise = RandomUtil.getInstance().nextInt(50) - 25;
            }
            nl.setCenterY(100 + noise);
            List cluster = (List)partition.get(k2);
            for (int i = 0; i < cluster.size(); ++i) {
                Node ni = (Node)cluster.get(i);
                int centerX = currentPos + (int)(indicatorWidth[k2][i] / 2.0);
                ni.setCenterX(centerX);
                ni.setCenterY(200);
                currentPos = (int)((double)currentPos + (indicatorWidth[k2][i] + 50.0));
            }
            currentPos = (int)((double)currentPos + 100.0);
        }
    }

    public static int getMeasurementModel(Graph graph, List<Node> latents, List<List<Node>> partition) {
        int totalSize = 0;
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            List<Node> children = graph.getChildren(node);
            LinkedList<Node> newCluster = new LinkedList<Node>();
            for (Node aChildren : children) {
                Node child = aChildren;
                if (child.getNodeType() != NodeType.MEASURED) continue;
                newCluster.add(child);
            }
            latents.add(node);
            partition.add(newCluster);
            totalSize += 1 + newCluster.size();
        }
        return totalSize;
    }

    public static Dag randomDag(List<Node> nodes, int numLatentNodes, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        int numNodes = nodes.size();
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (maxNumEdges < 0 || maxNumEdges > numNodes * (numNodes - 1)) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + maxNumEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        for (Node node : nodes) {
            node.setNodeType(NodeType.MEASURED);
        }
        UniformGraphGenerator generator = connected ? new UniformGraphGenerator(1) : new UniformGraphGenerator(0);
        generator.setNumNodes(numNodes);
        generator.setMaxEdges(maxNumEdges);
        generator.setMaxDegree(maxDegree);
        generator.setMaxInDegree(maxIndegree);
        generator.setMaxOutDegree(maxOutdegree);
        generator.generate();
        Dag dag = generator.getDag(nodes);
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        return dag;
    }

    public static Dag randomDag(int numNodes, int numLatentNodes, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (maxNumEdges < 0 || maxNumEdges > numNodes * (numNodes - 1)) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + maxNumEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        UniformGraphGenerator generator = connected ? new UniformGraphGenerator(1) : new UniformGraphGenerator(0);
        generator.setNumNodes(numNodes);
        generator.setMaxEdges(maxNumEdges);
        generator.setMaxDegree(maxDegree);
        generator.setMaxInDegree(maxIndegree);
        generator.setMaxOutDegree(maxOutdegree);
        generator.generate();
        Dag dag = generator.getDag();
        List<Node> nodes = dag.getNodes();
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        return dag;
    }

    public static Dag randomDag(int numNodes, int numEdges, boolean connected) {
        Dag dag;
        while ((dag = GraphUtils.randomDag(numNodes, 0, numEdges, 30, 15, 15, connected)).getNumEdges() < numEdges) {
        }
        return dag;
    }

    public static Dag randomDagB(int numNodes, int numLatentNodes, int numEdges, double convergenceBias, double divergenceBias, double chainingBias) {
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (numEdges < 0 || numEdges > numNodes * (numNodes - 1) / 2) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + numEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        Dag graph = new Dag();
        Dag dpathGraph = new Dag();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        for (int i = 1; i <= numNodes; ++i) {
            GraphNode node = new GraphNode("X" + nf.format(i));
            nodes.add(node);
        }
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = (Node)nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        Iterator i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node3;
            Node node = node3 = (Node)i$.next();
            graph.addNode(node);
            dpathGraph.addNode(node);
        }
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        while (graph.getNumEdges() < numEdges) {
            double[] fromWeights = new double[numNodes];
            for (int j = 0; j < numNodes; ++j) {
                Node from = (Node)nodes.get(j);
                for (int k = 0; k < numNodes; ++k) {
                    Node to;
                    if (j == k || graph.isParentOf(from, to = (Node)nodes.get(k)) || dpathGraph.isParentOf(to, from)) continue;
                    int n = j;
                    fromWeights[n] = fromWeights[n] + 1.0;
                }
                int indegree = graph.getIndegree(from);
                int outdegree = graph.getOutdegree(from);
                if (outdegree > 0) {
                    int n = j;
                    fromWeights[n] = fromWeights[n] * GraphUtils.multiplier(divergenceBias, numNodes);
                    if (fromWeights[j] == 0.0) {
                        fromWeights[j] = 1.0E-10;
                    }
                }
                if (indegree != 1 || outdegree != 0) continue;
                int n = j;
                fromWeights[n] = fromWeights[n] * GraphUtils.multiplier(chainingBias, numNodes);
                if (fromWeights[j] != 0.0) continue;
                fromWeights[j] = 1.0E-10;
            }
            int fromIndex = GraphUtils.getIndex(fromWeights);
            double[] toWeights = new double[numNodes];
            boolean foundPositiveWeight = false;
            for (int j = 0; j < numNodes; ++j) {
                Node to;
                Node from;
                if (j == fromIndex || graph.isParentOf(from = (Node)nodes.get(fromIndex), to = (Node)nodes.get(j)) || graph.isAncestorOf(to, from)) continue;
                toWeights[j] = 1.0;
                int indegree = graph.getIndegree(to);
                int outdegree = graph.getOutdegree(to);
                if (indegree > 0) {
                    int n = j;
                    toWeights[n] = toWeights[n] * GraphUtils.multiplier(convergenceBias, numNodes);
                    if (toWeights[j] == 0.0) {
                        toWeights[j] = 1.0E-10;
                    }
                }
                if (indegree == 0 && outdegree == 1) {
                    int n = j;
                    toWeights[n] = toWeights[n] * GraphUtils.multiplier(chainingBias, numNodes);
                    if (toWeights[j] == 0.0) {
                        toWeights[j] = 1.0E-10;
                    }
                }
                foundPositiveWeight = true;
            }
            if (!foundPositiveWeight) continue;
            int toIndex = GraphUtils.getIndex(toWeights);
            Node node1 = (Node)nodes.get(fromIndex);
            Node node2 = (Node)nodes.get(toIndex);
            if (dpathGraph.isParentOf(node2, node1)) {
                throw new IllegalStateException();
            }
            graph.addDirectedEdge(node1, node2);
            if (!dpathGraph.isParentOf(node1, node2)) {
                dpathGraph.addDirectedEdge(node1, node2);
            }
            List<Node> parents = dpathGraph.getParents(node1);
            for (Node parent1 : parents) {
                Node parent = parent1;
                if (dpathGraph.isParentOf(parent, node2)) continue;
                dpathGraph.addDirectedEdge(parent, node2);
            }
        }
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    public static Dag randomDagC(int numNodes, int numLatentNodes, int numEdges) {
        void var9_16;
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (numEdges < 0 || numEdges > numNodes * (numNodes - 1) / 2) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + numEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        Dag graph = new Dag();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        System.out.println("Adding nodes");
        for (int i = 1; i <= numNodes; ++i) {
            GraphNode node = new GraphNode("X" + nf.format(i));
            nodes.add(node);
        }
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = (Node)nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        for (Node node : nodes) {
            graph.addNode(node);
        }
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        int numPossibleEdges = numNodes * numNodes;
        boolean bl = false;
        int numTrials = 0;
        while (var9_16 < numEdges && numTrials < 5 * numEdges) {
            Node node2;
            Node node1;
            int second;
            ++numTrials;
            System.out.println((int)var9_16);
            int edgeIndex = RandomUtil.getInstance().nextInt(numPossibleEdges);
            int first = edgeIndex / numNodes;
            if (first == (second = edgeIndex % numNodes)) continue;
            if (first < second) {
                node1 = (Node)nodes.get(first);
                node2 = (Node)nodes.get(second);
            } else {
                node1 = (Node)nodes.get(second);
                node2 = (Node)nodes.get(first);
            }
            if (graph.getEdge(node1, node2) != null) continue;
            graph.addDirectedEdge(node1, node2);
            ++var9_16;
        }
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    public static Graph randomDagCb(int numNodes, int numLatentNodes, int numEdges) {
        void var8_14;
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (numEdges < 0 || numEdges > numNodes * (numNodes - 1) / 2) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + numEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        EdgeListGraph graph = new EdgeListGraph();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        System.out.println("Adding nodes");
        for (int i = 1; i <= numNodes; ++i) {
            GraphNode graphNode = new GraphNode("X" + nf.format(i));
            nodes.add(graphNode);
            System.out.println("Adding " + i);
        }
        for (Node node : nodes) {
            graph.addNode(node);
        }
        int numPossibleEdges = numNodes * numNodes;
        boolean bl = false;
        int numTrials = 0;
        while (var8_14 < numEdges && numTrials < 5 * numEdges) {
            Node node2;
            Node node1;
            int second;
            ++numTrials;
            System.out.println((int)var8_14);
            int edgeIndex = RandomUtil.getInstance().nextInt(numPossibleEdges);
            int first = edgeIndex / numNodes;
            if (first == (second = edgeIndex % numNodes)) continue;
            if (first < second) {
                node1 = (Node)nodes.get(first);
                node2 = (Node)nodes.get(second);
            } else {
                node1 = (Node)nodes.get(second);
                node2 = (Node)nodes.get(first);
            }
            if (graph.getEdge(node1, node2) != null) continue;
            graph.addDirectedEdge(node1, node2);
            ++var8_14;
        }
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    public static Dag randomDagE(int numNodes, int numLatentNodes, int numEdges, int maxDegree, int maxIndegree, int maxOutdegree) {
        void var12_19;
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (numEdges < 0 || numEdges > numNodes * (numNodes - 1) / 2) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + numEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        Dag graph = new Dag();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        for (int i = 1; i <= numNodes; ++i) {
            GraphNode node = new GraphNode("X" + nf.format(i));
            nodes.add(node);
        }
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = (Node)nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        for (Node node : nodes) {
            graph.addNode(node);
        }
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        int numPossibleEdges = numNodes * numNodes;
        boolean bl = false;
        int numTrials = 0;
        while (var12_19 < numEdges && numTrials < 5 * numEdges) {
            Node node2;
            Node node1;
            int second;
            ++numTrials;
            int edgeIndex = RandomUtil.getInstance().nextInt(numPossibleEdges);
            int first = edgeIndex / numNodes;
            if (first == (second = edgeIndex % numNodes)) continue;
            if (first < second) {
                node1 = (Node)nodes.get(first);
                node2 = (Node)nodes.get(second);
            } else {
                node1 = (Node)nodes.get(second);
                node2 = (Node)nodes.get(first);
            }
            if (graph.getEdge(node1, node2) != null || graph.getIndegree(node2) > maxIndegree - 1 || graph.getOutdegree(node1) > maxOutdegree - 1 || graph.getNumEdges(node1) > maxDegree - 1 || graph.getNumEdges(node2) > maxDegree - 1) continue;
            graph.addDirectedEdge(node1, node2);
            ++var12_19;
        }
        return graph;
    }

    public static Dag randomDagD(int numNodes, int numLatentNodes, int minNumEdges, int maxNumEdges) {
        if (numNodes <= 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (maxNumEdges < 0 || maxNumEdges > numNodes * (numNodes - 1) / 2) {
            throw new IllegalArgumentException("NumEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + maxNumEdges);
        }
        if (numLatentNodes < 0 || numLatentNodes > numNodes) {
            throw new IllegalArgumentException("NumLatents must be greater than 0 and less than the number of nodes: " + numLatentNodes);
        }
        UniformGraphGenerator2 generator = new UniformGraphGenerator2(0);
        generator.setNumNodes(numNodes);
        generator.setMaxEdges(maxNumEdges);
        generator.setMinEdges(minNumEdges);
        generator.generate();
        Dag dag = generator.getDag();
        List<Node> nodes = dag.getNodes();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        for (int i = 0; i < numNodes; ++i) {
            Node node = nodes.get(i);
            node.setName("X" + nf.format(i + 1));
            nodes.add(node);
        }
        int numNodesMadeLatent = 0;
        while (numNodesMadeLatent < numLatentNodes) {
            int index = RandomUtil.getInstance().nextInt(numNodes);
            Node node = nodes.get(index);
            if (node.getNodeType() == NodeType.LATENT) continue;
            node.setNodeType(NodeType.LATENT);
            ++numNodesMadeLatent;
        }
        return dag;
    }

    public static Graph addCycles(Dag dag, int maxNumEdges, int minCycleLength) {
        if (maxNumEdges <= 0) {
            throw new IllegalArgumentException("maxNumEdges most be > 0: " + maxNumEdges);
        }
        if (minCycleLength <= 0) {
            throw new IllegalArgumentException("minCycleLength most be > 0: " + minCycleLength);
        }
        List<Edge> edges = dag.getEdges();
        EdgeListGraph graph = new EdgeListGraph(dag.getNodes());
        for (Edge e : edges) {
            graph.addEdge(e);
        }
        int cycles = maxNumEdges;
        List<Node> nodes = graph.getNodes();
        ArrayList<NodePair> cycleEdges = new ArrayList<NodePair>();
        for (Node i : nodes) {
            List<Node> c = GraphUtils.findPotentialCycle(i, graph, -minCycleLength + 1);
            for (Node j : c) {
                NodePair p = new NodePair(i, j);
                if (cycleEdges.contains(p)) continue;
                cycleEdges.add(p);
            }
        }
        if (cycles > cycleEdges.size()) {
            cycles = cycleEdges.size();
        }
        for (int i = cycles; i > 0; --i) {
            Random rand = new Random();
            int r = rand.nextInt(i);
            NodePair p = (NodePair)cycleEdges.get(r);
            graph.addDirectedEdge(graph.getNode(p.getFirst().getName()), graph.getNode(p.getSecond().getName()));
            cycleEdges.remove(r);
        }
        return graph;
    }

    public static Graph addCycles2(Dag dag, int minNumCycles, int minlength) {
        Edge edge;
        if (minlength < 2) {
            throw new IllegalArgumentException("Cycle length must be at least 2.");
        }
        EdgeListGraph graph = new EdgeListGraph(dag);
        List<Node> nodes = graph.getNodes();
        HashMap<Edge, List<List<Node>>> edgePaths = new HashMap<Edge, List<List<Node>>>();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                Node node2;
                Node node1;
                List<List<Node>> _directedPaths;
                if (i == j || (_directedPaths = GraphUtils.directedPathsFromTo(graph, node1 = nodes.get(i), node2 = nodes.get(j))).isEmpty()) continue;
                Edge edge2 = Edges.directedEdge(node2, node1);
                edgePaths.put(edge2, _directedPaths);
            }
        }
        block2: for (Edge edge3 : new HashSet(edgePaths.keySet())) {
            List paths = (List)edgePaths.get(edge3);
            for (List path : new ArrayList(paths)) {
                if (path.size() >= minlength) continue;
                edgePaths.remove(edge3);
                System.out.println("Num edges = " + edgePaths.keySet().size());
                continue block2;
            }
        }
        int trials = 0;
        ArrayList<Edge> cyclicEdges = new ArrayList<Edge>(edgePaths.keySet());
        for (int _numCycles = 0; _numCycles < minNumCycles && trials < minNumCycles; _numCycles += ((List)edgePaths.get(edge)).size()) {
            if (cyclicEdges.isEmpty()) {
                return null;
            }
            int r = RandomUtil.getInstance().nextInt(cyclicEdges.size());
            edge = (Edge)cyclicEdges.get(r);
            cyclicEdges.remove(edge);
            graph.addEdge(edge);
            List paths0 = (List)edgePaths.get(edge);
            GraphUtils.removeIdenticalPaths(edgePaths, edge, cyclicEdges);
            System.out.println("Adding " + ((List)edgePaths.get(edge)).size() + " cycles: " + edge);
        }
        return graph;
    }

    private static void removeIdenticalPaths(Map<Edge, List<List<Node>>> edgePaths, Edge edge, List<Edge> cyclicEdges) {
        for (Edge _edge : cyclicEdges) {
            for (List<Node> path : edgePaths.get(edge)) {
                for (List _path : new ArrayList(edgePaths.get(_edge))) {
                    if (GraphUtils.samePath(path, _path)) {
                        edgePaths.get(_edge).remove(_path);
                    }
                    if (!edgePaths.get(_edge).isEmpty()) continue;
                    edgePaths.remove(_edge);
                }
            }
        }
    }

    private static boolean samePath(List<Node> path1, List<Node> path2) {
        if (path1.isEmpty() && path2.isEmpty()) {
            return true;
        }
        if (path1.size() != path2.size()) {
            return false;
        }
        int firstIndex = path2.indexOf(path1.get(0));
        if (firstIndex == -1) {
            return false;
        }
        for (int i = 0; i < path1.size(); ++i) {
            Node node2;
            int i2 = (i + firstIndex) % path2.size();
            Node node1 = path1.get(i);
            if (node1 == (node2 = path2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static Graph addCycles3(Dag dag, int minNumCycles, int minlength) {
        Edge edge;
        if (minlength < 2) {
            throw new IllegalArgumentException("Cycle length must be at least 2.");
        }
        EdgeListGraph graph = new EdgeListGraph(dag);
        List<Node> nodes = graph.getNodes();
        HashMap<Edge, List<List<Node>>> edgePaths = new HashMap<Edge, List<List<Node>>>();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                List<List<Node>> _directedPaths;
                Node node2;
                Node node1;
                if (i == j || !graph.isAdjacentTo(node1 = nodes.get(i), node2 = nodes.get(j)) || (_directedPaths = GraphUtils.directedPathsFromTo(graph, node1, node2)).isEmpty()) continue;
                Edge edge2 = graph.getEdge(node1, node2);
                edgePaths.put(edge2, _directedPaths);
            }
        }
        int trials = 0;
        ArrayList cyclicEdges = new ArrayList(edgePaths.keySet());
        for (int _numCycles = 0; _numCycles < minNumCycles && trials < minNumCycles; _numCycles += ((List)edgePaths.get(edge)).size()) {
            if (cyclicEdges.isEmpty()) {
                return null;
            }
            int r = RandomUtil.getInstance().nextInt(cyclicEdges.size());
            edge = (Edge)cyclicEdges.get(r);
            cyclicEdges.remove(edge);
            for (List path : (List)edgePaths.get(edge)) {
                for (int i = 0; i < path.size() - 2; ++i) {
                    cyclicEdges.remove(graph.getEdge((Node)path.get(i), (Node)path.get(i + 1)));
                }
            }
            graph.removeEdge(edge.getNode1(), edge.getNode2());
            graph.addEdge(Edges.directedEdge(edge.getNode2(), edge.getNode1()));
        }
        return graph;
    }

    public static List<Node> findPotentialCycle(Node node, Graph dag, Integer depth) {
        ArrayList<Node> candidate = new ArrayList<Node>();
        List<Node> parent = dag.getParents(node);
        for (Node i : parent) {
            List<Node> c = GraphUtils.findPotentialCycle(i, dag, depth + 1);
            for (Node n : c) {
                candidate.add(n);
            }
        }
        if (depth > 0 && parent.size() == 0) {
            candidate.add(node);
        }
        return candidate;
    }

    public static Graph randomMim(int numStructuralNodes, int numStructuralEdges, int numMeasurementsPerLatent, int numLatentMeasuredImpureParents, int numMeasuredMeasuredImpureParents, int numMeasuredMeasuredImpureAssociations) {
        Node measure2;
        int k;
        Node measure1;
        int m;
        List<Node> measures;
        List<Node> nodes;
        int i;
        Dag dag = GraphUtils.randomDagB(numStructuralNodes, numStructuralNodes, numStructuralEdges, 0.0, 0.0, 0.0);
        EdgeListGraph graph = new EdgeListGraph(dag);
        List<Node> latents = graph.getNodes();
        for (int i2 = 0; i2 < latents.size(); ++i2) {
            Node latent = latents.get(i2);
            if (latent.getNodeType() != NodeType.LATENT) {
                throw new IllegalArgumentException("Expected latent.");
            }
            latent.setName("L" + (i2 + 1));
        }
        int measureIndex = 0;
        Iterator<Node> i$ = latents.iterator();
        while (i$.hasNext()) {
            Node latent1;
            Node latent = latent1 = i$.next();
            for (int j = 0; j < numMeasurementsPerLatent; ++j) {
                GraphNode measurement = new GraphNode("X" + ++measureIndex);
                graph.addNode(measurement);
                graph.addDirectedEdge(latent, measurement);
            }
        }
        int misses = 0;
        for (i = 0; i < numLatentMeasuredImpureParents && misses <= 10; ++i) {
            int j = RandomUtil.getInstance().nextInt(latents.size());
            Node latent = latents.get(j);
            nodes = graph.getNodes();
            measures = graph.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++misses;
                continue;
            }
            int k2 = RandomUtil.getInstance().nextInt(nodes.size());
            Node measure = nodes.get(k2);
            if (graph.getEdge(latent, measure) != null || graph.isAncestorOf(measure, latent)) {
                --i;
                ++misses;
                continue;
            }
            graph.addDirectedEdge(latent, measure);
        }
        misses = 0;
        for (i = 0; i < numMeasuredMeasuredImpureParents && misses <= 10; ++i) {
            int j = RandomUtil.getInstance().nextInt(latents.size());
            Node latent = latents.get(j);
            nodes = graph.getNodes();
            measures = graph.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            if (measures.isEmpty()) {
                --i;
                ++misses;
                continue;
            }
            m = RandomUtil.getInstance().nextInt(measures.size());
            measure1 = measures.get(m);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++misses;
                continue;
            }
            k = RandomUtil.getInstance().nextInt(nodes.size());
            measure2 = nodes.get(k);
            if (graph.getEdge(measure1, measure2) != null || graph.isAncestorOf(measure2, measure1)) {
                --i;
                ++misses;
                continue;
            }
            graph.addDirectedEdge(measure1, measure2);
        }
        misses = 0;
        for (i = 0; i < numMeasuredMeasuredImpureAssociations && misses <= 10; ++i) {
            int j = RandomUtil.getInstance().nextInt(latents.size());
            Node latent = latents.get(j);
            nodes = graph.getNodes();
            measures = graph.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            if (measures.isEmpty()) {
                --i;
                ++misses;
                continue;
            }
            m = RandomUtil.getInstance().nextInt(measures.size());
            measure1 = measures.get(m);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++misses;
                continue;
            }
            k = RandomUtil.getInstance().nextInt(nodes.size());
            measure2 = nodes.get(k);
            if (graph.getEdge(measure1, measure2) != null) {
                --i;
                ++misses;
                continue;
            }
            graph.addBidirectedEdge(measure1, measure2);
        }
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        GraphUtils.fruchtermanReingoldLayout(graph);
        return graph;
    }

    private static double multiplier(double bias, int numNodes) {
        if (bias > 0.0) {
            return (double)numNodes * bias + 1.0;
        }
        return bias + 1.0;
    }

    private static int getIndex(double[] weights) {
        double sum = 0.0;
        for (double weight : weights) {
            sum += weight;
        }
        double random = RandomUtil.getInstance().nextDouble() * sum;
        double partialSum = 0.0;
        for (int j = 0; j < weights.length; ++j) {
            if (!((partialSum += weights[j]) > random)) continue;
            return j;
        }
        throw new IllegalStateException();
    }

    public static boolean arrangeBySourceGraph(Graph resultGraph, Graph sourceGraph) {
        if (resultGraph == null) {
            throw new IllegalArgumentException("Graph must not be null.");
        }
        if (sourceGraph == null) {
            GraphUtils.arrangeInCircle(resultGraph, 200, 200, 150);
            return true;
        }
        boolean arrangedAll = true;
        for (Node o : resultGraph.getNodes()) {
            Node node = o;
            String name = node.getName();
            Node sourceNode = sourceGraph.getNode(name);
            if (sourceNode == null) {
                arrangedAll = false;
                continue;
            }
            node.setCenterX(sourceNode.getCenterX());
            node.setCenterY(sourceNode.getCenterY());
        }
        return arrangedAll;
    }

    public static void arrangeByLayout(Graph graph, HashMap<String, PointXy> layout) {
        for (Node node : graph.getNodes()) {
            PointXy point = layout.get(node.getName());
            node.setCenter(point.getX(), point.getY());
        }
    }

    public static Node getAssociatedNode(Node errorNode, Graph graph) {
        if (errorNode.getNodeType() != NodeType.ERROR) {
            throw new IllegalArgumentException("Can only get an associated node for an error node: " + errorNode);
        }
        List<Node> children = graph.getChildren(errorNode);
        if (children.size() != 1) {
            System.out.println("children of " + errorNode + " = " + children);
            System.out.println(graph);
            throw new IllegalArgumentException("An error node should have only one child, which is its associated node: " + errorNode);
        }
        return children.get(0);
    }

    public static boolean isClique(Set<Node> set, Graph graph) {
        LinkedList<Node> setv = new LinkedList<Node>(set);
        for (int i = 0; i < setv.size() - 1; ++i) {
            for (int j = i + 1; j < setv.size(); ++j) {
                if (graph.isAdjacentTo((Node)setv.get(i), (Node)setv.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static Dag markovBlanketDag(Node target, Graph dag) {
        Edge newEdge;
        Edge edge2;
        Edge edge1;
        Node parentOfChild;
        Node aParentsOfChildren;
        Iterator i$;
        Node child;
        if (dag.getNode(target.getName()) == null) {
            throw new NullPointerException("Target node not in graph: " + target);
        }
        EdgeListGraph blanket = new EdgeListGraph();
        blanket.addNode(target);
        List<Node> parents = dag.getParents(target);
        Iterator<Node> i$2 = parents.iterator();
        while (i$2.hasNext()) {
            Node parent1;
            Node parent = parent1 = i$2.next();
            blanket.addNode(parent);
            blanket.addDirectedEdge(parent, target);
        }
        List<Node> children = dag.getChildren(target);
        LinkedList<Node> parentsOfChildren = new LinkedList<Node>();
        for (Node aChildren : children) {
            child = aChildren;
            if (!blanket.containsNode(child)) {
                blanket.addNode(child);
            }
            blanket.addDirectedEdge(target, child);
            List<Node> parentsOfChild = dag.getParents(child);
            parentsOfChild.remove(target);
            for (Node aParentsOfChild : parentsOfChild) {
                Node parentOfChild2 = aParentsOfChild;
                if (!parentsOfChildren.contains(parentOfChild2)) {
                    parentsOfChildren.add(parentOfChild2);
                }
                if (!blanket.containsNode(parentOfChild2)) {
                    blanket.addNode(parentOfChild2);
                }
                blanket.addDirectedEdge(parentOfChild2, child);
            }
        }
        parentsOfChildren.removeAll(parents);
        Iterator<Node> i$3 = parents.iterator();
        while (i$3.hasNext()) {
            Node parent2;
            Node parent = parent2 = i$3.next();
            i$ = parentsOfChildren.iterator();
            while (i$.hasNext()) {
                parentOfChild = aParentsOfChildren = (Node)i$.next();
                edge1 = dag.getEdge(parent, parentOfChild);
                edge2 = blanket.getEdge(parent, parentOfChild);
                if (edge1 == null || edge2 != null) continue;
                newEdge = new Edge(parent, parentOfChild, edge1.getProximalEndpoint(parent), edge1.getProximalEndpoint(parentOfChild));
                blanket.addEdge(newEdge);
            }
        }
        i$3 = children.iterator();
        while (i$3.hasNext()) {
            Node aChildren1;
            child = aChildren1 = i$3.next();
            i$ = parentsOfChildren.iterator();
            while (i$.hasNext()) {
                parentOfChild = aParentsOfChildren = (Node)i$.next();
                edge1 = dag.getEdge(child, parentOfChild);
                edge2 = blanket.getEdge(child, parentOfChild);
                if (edge1 == null || edge2 != null) continue;
                newEdge = new Edge(child, parentOfChild, edge1.getProximalEndpoint(child), edge1.getProximalEndpoint(parentOfChild));
                blanket.addEdge(newEdge);
            }
        }
        return new Dag(blanket);
    }

    public static List<List<Node>> connectedComponents(Graph graph) {
        LinkedList<List<Node>> components = new LinkedList<List<Node>>();
        ArrayList<Node> unsortedNodes = new ArrayList<Node>(graph.getNodes());
        while (!unsortedNodes.isEmpty()) {
            Node seed = (Node)unsortedNodes.get(0);
            HashSet<Node> component = new HashSet<Node>();
            GraphUtils.collectComponentVisit(seed, component, graph, unsortedNodes);
            components.add(new ArrayList<Node>(component));
        }
        return components;
    }

    private static void collectComponentVisit(Node node, Set<Node> component, Graph graph, List<Node> unsortedNodes) {
        component.add(node);
        unsortedNodes.remove(node);
        List<Node> adj = graph.getAdjacentNodes(node);
        for (Node anAdj : adj) {
            Node _node = anAdj;
            if (component.contains(_node)) continue;
            GraphUtils.collectComponentVisit(_node, component, graph, unsortedNodes);
        }
    }

    public static List<Node> directedCycle(Graph graph) {
        for (Node node : graph.getNodes()) {
            List<Node> path = GraphUtils.directedPathFromTo(graph, node, node);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public static List<Node> directedPathFromTo(Graph graph, Node node1, Node node2) {
        return GraphUtils.directedPathVisit(graph, node1, node2, new LinkedList<Node>());
    }

    private static List<Node> directedPathVisit(Graph graph, Node node1, Node node2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                return path;
            }
            if (path.contains(child) || GraphUtils.directedPathVisit(graph, child, node2, path) == null) continue;
            return path;
        }
        path.removeLast();
        return null;
    }

    public static boolean allAdjacenciesAreDirected(Node node, Graph graph) {
        List<Edge> nodeEdges = graph.getEdges(node);
        for (Edge edge : nodeEdges) {
            if (edge.isDirected()) continue;
            return false;
        }
        return true;
    }

    public static Graph removeBidirectedOrientations(Graph estPattern) {
        estPattern = new EdgeListGraph(estPattern);
        for (Edge edge : estPattern.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            estPattern.removeEdge(edge);
            estPattern.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return estPattern;
    }

    public static Graph removeBidirectedEdges(Graph estPattern) {
        estPattern = new EdgeListGraph(estPattern);
        for (Edge edge : new ArrayList<Edge>(estPattern.getEdges())) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            estPattern.removeEdge(edge);
        }
        return estPattern;
    }

    public static Graph undirectedGraph(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            Edge undirectedEdge = Edges.undirectedEdge(edge.getNode1(), edge.getNode2());
            if (graph2.containsEdge(undirectedEdge)) continue;
            graph2.addEdge(undirectedEdge);
        }
        return graph2;
    }

    public static Graph nondirectedGraph(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            Edge nondirected = Edges.nondirectedEdge(edge.getNode1(), edge.getNode2());
            if (graph2.containsEdge(nondirected)) continue;
            graph2.addEdge(nondirected);
        }
        return graph2;
    }

    public static List<List<Node>> directedPathsFromTo(Graph graph, Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        GraphUtils.directedPathsFromToVisit(graph, node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    public static void directedPathsFromToVisit(Graph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        int witnessed = 0;
        for (Node node : path) {
            if (node != node1) continue;
            ++witnessed;
        }
        if (witnessed > 1) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            if (path.contains(child)) continue;
            GraphUtils.directedPathsFromToVisit(graph, child, node2, path, paths);
        }
        path.removeLast();
    }

    public static List<List<Node>> allPathsFromTo(Graph graph, Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        GraphUtils.allPathsFromToVisit(graph, node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    public static void allPathsFromToVisit(Graph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node child = Edges.traverse(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            if (path.contains(child)) continue;
            GraphUtils.allPathsFromToVisit(graph, child, node2, path, paths);
        }
        path.removeLast();
    }

    public static List<List<Node>> allPathsFromToExcluding(Graph graph, Node node1, Node node2, List<Node> excludes) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        GraphUtils.allPathsFromToExcludingVisit(graph, node1, node2, new LinkedList<Node>(), paths, excludes);
        return paths;
    }

    public static void allPathsFromToExcludingVisit(Graph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, List<Node> excludes) {
        if (excludes.contains(node1)) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node child = Edges.traverse(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            if (path.contains(child)) continue;
            GraphUtils.allPathsFromToVisit(graph, child, node2, path, paths);
        }
        path.removeLast();
    }

    public static List<List<Node>> treks(Graph graph, Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        GraphUtils.treks(graph, node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    private static void treks(Graph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        if (path.contains(node1)) {
            return;
        }
        if (node1 == node2) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (!edge.isDirected() || path.size() > 1 && (next == (node0 = path.get(path.size() - 2)) || graph.isDefCollider(node0, node1, next))) continue;
            if (next == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(next);
                paths.add(_path);
                continue;
            }
            if (path.contains(next)) continue;
            GraphUtils.treks(graph, next, node2, path, paths);
        }
        path.removeLast();
    }

    public static List<List<Node>> treksIncludingBidirected(SemGraph graph, Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        GraphUtils.treksIncludingBidirected(graph, node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    private static void treksIncludingBidirected(SemGraph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        if (!graph.isShowErrorTerms()) {
            throw new IllegalArgumentException("The SEM Graph must be showing its error terms; this method doesn't traverse two edges between the same nodes well.");
        }
        if (path.contains(node1)) {
            return;
        }
        if (node1 == node2) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (!edge.isDirected() && !Edges.isBidirectedEdge(edge) || path.size() > 1 && (next == (node0 = path.get(path.size() - 2)) || graph.isDefCollider(node0, node1, next))) continue;
            if (next == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(next);
                paths.add(_path);
                continue;
            }
            if (path.contains(next)) continue;
            GraphUtils.treksIncludingBidirected(graph, next, node2, path, paths);
        }
        path.removeLast();
    }

    public static List<List<Node>> dConnectingPaths(Graph graph, Node node1, Node node2, List<Node> conditioningNodes) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        HashSet<Node> conditioningNodesClosure = new HashSet<Node>();
        for (Node conditioningNode : conditioningNodes) {
            GraphUtils.doParentClosureVisit(graph, conditioningNode, conditioningNodesClosure);
        }
        Endpoint incomingEndpoint = null;
        GraphUtils.isDConnectedToVisit(graph, node1, incomingEndpoint, node2, new LinkedList<Node>(), paths, conditioningNodes, conditioningNodesClosure);
        return paths;
    }

    private static void doParentClosureVisit(Graph graph, Node node, Set<Node> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (Edge edge1 : graph.getEdges(node)) {
                Node sub = Edges.traverseReverseDirected(node, edge1);
                if (sub == null) continue;
                GraphUtils.doParentClosureVisit(graph, sub, closure);
            }
        }
    }

    private static void isDConnectedToVisit(Graph graph, Node currentNode, Endpoint inEdgeEndpoint, Node node2, LinkedList<Node> path, List<List<Node>> paths, List<Node> conditioningNodes, Set<Node> conditioningNodesClosure) {
        if (currentNode == node2) {
            LinkedList<Node> _path = new LinkedList<Node>(path);
            _path.add(currentNode);
            paths.add(_path);
            return;
        }
        if (path.contains(currentNode)) {
            return;
        }
        path.addLast(currentNode);
        for (Edge edge1 : graph.getEdges(currentNode)) {
            boolean passAsNonCollider;
            Endpoint outEdgeEndpoint = edge1.getProximalEndpoint(currentNode);
            boolean isCollider = inEdgeEndpoint == Endpoint.ARROW && outEdgeEndpoint == Endpoint.ARROW;
            boolean passAsCollider = isCollider && conditioningNodesClosure.contains(currentNode);
            boolean bl = passAsNonCollider = !isCollider && !conditioningNodes.contains(currentNode);
            if (!passAsCollider && !passAsNonCollider) continue;
            Node nextNode = Edges.traverse(currentNode, edge1);
            Endpoint previousEndpoint = edge1.getProximalEndpoint(nextNode);
            GraphUtils.isDConnectedToVisit(graph, nextNode, previousEndpoint, node2, path, paths, conditioningNodes, conditioningNodesClosure);
        }
        path.removeLast();
    }

    public static List<Edge> edgesComplement(Graph graph1, Graph graph2) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge1 : graph1.getEdges()) {
            Node node22;
            String name1 = edge1.getNode1().getName();
            String name2 = edge1.getNode2().getName();
            Node node21 = graph2.getNode(name1);
            Edge edge2 = graph2.getEdge(node21, node22 = graph2.getNode(name2));
            if (edge2 != null && edge1.equals(edge2)) continue;
            edges.add(edge1);
        }
        return edges;
    }

    public static List<Edge> edgesComplementUndirected(Graph graph1, Graph graph2) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge1 : graph1.getEdges()) {
            Node node22;
            String name1 = edge1.getNode1().getName();
            String name2 = edge1.getNode2().getName();
            Node node21 = graph2.getNode(name1);
            Edge edge2 = graph2.getEdge(node21, node22 = graph2.getNode(name2));
            if (edge2 != null) continue;
            edges.add(edge1);
        }
        return edges;
    }

    public static List<Edge> adjacenciesComplement(Graph graph1, Graph graph2) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge1 : graph1.getEdges()) {
            Node node22;
            String name1 = edge1.getNode1().getName();
            String name2 = edge1.getNode2().getName();
            Node node21 = graph2.getNode(name1);
            if (graph2.isAdjacentTo(node21, node22 = graph2.getNode(name2))) continue;
            edges.add(Edges.nondirectedEdge(node21, node22));
        }
        return edges;
    }

    public static int arrowEndpointComplement(Graph graph1, Graph graph2) {
        int count = 0;
        for (Edge edge1 : graph1.getEdges()) {
            String name1 = edge1.getNode1().getName();
            String name2 = edge1.getNode2().getName();
            Node node21 = graph2.getNode(name1);
            Node node22 = graph2.getNode(name2);
            Edge edge2 = graph2.getEdge(node21, node22);
            if (edge1.getEndpoint1() == Endpoint.ARROW) {
                if (edge2 == null) {
                    ++count;
                } else if (edge2.getEndpoint1() != Endpoint.ARROW) {
                    ++count;
                }
            }
            if (edge1.getEndpoint2() != Endpoint.ARROW) continue;
            if (edge2 == null) {
                ++count;
                continue;
            }
            if (edge2.getEndpoint2() == Endpoint.ARROW) continue;
            ++count;
        }
        return count;
    }

    public static int numDifferentOrientationsDirected(Graph graph1, Graph graph2) {
        int errors = 0;
        for (Edge edge : graph1.getEdges()) {
            if (!Edges.isDirectedEdge(edge)) continue;
            Node node2a = graph2.getNode(edge.getNode1().getName());
            Node node2b = graph2.getNode(edge.getNode2().getName());
            Edge edge2 = graph2.getEdge(node2a, node2b);
            Edge edge1Translated = new Edge(node2a, node2b, edge.getEndpoint1(), edge.getEndpoint2());
            if (edge2 == null || edge2.equals(edge1Translated)) continue;
            ++errors;
        }
        return errors;
    }

    public static int numDifferentOrientations(Graph graph1, Graph graph2) {
        int errors = 0;
        for (Edge edge : graph1.getEdges()) {
            Node node2a = graph2.getNode(edge.getNode1().getName());
            Node node2b = graph2.getNode(edge.getNode2().getName());
            Edge edge2 = graph2.getEdge(node2a, node2b);
            Edge edge1Translated = new Edge(node2a, node2b, edge.getEndpoint1(), edge.getEndpoint2());
            if (edge2 == null || edge2.equals(edge1Translated)) continue;
            ++errors;
        }
        return errors;
    }

    public static Graph bidirectedToUndirected(Graph graph) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Edge edge : newGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            newGraph.removeEdge(edge);
            newGraph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        return newGraph;
    }

    public static String pathString(Graph graph, List<Node> path) {
        return GraphUtils.pathString(graph, path, new LinkedList<Node>());
    }

    public static String pathString(Graph graph, List<Node> path, List<Node> conditioningVars) {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)path.get(0)).toString());
        if (conditioningVars.contains(path.get(0))) {
            buf.append("(C)");
        }
        for (int m = 1; m < path.size(); ++m) {
            Node n1;
            Node n0 = path.get(m - 1);
            Edge edge = graph.getEdge(n0, n1 = path.get(m));
            if (edge == null) {
                buf.append("(-)");
            } else {
                Endpoint endpoint0 = edge.getProximalEndpoint(n0);
                Endpoint endpoint1 = edge.getProximalEndpoint(n1);
                if (endpoint0 == Endpoint.ARROW) {
                    buf.append("<");
                } else if (endpoint0 == Endpoint.TAIL) {
                    buf.append("-");
                } else if (endpoint0 == Endpoint.CIRCLE) {
                    buf.append("o");
                }
                buf.append("-");
                if (endpoint1 == Endpoint.ARROW) {
                    buf.append(">");
                } else if (endpoint1 == Endpoint.TAIL) {
                    buf.append("-");
                } else if (endpoint1 == Endpoint.CIRCLE) {
                    buf.append("o");
                }
            }
            buf.append(((Object)n1).toString());
            if (!conditioningVars.contains(n1)) continue;
            buf.append("(C)");
        }
        return buf.toString();
    }

    public static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    public static Graph replaceNodes(Graph originalGraph, List<Node> newVariables) {
        EdgeListGraph convertedGraph = new EdgeListGraph(newVariables);
        for (Edge edge : originalGraph.getEdges()) {
            Node node1 = convertedGraph.getNode(edge.getNode1().getName());
            Node node2 = convertedGraph.getNode(edge.getNode2().getName());
            if (node1 == null) {
                throw new IllegalArgumentException("Couldn't find a node by the name " + edge.getNode1().getName() + " among the new variables for the converted graph (" + newVariables + ").");
            }
            if (node2 == null) {
                throw new IllegalArgumentException("Couldn't find a node by the name " + edge.getNode2().getName() + " among the new variables for the converted graph (" + newVariables + ").");
            }
            Endpoint endpoint1 = edge.getEndpoint1();
            Endpoint endpoint2 = edge.getEndpoint2();
            Edge newEdge = new Edge(node1, node2, endpoint1, endpoint2);
            convertedGraph.addEdge(newEdge);
        }
        return convertedGraph;
    }

    public static List<Node> replaceNodes(List<Node> originalNodes, List<Node> newNodes) {
        LinkedList<Node> convertedNodes = new LinkedList<Node>();
        for (Node node : originalNodes) {
            for (Node _node : newNodes) {
                if (!node.getName().equals(_node.getName())) continue;
                convertedNodes.add(_node);
            }
        }
        return convertedNodes;
    }

    public static int countAdjErrors(Graph graph1, Graph graph2) {
        if (graph1 == null) {
            throw new NullPointerException("The reference graph is missing.");
        }
        if (graph2 == null) {
            throw new NullPointerException("The target graph is missing.");
        }
        int count = 0;
        List<Node> graph1Nodes = graph1.getNodes();
        List<Node> graph2Nodes = graph2.getNodes();
        Comparator<Node> comparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return name1.compareTo(name2);
            }
        };
        Collections.sort(graph1Nodes, comparator);
        Collections.sort(graph2Nodes, comparator);
        if (graph1Nodes.size() != graph2Nodes.size()) {
            throw new IllegalArgumentException("The graph sizes are different.");
        }
        for (int i = 0; i < graph1Nodes.size(); ++i) {
            String name2;
            String name1 = graph1Nodes.get(i).getName();
            if (name1.equals(name2 = graph2Nodes.get(i).getName())) continue;
            throw new IllegalArgumentException("Graph names don't correspond.");
        }
        List<Edge> edges1 = graph1.getEdges();
        for (Edge edge : edges1) {
            Node node2;
            Node node1 = graph2.getNode(edge.getNode1().getName());
            if (graph2.isAdjacentTo(node1, node2 = graph2.getNode(edge.getNode2().getName()))) continue;
            ++count;
        }
        return count;
    }

    public static int countArrowptErrors(Graph graph1, Graph graph2) {
        if (graph1 == null) {
            throw new NullPointerException("The reference graph is missing.");
        }
        if (graph2 == null) {
            throw new NullPointerException("The target graph is missing.");
        }
        int count = 0;
        List<Node> graph1Nodes = graph1.getNodes();
        List<Node> graph2Nodes = graph2.getNodes();
        Comparator<Node> comparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return name1.compareTo(name2);
            }
        };
        Collections.sort(graph1Nodes, comparator);
        Collections.sort(graph2Nodes, comparator);
        if (graph1Nodes.size() != graph2Nodes.size()) {
            throw new IllegalArgumentException("The graph sizes are different.");
        }
        for (int i = 0; i < graph1Nodes.size(); ++i) {
            String name2;
            String name1 = graph1Nodes.get(i).getName();
            if (name1.equals(name2 = graph2Nodes.get(i).getName())) continue;
            throw new IllegalArgumentException("Graph names don't correspond.");
        }
        List<Edge> edges1 = graph1.getEdges();
        for (Edge edge1 : edges1) {
            Node node22;
            Node node11 = edge1.getNode1();
            Node node12 = edge1.getNode2();
            Node node21 = graph2.getNode(node11.getName());
            Edge edge2 = graph2.getEdge(node21, node22 = graph2.getNode(node12.getName()));
            if (edge2 == null) {
                if (edge1.getEndpoint1() == Endpoint.ARROW) {
                    ++count;
                }
                if (edge1.getEndpoint2() != Endpoint.ARROW) continue;
                ++count;
                continue;
            }
            if (edge1.getEndpoint1() == Endpoint.ARROW && edge2.getProximalEndpoint(node21) != Endpoint.ARROW) {
                ++count;
            }
            if (edge1.getEndpoint2() != Endpoint.ARROW || edge2.getProximalEndpoint(node22) == Endpoint.ARROW) continue;
            ++count;
        }
        return count;
    }

    public static int getNumArrowpts(Graph graph) {
        List<Edge> edges = graph.getEdges();
        int numArrowpts = 0;
        for (Edge edge : edges) {
            if (edge.getEndpoint1() == Endpoint.ARROW) {
                ++numArrowpts;
            }
            if (edge.getEndpoint2() != Endpoint.ARROW) continue;
            ++numArrowpts;
        }
        return numArrowpts;
    }

    public static List<Node> replaceNodes(List<Node> originalNodes, Graph graph) {
        LinkedList<Node> convertedNodes = new LinkedList<Node>();
        for (Node node : originalNodes) {
            convertedNodes.add(graph.getNode(node.getName()));
        }
        return convertedNodes;
    }

    public static GraphComparison getGraphComparison(Graph graph, Graph trueGraph) {
        int adjFn = GraphUtils.countAdjErrors(trueGraph, graph);
        int adjFp = GraphUtils.countAdjErrors(graph, trueGraph);
        int adjCorrect = graph.getNumEdges() - adjFp;
        int arrowptFn = GraphUtils.countArrowptErrors(trueGraph, graph);
        int arrowptFp = GraphUtils.countArrowptErrors(graph, trueGraph);
        int arrowptCorrect = GraphUtils.getNumArrowpts(graph) - arrowptFp;
        ArrayList<Edge> edgesAdded = new ArrayList<Edge>();
        ArrayList<Edge> edgesRemoved = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedFrom = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedTo = new ArrayList<Edge>();
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            for (int j = i + 1; j < graph.getNodes().size(); ++j) {
                Node node1 = graph.getNodes().get(i);
                Node node2 = graph.getNodes().get(j);
                Node node1t = trueGraph.getNode(node1.getName());
                Node node2t = trueGraph.getNode(node2.getName());
                Edge edget = graph.getEdge(node1, node2);
                Edge edger = trueGraph.getEdge(node1t, node2t);
                if (edger == null && edget == null) continue;
                if (edger == null) {
                    edgesAdded.add(edget);
                    continue;
                }
                if (edget == null) {
                    edgesRemoved.add(edger);
                    continue;
                }
                if (edger.equals(edget)) continue;
                edgesReorientedFrom.add(edger);
                edgesReorientedTo.add(edget);
            }
        }
        return new GraphComparison(adjFn, adjFp, adjCorrect, arrowptFn, arrowptFp, arrowptCorrect, edgesAdded, edgesRemoved, edgesReorientedFrom, edgesReorientedTo);
    }

    public static void sortEdges(List<Edge> edges) {
        Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                String name11 = o1.getNode1().getName();
                String name12 = o1.getNode2().getName();
                String name21 = o2.getNode1().getName();
                String name22 = o2.getNode2().getName();
                int major = name11.compareTo(name21);
                int minor = name12.compareTo(name22);
                if (major == 0) {
                    return minor;
                }
                return major;
            }
        });
    }

    public static Graph emptyGraph(int numNodes) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + i));
        }
        return new EdgeListGraph(nodes);
    }

    public static void graphToDot(Graph graph, File file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("digraph g {\n");
            for (Edge edge : graph.getEdges()) {
                writer.write(" \"" + edge.getNode1() + "\" -> \"" + edge.getNode2() + "\" [arrowtail=");
                if (edge.getEndpoint1() == Endpoint.ARROW) {
                    writer.write("normal");
                } else if (edge.getEndpoint1() == Endpoint.TAIL) {
                    writer.write("none");
                } else if (edge.getEndpoint1() == Endpoint.CIRCLE) {
                    writer.write("odot");
                }
                writer.write(", arrowhead=");
                if (edge.getEndpoint2() == Endpoint.ARROW) {
                    writer.write("normal");
                } else if (edge.getEndpoint2() == Endpoint.TAIL) {
                    writer.write("none");
                } else if (edge.getEndpoint2() == Endpoint.CIRCLE) {
                    writer.write("odot");
                }
                writer.write("]; \n");
            }
            writer.write("}");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Element convertToXml(Graph graph) {
        Set<Triple> dottedTriples;
        Set<Triple> underlineTriples;
        Element element = new Element("graph");
        Element variables = new Element("variables");
        element.appendChild(variables);
        for (Node node : graph.getNodes()) {
            Element variable = new Element("variable");
            Text text = new Text(node.getName());
            variable.appendChild(text);
            variables.appendChild(variable);
        }
        Element edges = new Element("edges");
        element.appendChild(edges);
        for (Edge edge : graph.getEdges()) {
            Element _edge = new Element("edge");
            Text text = new Text(edge.toString());
            _edge.appendChild(text);
            edges.appendChild(_edge);
        }
        Set<Triple> ambiguousTriples = graph.getAmbiguousTriples();
        if (!ambiguousTriples.isEmpty()) {
            Element underlinings = new Element("ambiguities");
            element.appendChild(underlinings);
            for (Triple triple : ambiguousTriples) {
                Element underlining = new Element("ambiguities");
                Text text = new Text(GraphUtils.niceTripleString(triple));
                underlining.appendChild(text);
                underlinings.appendChild(underlining);
            }
        }
        if (!(underlineTriples = graph.getUnderLines()).isEmpty()) {
            Element underlinings = new Element("underlines");
            element.appendChild(underlinings);
            for (Triple triple : underlineTriples) {
                Element underlining = new Element("underline");
                Text text = new Text(GraphUtils.niceTripleString(triple));
                underlining.appendChild(text);
                underlinings.appendChild(underlining);
            }
        }
        if (!(dottedTriples = graph.getDottedUnderlines()).isEmpty()) {
            Element dottedUnderlinings = new Element("dottedUnderlines");
            element.appendChild(dottedUnderlinings);
            for (Triple triple : dottedTriples) {
                Element dottedUnderlining = new Element("dottedUnderline");
                Text text = new Text(GraphUtils.niceTripleString(triple));
                dottedUnderlining.appendChild(text);
                dottedUnderlinings.appendChild(dottedUnderlining);
            }
        }
        return element;
    }

    private static String niceTripleString(Triple triple) {
        return triple.getX() + ", " + triple.getY() + ", " + triple.getZ();
    }

    public static String graphToXml(Graph graph) {
        Document document = new Document(GraphUtils.convertToXml(graph));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializer serializer = new Serializer(out);
        serializer.setLineSeparator("\n");
        serializer.setIndent(2);
        try {
            serializer.write(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)out).toString();
    }

    public static Graph parseGraphXml(Element graphElement, Map<String, Node> nodes) throws ParsingException {
        Set<Triple> triples;
        Element ambiguitiesElement;
        if (!"graph".equals(graphElement.getLocalName())) {
            throw new IllegalArgumentException("Expecting graph element: " + graphElement.getLocalName());
        }
        Attribute noteAttribute = graphElement.getAttribute("note");
        if (!"variables".equals(graphElement.getChildElements().get(0).getLocalName())) {
            throw new ParsingException("Expecting variables element: " + graphElement.getChildElements().get(0).getLocalName());
        }
        Element variablesElement = graphElement.getChildElements().get(0);
        Elements variableElements = variablesElement.getChildElements();
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i = 0; i < variableElements.size(); ++i) {
            Element variableElement = variableElements.get(i);
            if (!"variable".equals(variablesElement.getChildElements().get(i).getLocalName())) {
                throw new ParsingException("Expecting variable element.");
            }
            String value = variableElement.getValue();
            if (nodes == null) {
                variables.add(new GraphNode(value));
                continue;
            }
            variables.add(nodes.get(value));
        }
        EdgeListGraph graph = new EdgeListGraph(variables);
        if (!"edges".equals(graphElement.getChildElements().get(1).getLocalName())) {
            throw new ParsingException("Expecting edges element.");
        }
        Element edgesElement = graphElement.getChildElements().get(1);
        Elements edgesElements = edgesElement.getChildElements();
        for (int i = 0; i < edgesElements.size(); ++i) {
            Endpoint endpoint2;
            Endpoint endpoint1;
            Element edgeElement = edgesElements.get(i);
            if (!"edge".equals(edgeElement.getLocalName())) {
                throw new ParsingException("Expecting edge element: " + edgeElement.getLocalName());
            }
            String value = edgeElement.getValue();
            String regex = "([A-Za-z0-9_-]*) ?(.)-(.) ?([A-Za-z0-9_-]*)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) {
                throw new ParsingException("Edge doesn't match pattern.");
            }
            String var1 = matcher.group(1);
            String leftEndpoint = matcher.group(2);
            String rightEndpoint = matcher.group(3);
            String var2 = matcher.group(4);
            Node node1 = graph.getNode(var1);
            Node node2 = graph.getNode(var2);
            if (leftEndpoint.equals("<")) {
                endpoint1 = Endpoint.ARROW;
            } else if (leftEndpoint.equals("o")) {
                endpoint1 = Endpoint.CIRCLE;
            } else if (leftEndpoint.equals("-")) {
                endpoint1 = Endpoint.TAIL;
            } else {
                throw new IllegalStateException("Expecting an endpoint: " + leftEndpoint);
            }
            if (rightEndpoint.equals(">")) {
                endpoint2 = Endpoint.ARROW;
            } else if (rightEndpoint.equals("o")) {
                endpoint2 = Endpoint.CIRCLE;
            } else if (rightEndpoint.equals("-")) {
                endpoint2 = Endpoint.TAIL;
            } else {
                throw new IllegalStateException("Expecting an endpoint: " + rightEndpoint);
            }
            Edge edge = new Edge(node1, node2, endpoint1, endpoint2);
            graph.addEdge(edge);
        }
        int size = graphElement.getChildCount();
        int p = 2;
        if ("ambiguities".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphUtils.parseTriples(variables, ambiguitiesElement, "ambiguity");
            graph.setAmbiguousTriples(triples);
            ++p;
        }
        if (p >= size) {
            return graph;
        }
        if ("underlines".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphUtils.parseTriples(variables, ambiguitiesElement, "underline");
            graph.setUnderLineTriples(triples);
            ++p;
        }
        if (p >= size) {
            return graph;
        }
        if ("dottedunderlines".equals(graphElement.getChildElements().get(p).getLocalName())) {
            ambiguitiesElement = graphElement.getChildElements().get(p);
            triples = GraphUtils.parseTriples(variables, ambiguitiesElement, "dottedunderline");
            graph.setDottedUnderLineTriples(triples);
        }
        return graph;
    }

    private static Set<Triple> parseTriples(List<Node> variables, Element triplesElement, String s) {
        Elements elements = triplesElement.getChildElements(s);
        HashSet<Triple> triples = new HashSet<Triple>();
        for (int q = 0; q < elements.size(); ++q) {
            Element tripleElement = elements.get(q);
            String value = tripleElement.getValue();
            String[] tokens = value.split(",");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("Expecting a triple: " + value);
            }
            String x = tokens[0].trim();
            String y = tokens[1].trim();
            String z = tokens[2].trim();
            Node _x = GraphUtils.getNode(variables, x);
            Node _y = GraphUtils.getNode(variables, y);
            Node _z = GraphUtils.getNode(variables, z);
            Triple triple = new Triple(_x, _y, _z);
            triples.add(triple);
        }
        return triples;
    }

    private static Node getNode(List<Node> nodes, String x) {
        for (Node node : nodes) {
            if (!x.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public static Element getRootElement(File file) throws ParsingException, IOException {
        Builder builder = new Builder();
        Document document = builder.build(file);
        return document.getRootElement();
    }

    public static PrintWriter saveGraph(Graph graph, File file, boolean xml) {
        PrintWriter out;
        try {
            out = new PrintWriter(new FileOutputStream(file));
            if (xml) {
                out.print(GraphUtils.graphToXml(graph));
            } else {
                out.println(graph);
            }
            out.close();
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Output file could not be opened: " + file);
        }
        return out;
    }

    public static Graph loadGraph(File file) {
        if (!file.getName().endsWith(".xml")) {
            throw new IllegalArgumentException("Not an XML file.");
        }
        Graph graph = null;
        try {
            Element root = GraphUtils.getRootElement(file);
            graph = GraphUtils.parseGraphXml(root, null);
        }
        catch (ParsingException e1) {
            throw new IllegalArgumentException("Could not parse " + file, e1);
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Could not read " + file, e1);
        }
        if (graph == null) {
            throw new IllegalArgumentException("Expecting a graph in " + file);
        }
        return graph;
    }

    public static HashMap<String, PointXy> grabLayout(List<Node> nodes) {
        HashMap<String, PointXy> layout = new HashMap<String, PointXy>();
        for (Node node : nodes) {
            layout.put(node.getName(), new PointXy(node.getCenterX(), node.getCenterY()));
        }
        return layout;
    }

    public static List<Triple> getCollidersFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> colliders = new ArrayList<Triple>();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node x = adj.get(choice[0]);
            Node z = adj.get(choice[1]);
            Endpoint endpt1 = graph.getEdge(x, node).getProximalEndpoint(node);
            Endpoint endpt2 = graph.getEdge(z, node).getProximalEndpoint(node);
            if (endpt1 != Endpoint.ARROW || endpt2 != Endpoint.ARROW) continue;
            colliders.add(new Triple(x, node, z));
        }
        return colliders;
    }

    public static List<Triple> getDefiniteCollidersFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> defColliders = new ArrayList<Triple>();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = adj.get(choice[0]);
            if (!graph.isDefCollider(x, node, z = adj.get(choice[1]))) continue;
            defColliders.add(new Triple(x, node, z));
        }
        return defColliders;
    }

    public static List<Triple> getNoncollidersFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> noncolliders = new ArrayList<Triple>();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node x = adj.get(choice[0]);
            Node z = adj.get(choice[1]);
            Endpoint endpt1 = graph.getEdge(x, node).getProximalEndpoint(node);
            Endpoint endpt2 = graph.getEdge(z, node).getProximalEndpoint(node);
            if (!(endpt1 == Endpoint.ARROW && endpt2 == Endpoint.TAIL || endpt1 == Endpoint.TAIL && endpt2 == Endpoint.ARROW) && (endpt1 != Endpoint.TAIL || endpt2 != Endpoint.TAIL)) continue;
            noncolliders.add(new Triple(x, node, z));
        }
        return noncolliders;
    }

    public static List<Triple> getDefiniteNoncollidersFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> defNoncolliders = new ArrayList<Triple>();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = adj.get(choice[0]);
            if (!graph.isDefNoncollider(x, node, z = adj.get(choice[1]))) continue;
            defNoncolliders.add(new Triple(x, node, z));
        }
        return defNoncolliders;
    }

    public static List<Triple> getAmbiguousTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> ambiguousTriples = new ArrayList<Triple>();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = adj.get(choice[0]);
            if (!graph.isAmbiguousTriple(x, node, z = adj.get(choice[1]))) continue;
            ambiguousTriples.add(new Triple(x, node, z));
        }
        return ambiguousTriples;
    }

    public static List<Triple> getUnderlinedTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> underlinedTriples = new ArrayList<Triple>();
        Set<Triple> allUnderlinedTriples = graph.getUnderLines();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = adj.get(choice[0]);
            if (!allUnderlinedTriples.contains(new Triple(x, node, z = adj.get(choice[1])))) continue;
            underlinedTriples.add(new Triple(x, node, z));
        }
        return underlinedTriples;
    }

    public static List<Triple> getDottedUnderlinedTriplesFromGraph(Node node, Graph graph) {
        int[] choice;
        ArrayList<Triple> dottedUnderlinedTriples = new ArrayList<Triple>();
        Set<Triple> allDottedUnderlinedTriples = graph.getDottedUnderlines();
        List<Node> adj = graph.getAdjacentNodes(node);
        if (adj.size() < 2) {
            return new LinkedList<Triple>();
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        while ((choice = gen.next()) != null) {
            Node z;
            Node x = adj.get(choice[0]);
            if (!allDottedUnderlinedTriples.contains(new Triple(x, node, z = adj.get(choice[1])))) continue;
            dottedUnderlinedTriples.add(new Triple(x, node, z));
        }
        return dottedUnderlinedTriples;
    }

    public static class GraphComparison {
        private int adjFn;
        private int adjFp;
        private int adjCorrect;
        private int arrowptFn;
        private int arrowptFp;
        private int arrowptCorrect;
        private List<Edge> edgesAdded;
        private List<Edge> edgesRemoved;
        private List<Edge> edgesReorientedFrom;
        private List<Edge> edgesReorientedTo;

        public GraphComparison(int adjFn, int adjFp, int adjCorrect, int arrowptFn, int arrowptFp, int arrowptCorrect, List<Edge> edgesAdded, List<Edge> edgesRemoved, List<Edge> edgesReorientedFrom, List<Edge> edgesReorientedTo) {
            this.adjFn = adjFn;
            this.adjFp = adjFp;
            this.adjCorrect = adjCorrect;
            this.arrowptFn = arrowptFn;
            this.arrowptFp = arrowptFp;
            this.arrowptCorrect = arrowptCorrect;
            this.edgesAdded = edgesAdded;
            this.edgesRemoved = edgesRemoved;
            this.edgesReorientedFrom = edgesReorientedFrom;
            this.edgesReorientedTo = edgesReorientedTo;
        }

        public int getAdjFn() {
            return this.adjFn;
        }

        public int getAdjFp() {
            return this.adjFp;
        }

        public int getAdjCorrect() {
            return this.adjCorrect;
        }

        public int getArrowptFn() {
            return this.arrowptFn;
        }

        public int getArrowptFp() {
            return this.arrowptFp;
        }

        public int getArrowptCorrect() {
            return this.arrowptCorrect;
        }

        public List<Edge> getEdgesAdded() {
            return this.edgesAdded;
        }

        public List<Edge> getEdgesRemoved() {
            return this.edgesRemoved;
        }

        public List<Edge> getEdgesReorientedFrom() {
            return this.edgesReorientedFrom;
        }

        public List<Edge> getEdgesReorientedTo() {
            return this.edgesReorientedTo;
        }
    }
}

