/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ProgressMonitor;

public final class KamadaKawaiLayout {
    private Graph graph;
    private List<Node> componentNodes;
    private double naturalEdgeLength = 80.0;
    private double springConstant = 0.5;
    private double[][] p;
    private double[][] l;
    private double[][] k;
    private double leftmostX = -50.0;
    private ProgressMonitor monitor;
    private boolean randomlyInitialized;
    private double stopEnergy = 1.0;

    public KamadaKawaiLayout(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    public void doLayout() {
        this.monitor = new ProgressMonitor(null, "Energy settling...", "Energy = ?", 0, 100);
        this.getMonitor().setMillisToDecideToPopup(10);
        this.getMonitor().setMillisToPopup(0);
        this.getMonitor().setProgress(0);
        List<List<Node>> components = GraphUtils.connectedComponents(this.graph);
        Collections.sort(components, new Comparator<List<Node>>(){

            @Override
            public int compare(List<Node> o1, List<Node> o2) {
                int i1 = o1.size();
                int i2 = o2.size();
                return i2 < i1 ? -1 : (i2 == i1 ? 0 : 1);
            }
        });
        for (List<Node> component1 : components) {
            this.initialize(component1, this.isRandomlyInitialized());
            this.layoutComponent(component1);
        }
        this.getMonitor().setProgress(100);
    }

    public boolean isRandomlyInitialized() {
        return this.randomlyInitialized;
    }

    public void setRandomlyInitialized(boolean randomlyInitialized) {
        this.randomlyInitialized = randomlyInitialized;
    }

    public double getStopEnergy() {
        return this.stopEnergy;
    }

    public void setStopEnergy(double stopEnergy) {
        if (stopEnergy <= 0.0) {
            throw new IllegalArgumentException("Stop energy must be greater than zero.");
        }
        this.stopEnergy = stopEnergy;
    }

    public double getNaturalEdgeLength() {
        return this.naturalEdgeLength;
    }

    public void setNaturalEdgeLength(double naturalEdgeLength) {
        if (naturalEdgeLength < 0.0) {
            throw new IllegalArgumentException("Natural edge length should be greater than zero.");
        }
        this.naturalEdgeLength = naturalEdgeLength;
    }

    public double getSpringConstant() {
        return this.springConstant;
    }

    public void setSpringConstant(double springConstant) {
        if (springConstant < 0.0) {
            throw new IllegalArgumentException("Spring constant should be greater than zero.");
        }
        this.springConstant = springConstant;
    }

    private void initialize(List<Node> nodes, boolean randomlyInitialized) {
        int i;
        this.setComponentNodes(Collections.unmodifiableList(nodes));
        this.p = new double[nodes.size()][2];
        this.l = new double[nodes.size()][nodes.size()];
        this.k = new double[nodes.size()][nodes.size()];
        if (randomlyInitialized) {
            for (i = 0; i < nodes.size(); ++i) {
                this.p[i][0] = RandomUtil.getInstance().nextInt(600);
                this.p[i][1] = RandomUtil.getInstance().nextInt(600);
            }
        } else {
            for (i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                this.p[i][0] = node.getCenterX();
                this.p[i][1] = node.getCenterY();
            }
        }
        int[][] d = this.allPairsShortestPath();
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                this.l[i][j] = this.getNaturalEdgeLength() * (double)d[i][j];
            }
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                this.k[i][j] = this.getSpringConstant() / (double)(d[i][j] * d[i][j]);
            }
        }
    }

    private void layoutComponent(List<Node> componentNodes) {
        this.setComponentNodes(componentNodes);
        this.optimize(this.getStopEnergy());
        this.shiftComponentToRight(componentNodes);
    }

    private void shiftComponentToRight(List<Node> componentNodes) {
        int i;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        for (i = 0; i < componentNodes.size(); ++i) {
            if (this.p[i][0] < minX) {
                minX = this.p[i][0];
            }
            if (!(this.p[i][1] < minY)) continue;
            minY = this.p[i][1];
        }
        this.leftmostX += 100.0;
        for (i = 0; i < componentNodes.size(); ++i) {
            double[] dArray = this.p[i];
            dArray[0] = dArray[0] + (this.leftmostX - minX);
            double[] dArray2 = this.p[i];
            dArray2[1] = dArray2[1] + (40.0 - minY);
        }
        for (i = 0; i < componentNodes.size(); ++i) {
            if (!(this.p[i][0] > this.leftmostX)) continue;
            this.leftmostX = this.p[i][0];
        }
        for (i = 0; i < componentNodes.size(); ++i) {
            Node node = componentNodes.get(i);
            node.setCenterX((int)this.p[i][0]);
            node.setCenterY((int)this.p[i][1]);
        }
    }

    private void optimize(double deltaCutoff) {
        double maxDelta;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        double initialMaxDelta = -1.0;
        int jump = 100;
        DenseDoubleMatrix2D a = new DenseDoubleMatrix2D(2, 2);
        DenseDoubleMatrix2D b = new DenseDoubleMatrix2D(2, 1);
        int oldM = -1;
        block2: do {
            if (this.monitor.isCanceled()) {
                return;
            }
            int[] m = new int[1];
            maxDelta = this.maxDelta(m);
            if (initialMaxDelta == -1.0) {
                initialMaxDelta = maxDelta;
            }
            if (m[0] == oldM) {
                double[] dArray = this.p[m[0]];
                dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                double[] dArray2 = this.p[m[0]];
                dArray2[1] = dArray2[1] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                continue;
            }
            oldM = m[0];
            int progress = (int)(99.0 - 98.0 * maxDelta / (0.5 * initialMaxDelta));
            if (progress < 1) {
                progress = 1;
            }
            if (progress > 99) {
                progress = 99;
            }
            this.getMonitor().setProgress(progress);
            this.getMonitor().setNote("Energy = " + nf.format(maxDelta));
            if (m[0] == -1) {
                throw new IllegalStateException();
            }
            double oldDelta = Double.NaN;
            while (true) {
                DoubleMatrix2D c;
                double d;
                double delta = this.delta(m[0]);
                if (!(d > deltaCutoff)) continue block2;
                Thread.yield();
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (Math.abs(delta - oldDelta) < 0.001) {
                    double[] dArray = this.p[m[0]];
                    dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                    double[] dArray3 = this.p[m[0]];
                    dArray3[1] = dArray3[1] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                    continue;
                }
                double h = 0.01;
                double partialXX = this.secondPartial(m[0], 0, 0, h);
                double partialXY = this.secondPartial(m[0], 0, 1, h);
                double partialX = this.firstPartial(m[0], 0, h);
                double partialYY = this.secondPartial(m[0], 1, 1, h);
                double partialY = this.firstPartial(m[0], 1, h);
                a.set(0, 0, partialXX);
                a.set(0, 1, partialXY);
                a.set(1, 0, partialXY);
                a.set(1, 1, partialYY);
                b.set(0, 0, -partialX);
                b.set(1, 0, -partialY);
                try {
                    c = new Algebra().solve(a, b);
                }
                catch (Exception e) {
                    double[] dArray = this.p[m[0]];
                    dArray[0] = dArray[0] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                    double[] dArray4 = this.p[m[0]];
                    dArray4[1] = dArray4[1] + (double)(RandomUtil.getInstance().nextInt(2 * jump) - jump);
                    continue;
                }
                double dx = c.get(0, 0);
                double dy = c.get(1, 0);
                double[] dArray = this.p[m[0]];
                dArray[0] = dArray[0] + dx;
                double[] dArray5 = this.p[m[0]];
                dArray5[1] = dArray5[1] + dy;
                oldDelta = delta;
            }
        } while (maxDelta > deltaCutoff);
    }

    private double energy() {
        int n = this.p.length;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                sum += 0.5 * this.k[i][j] * Math.pow(this.distance(i, j) - this.l[i][j], 2.0);
            }
        }
        return sum;
    }

    private double maxDelta(int[] index) {
        double maxDelta = Double.NEGATIVE_INFINITY;
        int m = -1;
        for (int i = 0; i < this.getComponentNodes().size(); ++i) {
            double delta = this.delta(i);
            if (delta == Double.NEGATIVE_INFINITY) {
                throw new IllegalStateException();
            }
            if (!(delta > maxDelta)) continue;
            maxDelta = delta;
            m = i;
        }
        index[0] = m;
        return maxDelta;
    }

    private double delta(int i) {
        double partialX = this.firstPartial(i, 0, 1.0E-4);
        double partialY = this.firstPartial(i, 1, 1.0E-4);
        return Math.sqrt(partialX * partialX + partialY * partialY);
    }

    private double firstPartial(int i, int var, double h) {
        double storedCoord = this.p[i][var];
        double[] dArray = this.p[i];
        int n = var;
        dArray[n] = dArray[n] - h;
        double energy1 = this.energy();
        double[] dArray2 = this.p[i];
        int n2 = var;
        dArray2[n2] = dArray2[n2] + h;
        double energy2 = this.energy();
        this.p[i][var] = storedCoord;
        return (energy2 - energy1) / (2.0 * h);
    }

    private double secondPartial(int m, int i, int j, double h) {
        double storedX = this.p[m][0];
        double storedY = this.p[m][1];
        double[] dArray = this.p[m];
        int n = i;
        dArray[n] = dArray[n] + h;
        double[] dArray2 = this.p[m];
        int n2 = j;
        dArray2[n2] = dArray2[n2] + h;
        double ff1 = this.energy();
        double[] dArray3 = this.p[m];
        int n3 = j;
        dArray3[n3] = dArray3[n3] - 2.0 * h;
        double ff2 = this.energy();
        double[] dArray4 = this.p[m];
        int n4 = i;
        dArray4[n4] = dArray4[n4] - 2.0 * h;
        double[] dArray5 = this.p[m];
        int n5 = j;
        dArray5[n5] = dArray5[n5] + 2.0 * h;
        double ff3 = this.energy();
        double[] dArray6 = this.p[m];
        int n6 = j;
        dArray6[n6] = dArray6[n6] - 2.0 * h;
        double ff4 = this.energy();
        this.p[m][0] = storedX;
        this.p[m][1] = storedY;
        return (ff1 - ff2 - ff3 + ff4) / (4.0 * h * h);
    }

    private double distance(int i, int j) {
        double x1 = this.p[i][0];
        double y1 = this.p[i][1];
        double x2 = this.p[j][0];
        double y2 = this.p[j][1];
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private int[][] allPairsShortestPath() {
        int[][] I1 = new int[this.getComponentNodes().size()][this.getComponentNodes().size()];
        int[][] I2 = new int[this.getComponentNodes().size()][this.getComponentNodes().size()];
        int infinity = this.getComponentNodes().size() * this.getComponentNodes().size();
        for (int i = 0; i < this.getComponentNodes().size(); ++i) {
            for (int j = 0; j < this.getComponentNodes().size(); ++j) {
                Node node2;
                Node node1 = this.getComponentNodes().get(i);
                I2[i][j] = this.graph.getEdge(node1, node2 = this.getComponentNodes().get(j)) != null ? 1 : infinity;
            }
        }
        for (int k = 0; k < this.getComponentNodes().size(); ++k) {
            int[][] temp = I1;
            I1 = I2;
            I2 = temp;
            for (int i = 0; i < this.getComponentNodes().size(); ++i) {
                for (int j = 0; j < this.getComponentNodes().size(); ++j) {
                    I2[i][j] = Math.min(I1[i][j], I1[i][k] + I1[k][j]);
                }
            }
        }
        return I2;
    }

    private ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public List<Node> getComponentNodes() {
        return this.componentNodes;
    }

    public void setComponentNodes(List<Node> componentNodes) {
        this.componentNodes = componentNodes;
    }
}

