/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;

public final class NoEdgeIntoUndirectedEndpoint
implements GraphConstraint {
    static final long serialVersionUID = 23L;

    public static NoEdgeIntoUndirectedEndpoint serializableInstance() {
        return new NoEdgeIntoUndirectedEndpoint();
    }

    @Override
    public boolean isEdgeAddable(Edge edge, Graph graph) {
        if (edge.getEndpoint1() == Endpoint.ARROW) {
            if (this.existsAttachedUndirectedEdge(edge.getNode1(), graph)) {
                return false;
            }
        } else if (edge.getEndpoint2() == Endpoint.ARROW) {
            if (this.existsAttachedUndirectedEdge(edge.getNode2(), graph)) {
                return false;
            }
        } else if (Edges.isNondirectedEdge(edge) || Edges.isUndirectedEdge(edge)) {
            if (this.existsAttachedIntoEdge(edge.getNode1(), graph)) {
                return false;
            }
            if (this.existsAttachedIntoEdge(edge.getNode2(), graph)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNodeAddable(Node node, Graph graph) {
        return true;
    }

    @Override
    public boolean isEdgeRemovable(Edge edge, Graph graph) {
        return true;
    }

    @Override
    public boolean isNodeRemovable(Node node, Graph graph) {
        return true;
    }

    private boolean existsAttachedUndirectedEdge(Node node, Graph graph) {
        for (Edge edge1 : graph.getEdges(node)) {
            if (!Edges.isNondirectedEdge(edge1) && !Edges.isUndirectedEdge(edge1)) continue;
            return true;
        }
        return false;
    }

    private boolean existsAttachedIntoEdge(Node node, Graph graph) {
        for (Edge edge1 : graph.getEdges(node)) {
            Endpoint ept = edge1.getProximalEndpoint(node);
            if (ept != Endpoint.ARROW) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "<Undirected edges block into edges.>";
    }
}

