/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestCollisions
extends TestCase {
    public TestCollisions(String name) {
        super(name);
    }

    public void testMatrixGraph() {
        this.checkGraph(new EdgeListGraph());
    }

    public void testListGraph() {
        this.checkGraph(new EdgeListGraph());
    }

    private void checkGraph(Graph graph) {
        GraphNode x1 = new GraphNode("x1");
        GraphNode x2 = new GraphNode("x2");
        GraphNode x3 = new GraphNode("x3");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x3, x2);
        TestCollisions.assertTrue(graph.isDefCollider(x1, x2, x3));
        graph.clear();
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addDirectedEdge(x2, x1);
        graph.addUndirectedEdge(x2, x3);
        TestCollisions.assertTrue(graph.isDefNoncollider(x1, x2, x3));
        graph.clear();
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addUndirectedEdge(x1, x3);
        graph.addDirectedEdge(x1, x2);
        graph.addUndirectedEdge(x3, x2);
        TestCollisions.assertFalse(graph.isDefNoncollider(x1, x2, x3));
        TestCollisions.assertFalse(graph.isDefCollider(x1, x2, x3));
    }

    public static Test suite() {
        return new TestSuite(TestCollisions.class);
    }
}

