/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestDag
extends TestCase {
    public TestDag(String name) {
        super(name);
    }

    public void testSearchGraph() {
        this.checkGraph(new Dag());
    }

    public void testDag() {
        this.checkGraph(new Dag());
    }

    private void checkGraph(Dag graph) {
        this.checkAddRemoveNodes(graph);
        this.checkCopy(graph);
    }

    private void checkAddRemoveNodes(Dag graph) {
        GraphNode x1 = new GraphNode("x1");
        GraphNode x2 = new GraphNode("x2");
        GraphNode x3 = new GraphNode("x3");
        GraphNode x4 = new GraphNode("x4");
        GraphNode x5 = new GraphNode("x5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x5, x4);
        System.out.println(graph);
        List<Node> children = graph.getChildren(x1);
        List<Node> parents = graph.getParents(x4);
        System.out.println("Children of x1 = " + children);
        System.out.println("Parents of x4 = " + parents);
        TestDag.assertTrue(graph.isDConnectedTo(x1, x3, Collections.EMPTY_LIST));
        TestDag.assertTrue(graph.existsDirectedPathFromTo(x1, x4));
        TestDag.assertTrue(!graph.existsDirectedPathFromTo(x1, x5));
        TestDag.assertTrue(graph.isAncestorOf(x2, x4));
        TestDag.assertTrue(!graph.isAncestorOf(x4, x2));
        TestDag.assertTrue(graph.isDescendentOf(x4, x2));
        TestDag.assertTrue(!graph.isDescendentOf(x2, x4));
    }

    private void checkCopy(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph);
        TestDag.assertEquals(graph, graph2);
    }

    public static Test suite() {
        return new TestSuite(TestDag.class);
    }
}

