/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public final class UniformGraphGenerator {
    public static final int ANY_DAG = 0;
    public static final int CONNECTED_DAG = 1;
    private int structure;
    private int numNodes;
    private int maxInDegree;
    private int maxOutDegree;
    private int maxDegree;
    private int maxEdges;
    private int numIterations;
    private int[][] parentMatrix;
    private int[][] childMatrix;
    private int randomParent = 0;
    private int randomChild = 1;
    final RandomUtil randomUtil = RandomUtil.getInstance();

    public UniformGraphGenerator(int structure) {
        switch (structure) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized structure.");
            }
        }
        this.structure = structure;
        this.numNodes = 4;
        this.maxInDegree = 3;
        this.maxOutDegree = 3;
        this.maxDegree = 6;
        this.maxEdges = this.numNodes - 1;
        this.numIterations = 6 * this.numNodes * this.numNodes;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public void setNumNodes(int numNodes) {
        if (numNodes < 1) {
            throw new IllegalArgumentException("Number of nodes must be >= 1.");
        }
        this.numNodes = numNodes;
        this.maxDegree = numNodes - 1;
        this.maxInDegree = numNodes - 1;
        this.maxOutDegree = numNodes - 1;
        this.maxEdges = numNodes - 1;
        this.numIterations = 6 * numNodes * numNodes;
        if (this.numIterations > 300000000) {
            this.numIterations = 300000000;
        }
        this.parentMatrix = null;
        this.childMatrix = null;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < 3) {
            throw new IllegalArgumentException("Degree of nodes must be >= 3.");
        }
        this.maxDegree = maxDegree;
    }

    public int getMaxInDegree() {
        return this.maxInDegree;
    }

    public void setMaxInDegree(int maxInDegree) {
        if (0 == this.getStructure() && this.getMaxInDegree() < 0) {
            throw new IllegalArgumentException("Max indegree must be >= 1 when generating DAGs without the assumption of connectedness.");
        }
        if (1 == this.getStructure() && this.getMaxInDegree() < 2) {
            throw new IllegalArgumentException("Max indegree must be >= 2 when generating DAGs under the assumption of connectedness.");
        }
        this.maxInDegree = maxInDegree;
    }

    public int getMaxOutDegree() {
        return this.maxOutDegree;
    }

    public void setMaxOutDegree(int maxOutDegree) {
        if (0 == this.getStructure() && this.getMaxInDegree() < 1) {
            throw new IllegalArgumentException("Max indegree must be >= 1 when generating DAGs without the assumption of connectedness.");
        }
        if (1 == this.getStructure() && this.getMaxInDegree() < 2) {
            throw new IllegalArgumentException("Max indegree must be >= 2 when generating DAGs under the assumption of connectedness.");
        }
        this.maxOutDegree = maxOutDegree;
    }

    private int getMaxEdges() {
        return this.maxEdges;
    }

    public int getMaxPossibleEdges() {
        return this.getNumNodes() * this.getMaxDegree() / 2;
    }

    public void setMaxEdges(int maxEdges) {
        if (maxEdges < 0) {
            throw new IllegalArgumentException("Max edges must be >= 0.");
        }
        if (maxEdges > this.getMaxPossibleEdges()) {
            maxEdges = this.getMaxPossibleEdges();
        }
        this.maxEdges = maxEdges;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public int getStructure() {
        return this.structure;
    }

    public void generate() {
        if (0 == this.getStructure()) {
            this.generateArbitraryDag();
        } else if (1 == this.getStructure()) {
            this.generateConnectedDag();
        } else {
            throw new IllegalStateException("Unknown structure type.");
        }
    }

    public Dag getDag() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)Math.ceil(Math.log(this.numNodes) / Math.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        nf.setGroupingUsed(false);
        for (int i = 1; i <= this.getNumNodes(); ++i) {
            GraphNode node = new GraphNode("X" + nf.format(i));
            nodes.add(node);
        }
        return this.getDag(nodes);
    }

    public Dag getDag(List<Node> nodes) {
        if (nodes.size() != this.getNumNodes()) {
            throw new IllegalArgumentException("Only " + nodes.size() + " nodes were provided, but the " + "simulated graph has " + this.getNumNodes() + ".");
        }
        Dag dag = new Dag();
        for (Node node : nodes) {
            dag.addNode(node);
        }
        for (int i = 0; i < this.getNumNodes(); ++i) {
            Node child = nodes.get(i);
            if (this.parentMatrix[i][0] == 1) continue;
            for (int j = 1; j < this.parentMatrix[i][0]; ++j) {
                Node parent = nodes.get(this.parentMatrix[i][j]);
                dag.addDirectedEdge(parent, child);
            }
        }
        GraphUtils.arrangeInCircle(dag, 200, 200, 150);
        return dag;
    }

    public void printEdges() {
        System.out.println("Edges:");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            for (int j = 1; j < this.childMatrix[i][0]; ++j) {
                System.out.println("\t" + i + " --> " + this.childMatrix[i][j]);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nStructural information for generated graph:");
        buf.append("\n\tNumber of nodes:").append(this.getNumNodes());
        buf.append("\n\tMax degree for each node:").append(this.getMaxDegree());
        buf.append("\n\tMaximum number of incoming edges for each node:").append(this.getMaxInDegree());
        buf.append("\n\tMaximum number of outgoing edges for each node:").append(this.getMaxOutDegree());
        buf.append("\n\tMaximum total number of edges:").append(this.getMaxEdges()).append(" of ").append(this.getNumNodes() * this.getMaxDegree() / 2).append(" possibles");
        buf.append("\n\tNumber of transitions between samples:").append(this.getNumIterations());
        return buf.toString();
    }

    private void generateArbitraryDag() {
        this.initializeGraphAsEmpty();
        if (this.getNumNodes() <= 1) {
            return;
        }
        int numEdges = 0;
        for (int i = 0; i < this.getNumIterations(); ++i) {
            this.sampleEdge();
            if (this.edgeExists()) {
                this.removeEdge();
                --numEdges;
                continue;
            }
            if (numEdges >= this.getMaxEdges() || !this.maxDegreeNotExceeded() || !this.maxIndegreeNotExceeded() || !this.maxOutdegreeNotExceeded() || !this.isAcyclic()) continue;
            this.addEdge();
            ++numEdges;
        }
    }

    private void generateConnectedDag() {
        this.initializeGraphAsChain();
        if (this.getNumNodes() <= 1) {
            return;
        }
        int totalEdges = this.getNumNodes() - 1;
        while (this.isDisconnecting()) {
            this.sampleEdge();
            if (this.edgeExists() || !this.isAcyclic() || !this.maxDegreeNotExceeded()) continue;
            this.addEdge();
            ++totalEdges;
        }
        for (int i = 0; i < this.getNumIterations(); ++i) {
            this.sampleEdge();
            if (this.edgeExists()) {
                if (this.isDisconnecting()) {
                    this.removeEdge();
                    this.reverseDirection();
                    if (totalEdges < this.getMaxEdges() && this.maxDegreeNotExceeded() && this.maxIndegreeNotExceeded() && this.maxOutdegreeNotExceeded() && this.isAcyclic()) {
                        this.addEdge();
                        continue;
                    }
                    this.reverseDirection();
                    this.addEdge();
                    continue;
                }
                this.removeEdge();
                --totalEdges;
                continue;
            }
            if (totalEdges >= this.getMaxEdges() || !this.maxDegreeNotExceeded() || !this.maxIndegreeNotExceeded() || !this.maxOutdegreeNotExceeded() || !this.isAcyclic()) continue;
            this.addEdge();
            ++totalEdges;
        }
    }

    private void reverseDirection() {
        int temp = this.randomChild;
        this.randomChild = this.randomParent;
        this.randomParent = temp;
    }

    private boolean edgeExists() {
        for (int i = 1; i < this.parentMatrix[this.randomChild][0]; ++i) {
            if (this.parentMatrix[this.randomChild][i] != this.randomParent) continue;
            return true;
        }
        return false;
    }

    private boolean maxDegreeNotExceeded() {
        int parentDegree = this.parentMatrix[this.randomParent][0] + this.childMatrix[this.randomParent][0] - 1;
        int childDegree = this.parentMatrix[this.randomChild][0] + this.childMatrix[this.randomChild][0] - 1;
        return parentDegree <= this.getMaxDegree() && childDegree <= this.getMaxDegree();
    }

    private boolean maxIndegreeNotExceeded() {
        return this.parentMatrix[this.randomChild][0] <= this.getMaxInDegree();
    }

    private boolean maxOutdegreeNotExceeded() {
        return this.childMatrix[this.randomParent][0] <= this.getMaxOutDegree();
    }

    private boolean isDisconnecting() {
        boolean[] visited = new boolean[this.getNumNodes()];
        int[] list = new int[this.getNumNodes()];
        int lastIndex = 1;
        list[0] = 0;
        visited[0] = true;
        for (int index = 0; index < lastIndex; ++index) {
            int i;
            int currentNode = list[index];
            for (i = 1; i < this.parentMatrix[currentNode][0]; ++i) {
                if (currentNode == this.randomChild && this.parentMatrix[currentNode][i] == this.randomParent || visited[this.parentMatrix[currentNode][i]]) continue;
                list[lastIndex] = this.parentMatrix[currentNode][i];
                visited[this.parentMatrix[currentNode][i]] = true;
                ++lastIndex;
            }
            for (i = 1; i < this.childMatrix[currentNode][0]; ++i) {
                if (currentNode == this.randomParent && this.childMatrix[currentNode][i] == this.randomChild || visited[this.childMatrix[currentNode][i]]) continue;
                list[lastIndex] = this.childMatrix[currentNode][i];
                visited[this.childMatrix[currentNode][i]] = true;
                ++lastIndex;
            }
        }
        for (boolean aVisited : visited) {
            if (aVisited) continue;
            return true;
        }
        return false;
    }

    private boolean isAcyclic() {
        boolean[] visited = new boolean[this.getNumNodes()];
        boolean noCycle = true;
        int[] list = new int[this.getNumNodes() + 1];
        int lastIndex = 1;
        list[0] = this.randomParent;
        visited[this.randomParent] = true;
        for (int index = 0; index < lastIndex && noCycle; ++index) {
            int currentNode = list[index];
            for (int i = 1; i < this.parentMatrix[currentNode][0] && noCycle; ++i) {
                if (visited[this.parentMatrix[currentNode][i]]) continue;
                if (this.parentMatrix[currentNode][i] != this.randomChild) {
                    list[lastIndex] = this.parentMatrix[currentNode][i];
                    ++lastIndex;
                } else {
                    noCycle = false;
                }
                visited[this.parentMatrix[currentNode][i]] = true;
            }
        }
        return noCycle;
    }

    private void initializeGraphAsEmpty() {
        int i;
        int max = Math.max(this.getMaxInDegree() + this.getMaxOutDegree(), this.getMaxDegree());
        this.parentMatrix = new int[this.getNumNodes()][++max];
        this.childMatrix = new int[this.getNumNodes()][max];
        for (i = 0; i < this.getNumNodes(); ++i) {
            this.parentMatrix[i][0] = 1;
            this.childMatrix[i][0] = 1;
        }
        for (i = 0; i < this.getNumNodes(); ++i) {
            for (int j = 1; j < max; ++j) {
                this.parentMatrix[i][j] = -5;
                this.childMatrix[i][j] = -5;
            }
        }
    }

    private void initializeGraphAsChain() {
        int i;
        this.parentMatrix = new int[this.getNumNodes()][this.getMaxDegree() + 2];
        this.childMatrix = new int[this.getNumNodes()][this.getMaxDegree() + 2];
        for (i = 0; i < this.getNumNodes(); ++i) {
            for (int j = 1; j < this.getMaxDegree() + 1; ++j) {
                this.parentMatrix[i][j] = -5;
                this.childMatrix[i][j] = -5;
            }
        }
        this.parentMatrix[0][0] = 1;
        this.childMatrix[0][0] = 2;
        this.childMatrix[0][1] = 1;
        this.parentMatrix[this.getNumNodes() - 1][0] = 2;
        this.parentMatrix[this.getNumNodes() - 1][1] = this.getNumNodes() - 2;
        this.childMatrix[this.getNumNodes() - 1][0] = 1;
        for (i = 1; i < this.getNumNodes() - 1; ++i) {
            this.parentMatrix[i][0] = 2;
            this.parentMatrix[i][1] = i - 1;
            this.childMatrix[i][0] = 2;
            this.childMatrix[i][1] = i + 1;
        }
    }

    private void sampleEdge() {
        int rand = this.randomUtil.nextInt(this.getNumNodes() * (this.getNumNodes() - 1));
        this.randomParent = rand / (this.getNumNodes() - 1);
        int rest = rand - this.randomParent * (this.getNumNodes() - 1);
        this.randomChild = rest >= this.randomParent ? rest + 1 : rest;
    }

    private void addEdge() {
        this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0]] = this.randomChild;
        int[] nArray = this.childMatrix[this.randomParent];
        nArray[0] = nArray[0] + 1;
        this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0]] = this.randomParent;
        int[] nArray2 = this.parentMatrix[this.randomChild];
        nArray2[0] = nArray2[0] + 1;
    }

    private void removeEdge() {
        boolean go = true;
        if (this.parentMatrix[this.randomChild][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
            int proxNode;
            int atualNode;
            int i;
            int lastNode = this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1];
            for (i = this.parentMatrix[this.randomChild][0] - 1; i > 0 && go; --i) {
                atualNode = this.parentMatrix[this.randomChild][i];
                if (atualNode != this.randomParent) {
                    proxNode = atualNode;
                    this.parentMatrix[this.randomChild][i] = lastNode;
                    lastNode = proxNode;
                    continue;
                }
                this.parentMatrix[this.randomChild][i] = lastNode;
                go = false;
            }
            if (this.childMatrix[this.randomParent][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
                lastNode = this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1];
                go = true;
                for (i = this.childMatrix[this.randomParent][0] - 1; i > 0 && go; --i) {
                    atualNode = this.childMatrix[this.randomParent][i];
                    if (atualNode != this.randomChild) {
                        proxNode = atualNode;
                        this.childMatrix[this.randomParent][i] = lastNode;
                        lastNode = proxNode;
                        continue;
                    }
                    this.childMatrix[this.randomParent][i] = lastNode;
                    go = false;
                }
            }
            this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1] = -4;
            int[] nArray = this.childMatrix[this.randomParent];
            nArray[0] = nArray[0] - 1;
            this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1] = -4;
            int[] nArray2 = this.parentMatrix[this.randomChild];
            nArray2[0] = nArray2[0] - 1;
        }
    }
}

