/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.experimental_setup;

import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import nu.xom.Attribute;
import nu.xom.Element;

public class ExperimentalSetupXml {
    public static final String EXPSETUP = "expSetup";
    public static final String NAME = "name";
    public static final String IGNORED = "ignored";
    public static final String EXPVARIABLE = "expVariable";
    public static final String MANIPULTATION = "manipulation";
    public static final String LOCKEDAT = "lockedAt";

    public static Element renderStudiedVariables(ExperimentalSetup esvs) {
        Element esElement = new Element(EXPSETUP);
        esElement.addAttribute(new Attribute(NAME, esvs.getName()));
        String[] names = esvs.getVariableNames();
        for (int i = 0; i < names.length; ++i) {
            Element var = new Element(EXPVARIABLE);
            var.addAttribute(new Attribute(NAME, names[i]));
            var.addAttribute(new Attribute(IGNORED, esvs.getVariable(names[i]).isStudied() ? "no" : "yes"));
            var.addAttribute(new Attribute(MANIPULTATION, esvs.getVariable(names[i]).getManipulation().toString()));
            if (esvs.getVariable(names[i]).getManipulation() == VariableManipulation.LOCKED) {
                var.addAttribute(new Attribute(LOCKEDAT, esvs.getVariable(names[i]).getLockedAtValue()));
            }
            esElement.appendChild(var);
        }
        return esElement;
    }
}

