/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.manipulated_graph;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.AbstractManipulatedGraph;
import edu.cmu.tetrad.manip.manipulated_graph.EdgeManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedEdge;
import java.util.ArrayList;
import java.util.ListIterator;

public class GuessedManipulatedGraph
extends AbstractManipulatedGraph {
    static final long serialVersionUID = 23L;

    public GuessedManipulatedGraph(Graph graph) {
        super(graph);
        ListIterator<Node> i = graph.getNodes().listIterator();
        while (i.hasNext()) {
            Node variable = (Node)i.next();
            String variableName = variable.getName();
            VariableManipulation manipulation = VariableManipulation.NONE;
            if (variable.getNodeType() == NodeType.LATENT) {
                manipulation = VariableManipulation.NONE;
            }
            this.variableManipulations.put(variableName, manipulation);
        }
    }

    public void setEdge(String fromVariable, String toVariable) throws IllegalArgumentException {
        Node fromNode = this.getNode(fromVariable);
        Node toNode = this.getNode(toVariable);
        if (fromNode == null) {
            throw new IllegalArgumentException(fromNode + "not found");
        }
        if (toNode == null) {
            throw new IllegalArgumentException(toNode + "not found");
        }
        this.removeEdgeFromGuess(fromVariable, toVariable);
        this.addDirectedEdge(fromNode, toNode);
    }

    public void setEdgeFrozen(String fromVariable, String toVariable) {
        this.removeEdgeFromGuess(fromVariable, toVariable);
        this.frozenEdges.add(new ManipulatedEdge(fromVariable, toVariable, EdgeManipulation.FROZEN));
    }

    public void setEdgeBroken(String fromVariable, String toVariable) {
        this.removeEdgeFromGuess(fromVariable, toVariable);
        this.brokenEdges.add(new ManipulatedEdge(fromVariable, toVariable, EdgeManipulation.BROKEN));
    }

    public void setVariableNotManipulated(String variableName) throws IllegalArgumentException {
        this.setVariableManipulation(variableName, VariableManipulation.NONE);
    }

    public void setVariableLocked(String variableName) throws IllegalArgumentException {
        this.setVariableManipulation(variableName, VariableManipulation.LOCKED);
    }

    public void setVariableRandomized(String variableName) throws IllegalArgumentException {
        this.setVariableManipulation(variableName, VariableManipulation.RANDOMIZED);
    }

    public void removeEdgeFromGuess(String fromVariable, String toVariable) {
        this.removeEdge(this.getNode(fromVariable), this.getNode(toVariable));
        this.removeBrokenEdge(fromVariable, toVariable);
        this.removeFrozenEdge(fromVariable, toVariable);
    }

    private void setVariableManipulation(String variableName, VariableManipulation type) throws IllegalArgumentException {
        if (this.variableManipulations.get(variableName) == null) {
            throw new IllegalArgumentException(variableName + " not in guess");
        }
        this.variableManipulations.put(variableName, type);
    }

    private void removeBrokenEdge(String fromVariable, String toVariable) {
        ArrayList<ManipulatedEdge> edgesToRemove = new ArrayList<ManipulatedEdge>();
        for (ManipulatedEdge edge : this.brokenEdges) {
            if ((!edge.getFromNode().equals(fromVariable) || !edge.getToNode().equals(toVariable)) && (!edge.getFromNode().equals(toVariable) || !edge.getToNode().equals(fromVariable))) continue;
            edgesToRemove.add(edge);
        }
        for (ManipulatedEdge j : edgesToRemove) {
            this.brokenEdges.remove(j);
        }
    }

    private void removeFrozenEdge(String fromVariable, String toVariable) {
        ArrayList<ManipulatedEdge> edgesToRemove = new ArrayList<ManipulatedEdge>();
        for (ManipulatedEdge edge : this.frozenEdges) {
            if ((!edge.getFromNode().equals(fromVariable) || !edge.getToNode().equals(toVariable)) && (!edge.getFromNode().equals(toVariable) || !edge.getToNode().equals(fromVariable))) continue;
            edgesToRemove.add(edge);
        }
        for (ManipulatedEdge j : edgesToRemove) {
            this.frozenEdges.remove(j);
        }
    }
}

