/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.manipulated_graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.AbstractManipulatedGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ManipulatedGraph
extends AbstractManipulatedGraph {
    static final long serialVersionUID = 23L;

    public ManipulatedGraph(Graph graph, ExperimentalSetup experimentalSetup) throws IllegalArgumentException {
        super(graph);
        if (experimentalSetup == null) {
            throw new IllegalArgumentException("experimental setup was null");
        }
        ListIterator<Node> i = graph.getNodes().listIterator();
        while (i.hasNext()) {
            Node variable = (Node)i.next();
            String variableName = variable.getName();
            VariableManipulation manipulation = null;
            if (variable.getNodeType() == NodeType.MEASURED) {
                manipulation = experimentalSetup.getVariable(variableName).getManipulation();
            } else if (variable.getNodeType() == NodeType.LATENT) {
                manipulation = VariableManipulation.NONE;
            }
            this.variableManipulations.put(variableName, manipulation);
            if (manipulation == VariableManipulation.RANDOMIZED) {
                this.breakEdges(this.findEdgesTo(variableName));
                continue;
            }
            if (manipulation != VariableManipulation.LOCKED) continue;
            this.breakEdges(this.findEdgesTo(variableName));
            this.freezeEdges(this.findEdgesFrom(variableName));
        }
    }

    private List findEdgesTo(String variableName) {
        return this.findEdges(variableName, true);
    }

    private List findEdgesFrom(String variableName) {
        return this.findEdges(variableName, false);
    }

    private List findEdges(String variableName, boolean isToVariable) {
        ArrayList<Edge> edgesFound = new ArrayList<Edge>();
        for (Edge edge : this.getEdges(this.getNode(variableName))) {
            Node node = isToVariable ? edge.getNode2() : edge.getNode1();
            if (!node.getName().equals(variableName)) continue;
            edgesFound.add(edge);
        }
        return edgesFound;
    }
}

