/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.population;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedGraph;

public class CorrectManipulatedGraphBayesIm {
    public static MlBayesIm createIm(BayesIm correctIm, ExperimentalSetup experiment) {
        Dag mGraph = new Dag(new ManipulatedGraph(correctIm.getDag(), experiment));
        if (mGraph == null) {
            throw new NullPointerException("Graph has cycles");
        }
        BayesPm pm = new BayesPm(mGraph, correctIm.getBayesPm());
        MlBayesIm IM = new MlBayesIm(pm, correctIm, 0);
        String[] variableNames = experiment.getVariableNames();
        for (int i = 0; i < variableNames.length; ++i) {
            String variableName = variableNames[i];
            VariableManipulation type = experiment.getVariable(variableName).getManipulation();
            if (type == VariableManipulation.LOCKED) {
                CorrectManipulatedGraphBayesIm.setVariableLocked(IM, experiment, variableName);
                continue;
            }
            if (type == VariableManipulation.RANDOMIZED) {
                CorrectManipulatedGraphBayesIm.setVariableRandomized(IM, variableName);
                continue;
            }
            if (type != VariableManipulation.NONE) continue;
        }
        return IM;
    }

    private static void setVariableLocked(BayesIm IM, ExperimentalSetup experimentQN, String variableName) throws IllegalArgumentException {
        Node node = IM.getNode(variableName);
        int nodeIndex = IM.getNodeIndex(node);
        int numParents = IM.getNumParents(nodeIndex);
        if (numParents != 0) {
            throw new IllegalArgumentException(variableName + " should be locked and have no parents");
        }
        String lockedValue = experimentQN.getVariable(variableName).getLockedAtValue();
        int valueIndex = IM.getBayesPm().getCategoryIndex(node, lockedValue);
        for (int i = 0; i < IM.getBayesPm().getNumCategories(node); ++i) {
            IM.setProbability(nodeIndex, 0, i, 0.0);
        }
        IM.setProbability(nodeIndex, 0, valueIndex, 1.0);
    }

    private static void setVariableRandomized(BayesIm IM, String variableName) {
        Node node = IM.getNode(variableName);
        int nodeIndex = IM.getNodeIndex(node);
        int numValues = IM.getNumColumns(nodeIndex);
        for (int i = 0; i < IM.getBayesPm().getNumCategories(node); ++i) {
            IM.setProbability(nodeIndex, 0, i, 1.0 / (double)numValues);
        }
    }
}

