/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.population;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesImProbs;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariablesStudied;
import edu.cmu.tetrad.manip.population.CorrectManipulatedGraphBayesIm;
import edu.cmu.tetrad.manip.population.CorrectManipulatedGraphSemIm;
import edu.cmu.tetrad.sem.SemIm;
import java.util.Iterator;

public class Population {
    private static int VALUE_NOT_VIEWED = -1;

    public static String[] getColumnHeaders(SemIm correctSemIm, VariablesStudied studiedVariables) {
        return Population.createHeaders(correctSemIm, studiedVariables);
    }

    public static String getColumnHeader(int col, SemIm correctSemIm, VariablesStudied studiedVariables) {
        return Population.getColumnHeaders(correctSemIm, studiedVariables)[col];
    }

    public static String getFirstColumn(int row, VariablesStudied studiedVariables) {
        return studiedVariables.getNamesOfStudiedVariables()[row];
    }

    public static double getCovariance(SemIm semIm, String var1, String var2) throws IllegalArgumentException {
        int var1Index = -1;
        int var2Index = -1;
        int i = 0;
        for (Node node : semIm.getVariableNodes()) {
            if (node.getName().equals(var1)) {
                var1Index = i;
            }
            if (node.getName().equals(var2)) {
                var2Index = i;
            }
            ++i;
        }
        return semIm.getImplCovar().toArray()[var1Index][var2Index];
    }

    public static double getCorrelation(SemIm semIm, String var1, String var2) throws IllegalArgumentException {
        DoubleMatrix2D covariance = semIm.getImplCovar();
        String[] varNames = new String[semIm.getVariableNodes().size()];
        int i = 0;
        int x = -1;
        int y = -1;
        Iterator<Node> n = semIm.getVariableNodes().iterator();
        while (n.hasNext()) {
            varNames[i] = n.next().getName();
            if (varNames[i].equals(var1)) {
                x = i;
            }
            if (varNames[i].equals(var2)) {
                y = i;
            }
            ++i;
        }
        CovarianceMatrix covarMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), covariance, covariance.rows() + 1);
        CorrelationMatrix corrMatrix = new CorrelationMatrix(covarMatrix);
        return corrMatrix.getValue(x, y);
    }

    public static int getNumRows(ExperimentalSetup studiedVariables) {
        if (studiedVariables == null) {
            return 0;
        }
        return studiedVariables.getNumVariablesStudied();
    }

    public static Object getValueAt(int row, int col, SemIm correctSemIm, ExperimentalSetup experiment, VariablesStudied studiedVariables) {
        SemIm correctManipulatedSemIm = Population.createCorrectManipulatedSemIm(correctSemIm, experiment);
        if (col == 0) {
            return Population.getFirstColumn(row, studiedVariables);
        }
        if (col > row + 1) {
            return null;
        }
        return new Double(Population.getCorrelation(correctManipulatedSemIm, Population.getFirstColumn(row, studiedVariables), Population.getColumnHeader(col, correctManipulatedSemIm, studiedVariables)));
    }

    private static String[] createHeaders(SemIm correctSemIm, VariablesStudied studiedVariables) {
        String[] headers = new String[Population.getNumViewedColumns(studiedVariables) + 1];
        headers[0] = "";
        int j = 1;
        for (Node node : correctSemIm.getSemPm().getGraph().getNodes()) {
            NodeType type = node.getNodeType();
            if (type != NodeType.MEASURED || !studiedVariables.isVariableStudied(node.getName())) continue;
            headers[j++] = node.getName();
        }
        return headers;
    }

    public static SemIm createCorrectManipulatedSemIm(SemIm correctSemIm, ExperimentalSetup experiment) {
        return CorrectManipulatedGraphSemIm.createIm(correctSemIm, experiment);
    }

    public static String[] getCase(BayesIm correctIm, ExperimentalSetup experiment, VariablesStudied studiedVariables, int row) {
        MlBayesIm IM = CorrectManipulatedGraphBayesIm.createIm(correctIm, experiment);
        int[] combination = Population.magicIndexFunction(IM, studiedVariables, row);
        return Population.createStringCombination(IM, studiedVariables, combination);
    }

    public static double getProbability(BayesIm correctIm, ExperimentalSetup experimentQN, VariablesStudied studiedVariables, int row) {
        MlBayesIm IM = CorrectManipulatedGraphBayesIm.createIm(correctIm, experimentQN);
        BayesImProbs cellProbabilities = new BayesImProbs(IM);
        int[] combination = Population.magicIndexFunction(IM, studiedVariables, row);
        Proposition proposition = Population.createProposition(IM, combination);
        return cellProbabilities.getProb(proposition);
    }

    public static int getNumCombinationRows(BayesIm IM, VariablesStudied studiedVariables) {
        int num = 1;
        boolean anythingVisible = false;
        if (studiedVariables == null) {
            return 0;
        }
        for (int variable = 0; variable < IM.getNumNodes(); ++variable) {
            Node node = IM.getNode(variable);
            if (node.getNodeType() != NodeType.MEASURED || !studiedVariables.isVariableStudied(node.getName())) continue;
            num *= IM.getBayesPm().getNumCategories(node);
            anythingVisible = true;
        }
        if (!anythingVisible) {
            return 0;
        }
        return num;
    }

    public static int getNumColumns(BayesIm IM) {
        return Population.getNumCombinationColumns(IM);
    }

    public static String[] getColumnHeaders(BayesIm IM, VariablesStudied studiedVariables) {
        return Population.createHeaders(IM, studiedVariables);
    }

    protected static Proposition createProposition(VariableSource varSource, int[] combination) {
        Proposition proposition = Proposition.tautology(varSource);
        for (int nodeIndex = 0; nodeIndex < combination.length; ++nodeIndex) {
            int value = combination[nodeIndex];
            if (value == VALUE_NOT_VIEWED) {
                proposition.setVariable(nodeIndex, true);
                continue;
            }
            proposition.setVariable(nodeIndex, false);
            proposition.setCategory(nodeIndex, value);
        }
        return proposition;
    }

    protected static int[] magicIndexFunction(BayesIm IM, VariablesStudied studiedVariables, int row) {
        int productPreviousNumValues = 1;
        if (studiedVariables.getNumVariablesStudied() == 0) {
            return null;
        }
        int[] combination = new int[Population.getNumCombinationColumns(IM)];
        for (int variable = IM.getNumNodes() - 1; variable >= 0; --variable) {
            Node node = IM.getNode(variable);
            NodeType type = node.getNodeType();
            if (type == NodeType.MEASURED && studiedVariables.isVariableStudied(node.getName())) {
                int value;
                int currentNumValues = IM.getBayesPm().getNumCategories(node);
                combination[variable] = value = row / productPreviousNumValues % currentNumValues;
                productPreviousNumValues *= currentNumValues;
                continue;
            }
            combination[variable] = VALUE_NOT_VIEWED;
        }
        return combination;
    }

    protected static int getNumCombinationColumns(BayesIm IM) {
        for (int i = 0; i < IM.getNumNodes(); ++i) {
            NodeType type = IM.getNode(i).getNodeType();
            if (type != NodeType.MEASURED) continue;
        }
        return IM.getNumNodes();
    }

    private static int getNumViewedColumns(VariablesStudied studiedVariables) {
        return studiedVariables.getNumVariablesStudied();
    }

    protected static String[] createStringCombination(BayesIm IM, VariablesStudied studiedVariables, int[] combination) {
        String[] stringCombination = new String[Population.getNumViewedColumns(studiedVariables)];
        int j = 0;
        for (int i = 0; i < IM.getNumNodes(); ++i) {
            Node node = IM.getNode(i);
            if (node.getNodeType() != NodeType.MEASURED || !studiedVariables.isVariableStudied(node.getName())) continue;
            stringCombination[j++] = IM.getBayesPm().getCategory(node, combination[i]);
        }
        return stringCombination;
    }

    private static String[] createHeaders(BayesIm IM, VariablesStudied studiedVariables) {
        String[] headers = new String[Population.getNumViewedColumns(studiedVariables) + 1];
        int j = 0;
        for (Node node : IM.getDag().getNodes()) {
            NodeType type = node.getNodeType();
            if (type != NodeType.MEASURED || !studiedVariables.isVariableStudied(node.getName())) continue;
            headers[j++] = node.getName();
        }
        headers[j++] = "%";
        return headers;
    }

    public void printTables(BayesIm IM) {
        for (int nodeIndex = 0; nodeIndex < IM.getNumNodes(); ++nodeIndex) {
            int valueIndex;
            Node node = IM.getNode(nodeIndex);
            System.out.println();
            System.out.println(node.getName());
            for (valueIndex = 0; valueIndex < IM.getNumColumns(nodeIndex); ++valueIndex) {
                System.out.print(IM.getBayesPm().getCategory(node, valueIndex) + " ");
            }
            System.out.println();
            System.out.println("----------------");
            for (int rowIndex = 0; rowIndex < IM.getNumRows(nodeIndex); ++rowIndex) {
                int[] parentValues = IM.getParentValues(nodeIndex, rowIndex);
                for (int parentIndex = 0; parentIndex < IM.getNumParents(nodeIndex); ++parentIndex) {
                    Node parent = IM.getNode(IM.getParent(nodeIndex, parentIndex));
                    System.out.print(parent.getName() + "=" + IM.getBayesPm().getCategory(parent, parentValues[parentIndex]));
                }
                System.out.print(" : ");
                for (valueIndex = 0; valueIndex < IM.getNumColumns(nodeIndex); ++valueIndex) {
                    System.out.print(IM.getProbability(nodeIndex, rowIndex, valueIndex) + " ");
                }
                System.out.println();
            }
            System.out.println("----------------");
        }
    }

    public void printIM(BayesIm IM) {
        System.out.println(((Object)IM).toString());
    }
}

