/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.population;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariablesStudied;
import edu.cmu.tetrad.manip.manipulated_graph.AbstractManipulatedGraph;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedGraph;
import edu.cmu.tetrad.manip.population.Population;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestPopulation
extends TestCase {
    Graph graph;
    BayesPm pm;
    MlBayesIm im;
    ExperimentalSetup exp;
    ExperimentalSetup expVarStudied;
    AbstractManipulatedGraph manipGraph;

    public TestPopulation(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.makeModel();
        this.makePM(this.graph);
        this.makeIM(this.pm);
        this.makeExperiment(this.graph);
        this.makeManipulatedGraph(this.graph, this.exp);
    }

    public void testGetRows() {
        TestPopulation.assertTrue(Population.getNumCombinationRows(this.im, this.expVarStudied) == 18);
    }

    public void testGetColumns() {
        TestPopulation.assertTrue(Population.getNumColumns(this.im) == 4);
    }

    public void testGetHeaders() {
        TestPopulation.assertTrue(Population.getColumnHeaders(this.im, (VariablesStudied)this.expVarStudied)[0].equals("education"));
        TestPopulation.assertTrue(Population.getColumnHeaders(this.im, (VariablesStudied)this.expVarStudied)[1].equals("happiness"));
        TestPopulation.assertTrue(Population.getColumnHeaders(this.im, (VariablesStudied)this.expVarStudied)[2].equals("income"));
        TestPopulation.assertTrue(Population.getColumnHeaders(this.im, (VariablesStudied)this.expVarStudied)[3].equals("%"));
    }

    public void testCombinations() {
        int i;
        for (i = 0; i < 6; ++i) {
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("college"));
        }
        for (i = 6; i < 12; ++i) {
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("High school"));
        }
        for (i = 12; i < 18; ++i) {
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("none"));
        }
        i = 0;
        while (i < 18) {
            int j = 0;
            while (j < 3) {
                TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[1].equals("true"));
                ++j;
                ++i;
            }
            j = 0;
            while (j < 3) {
                TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[1].equals("false"));
                ++j;
                ++i;
            }
        }
        i = 0;
        while (i < 18) {
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i++)[2].equals("high"));
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i++)[2].equals("medium"));
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i++)[2].equals("low"));
        }
    }

    public void testProbabilities() {
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 0), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 1), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 2), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 3), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 4), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 5), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 6), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 7), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 8), 0.1, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 9), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 10), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 11), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 12), 0.13333333333333333, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 13), 0.13333333333333333, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 14), 0.13333333333333333, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 15), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 16), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 17), 0.0, 1.0E-5);
    }

    public void testCreateViewedDistribution() {
        int i;
        this.expVarStudied.getVariable("income").setStudied(false);
        int j = 0;
        while (j < 6) {
            i = 0;
            while (i < 2) {
                TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("college"));
                ++i;
                ++j;
            }
            i = 2;
            while (i < 4) {
                TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("High school"));
                ++i;
                ++j;
            }
            i = 4;
            while (i < 6) {
                TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i)[0].equals("none"));
                ++i;
                ++j;
            }
        }
        i = 0;
        while (i < 6) {
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i++)[1].equals("true"));
            TestPopulation.assertTrue(Population.getCase(this.im, this.exp, this.expVarStudied, i++)[1].equals("false"));
        }
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 0), 0.3, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 1), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 2), 0.3, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 3), 0.0, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 4), 0.4, 1.0E-5);
        TestPopulation.assertEquals(Population.getProbability(this.im, this.exp, this.expVarStudied, 5), 0.0, 1.0E-5);
    }

    public void testManipulations() {
    }

    public void testPrint() {
    }

    private void makeModel() {
        Dag m1 = new Dag();
        m1.addNode(new GraphNode("education"));
        m1.addNode(new GraphNode("happiness"));
        m1.addNode(new GraphNode("income"));
        GraphNode tn = new GraphNode("Latent");
        tn.setNodeType(NodeType.LATENT);
        m1.addNode(tn);
        m1.addDirectedEdge(m1.getNode("education"), m1.getNode("happiness"));
        m1.addDirectedEdge(m1.getNode("education"), m1.getNode("income"));
        m1.addDirectedEdge(m1.getNode("Latent"), m1.getNode("education"));
        this.graph = m1;
    }

    private void makePM(Graph aGraph) {
        this.pm = new BayesPm(new Dag(aGraph));
        this.pm.setNumCategories(this.pm.getDag().getNode("education"), 3);
        ArrayList<String> varVals = new ArrayList<String>();
        varVals.add("college");
        varVals.add("High school");
        varVals.add("none");
        this.pm.setCategories(this.pm.getDag().getNode("education"), varVals);
        varVals = new ArrayList();
        varVals.add("high");
        varVals.add("medium");
        varVals.add("low");
        this.pm.setCategories(this.pm.getDag().getNode("income"), varVals);
        varVals = new ArrayList();
        varVals.add("true");
        varVals.add("false");
        this.pm.setCategories(this.pm.getDag().getNode("happiness"), varVals);
        varVals = new ArrayList();
        varVals.add("true");
        varVals.add("false");
        this.pm.setCategories(this.pm.getDag().getNode("Latent"), varVals);
    }

    private void makeIM(BayesPm aPm) {
        this.im = new MlBayesIm(aPm);
        int i = this.im.getNodeIndex(this.im.getNode("Latent"));
        this.im.setProbability(i, 0, 0, 0.5);
        this.im.setProbability(i, 0, 1, 0.5);
        i = this.im.getNodeIndex(this.im.getNode("education"));
        this.im.setProbability(i, 0, 0, 0.3);
        this.im.setProbability(i, 0, 1, 0.3);
        this.im.setProbability(i, 0, 2, 0.4);
        this.im.setProbability(i, 1, 0, 0.3);
        this.im.setProbability(i, 1, 1, 0.3);
        this.im.setProbability(i, 1, 2, 0.4);
        i = this.im.getNodeIndex(this.im.getNode("happiness"));
        this.im.setProbability(i, 0, 0, 0.5);
        this.im.setProbability(i, 0, 1, 0.5);
        this.im.setProbability(i, 1, 0, 0.5);
        this.im.setProbability(i, 1, 1, 0.5);
        this.im.setProbability(i, 2, 0, 0.5);
        this.im.setProbability(i, 2, 1, 0.5);
        i = this.im.getNodeIndex(this.im.getNode("income"));
        this.im.setProbability(i, 0, 0, 0.3);
        this.im.setProbability(i, 0, 1, 0.3);
        this.im.setProbability(i, 0, 2, 0.4);
        this.im.setProbability(i, 1, 0, 0.3);
        this.im.setProbability(i, 1, 1, 0.3);
        this.im.setProbability(i, 1, 2, 0.4);
        this.im.setProbability(i, 2, 0, 0.3);
        this.im.setProbability(i, 2, 1, 0.3);
        this.im.setProbability(i, 2, 2, 0.4);
    }

    private void makeExperiment(Graph aGraph) {
        this.exp = new ExperimentalSetup("experiment", aGraph);
        this.exp.getVariable("income").setRandomized();
        this.exp.getVariable("happiness").setLocked("true");
        this.expVarStudied = this.exp;
    }

    private void makeManipulatedGraph(Graph aGraph, ExperimentalSetup exp) {
        this.manipGraph = new ManipulatedGraph(aGraph, exp);
    }
}

