/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.network;

import edu.cmu.tetrad.network.CorrelationParams;

class CorrelationProle
extends Thread {
    private int[] currentPair;
    private CorrelationParams params;
    private int numToCalculate;
    private int numCalculated;
    private int numVars;
    private boolean done;

    public CorrelationProle(int[] currentPair, int numCalculations, CorrelationParams params) {
        this.currentPair = currentPair;
        this.numToCalculate = numCalculations;
        this.numCalculated = 0;
        this.params = params;
        this.done = false;
    }

    public int[] getNextPair() {
        if (this.numCalculated == this.numToCalculate - 1) {
            this.halt();
            return null;
        }
        this.currentPair[1] = this.currentPair[1] + 1;
        if (this.currentPair[1] >= this.params.col) {
            this.currentPair[0] = this.currentPair[0] + 1;
            this.currentPair[1] = this.currentPair[0] + 1;
        }
        System.out.println("[CorrelationProle]: Next pair = <" + this.currentPair[0] + ", " + this.currentPair[1] + ">");
        ++this.numCalculated;
        return this.currentPair;
    }

    public void halt() {
        this.done = true;
    }

    @Override
    public void run() {
        while (!this.done) {
            int[] pair = this.getNextPair();
            if (pair == null) continue;
            System.out.println("Calculating " + pair[0] + " - " + pair[1]);
        }
    }
}

