/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.network;

import edu.cmu.tetrad.network.ConnectionListener;
import edu.cmu.tetrad.network.RunMode;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Vector;

public class Mastermind
extends Thread {
    private Vector<Socket> workers = new Vector();
    private Vector<PrintWriter> workerStreams = new Vector();
    private Vector<String> tasks = new Vector();
    private ConnectionListener listener;
    private RunMode runMode = RunMode.IDLE;
    private boolean settingUp = false;
    private boolean run = true;
    private double[][] dataSet;

    public static void main(String[] args) {
        Mastermind m = new Mastermind();
        m.dataSet = new double[5][20];
        double count = 0.0;
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                double d = count;
                count = d + 1.0;
                m.dataSet[j][i] = d;
            }
        }
        m.start();
    }

    public void halt() {
        this.run = false;
    }

    public void calculateCorrelationMatrix(double[][] dataSet) {
    }

    public Vector<String> compileTestPackets(int numberOfNodes, int numberOfTrials) {
        Vector<String> packets = new Vector<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            packets.add(this.preparePacket(numberOfTrials));
        }
        return packets;
    }

    public String preparePacket(int size) {
        String packet = "";
        Vector<String> toBeRemoved = new Vector<String>();
        for (int i = 0; i < size; ++i) {
            packet = packet + this.tasks.get(i);
            toBeRemoved.add(this.tasks.get(i));
        }
        for (String s : toBeRemoved) {
            this.tasks.remove(s);
        }
        return packet;
    }

    public void listen() {
        this.settingUp = true;
        System.out.println("Entering the LISTEN stage.");
        this.runMode = RunMode.LISTEN;
        this.workers = new Vector();
        this.workerStreams = new Vector();
        this.listener = new ConnectionListener(this.workers, this.workerStreams, 2);
        this.listener.start();
        System.out.println("Started listener.");
        this.settingUp = false;
    }

    public void evaluate() {
        if (this.runMode != RunMode.LISTEN) {
            return;
        }
        this.settingUp = true;
        this.runMode = RunMode.EVALUATE;
        System.out.println("Entering the EVALUATE stage.");
        System.out.println("Workers: " + this.workers);
        this.settingUp = false;
    }

    public void schedule() {
        if (this.runMode != RunMode.EVALUATE) {
            return;
        }
        this.settingUp = true;
        this.runMode = RunMode.SCHEDULE;
        this.settingUp = false;
    }

    public void distribute() {
        if (this.runMode != RunMode.SCHEDULE) {
            return;
        }
        this.settingUp = true;
        this.runMode = RunMode.DISTRIBUTE;
        this.settingUp = false;
    }

    public void execute() {
        if (this.runMode != RunMode.DISTRIBUTE) {
            return;
        }
        this.settingUp = true;
        this.runMode = RunMode.EXECUTE;
        this.settingUp = false;
    }

    @Override
    public void run() {
        this.listen();
        int frame = 0;
        while (this.run) {
            if (!this.settingUp) {
                switch (this.runMode) {
                    case LISTEN: {
                        if (!this.listener.isDone()) break;
                        this.evaluate();
                        break;
                    }
                    case EVALUATE: {
                        String evaluatePacket = "CORRELATION\n";
                        evaluatePacket = evaluatePacket + this.dataSet.length + "\t" + this.dataSet[0].length + "\n";
                        for (int i = 0; i < this.dataSet[0].length; ++i) {
                            for (int j = 0; j < this.dataSet.length; ++j) {
                                evaluatePacket = evaluatePacket + this.dataSet[j][i] + "\t";
                            }
                            evaluatePacket = evaluatePacket + "\n";
                        }
                        evaluatePacket = evaluatePacket + "10\n";
                        int count = 0;
                        for (PrintWriter pw : this.workerStreams) {
                            String outgoingPacket = evaluatePacket + count + "\n";
                            pw.print(outgoingPacket);
                            pw.flush();
                        }
                        this.schedule();
                        break;
                    }
                    case SCHEDULE: {
                        break;
                    }
                    case DISTRIBUTE: {
                        break;
                    }
                }
            }
            try {
                Mastermind.sleep(5000L);
                System.out.println("Cycling Mastermind . . .");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            ++frame;
        }
    }
}

