/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.network;

import edu.cmu.tetrad.network.CorrelationParams;
import edu.cmu.tetrad.network.Prole;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;

class ProleControl
extends Thread {
    private Socket socket;
    private BufferedReader in;
    private Prole prole;
    private boolean done;
    private boolean relax;

    public ProleControl(Socket socket, Prole prole) {
        this.socket = socket;
        this.prole = prole;
        this.done = false;
        this.relax = false;
        try {
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void halt() {
        this.done = true;
    }

    public void relax() {
        this.relax = true;
    }

    public void dontRelax() {
        this.relax = false;
    }

    @Override
    public void run() {
        CorrelationParams corrParams = new CorrelationParams();
        while (!this.done) {
            if (this.relax) {
                System.out.println("[ProleControl]: Just relaxin'...");
                try {
                    ProleControl.sleep(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                int j;
                int i;
                if (!this.in.ready()) continue;
                String temp = this.in.readLine();
                System.out.println("[ProleControl]: " + temp);
                String message = "";
                boolean firstLine = true;
                while (temp != null) {
                    if (firstLine) {
                        message = message + temp;
                        firstLine = false;
                    } else {
                        message = message + "\n" + temp;
                    }
                    if (this.in.ready()) {
                        temp = this.in.readLine();
                        continue;
                    }
                    temp = null;
                }
                System.out.println(message);
                StringTokenizer lines = new StringTokenizer(message, "\n");
                String header = lines.nextToken();
                if (!header.equals("CORRELATION")) continue;
                corrParams = new CorrelationParams();
                System.out.println("[ProleControl]: Received the cue to begin a corralation calculations.");
                StringTokenizer tokens = new StringTokenizer(lines.nextToken(), "\t");
                String column = tokens.nextToken();
                String row = tokens.nextToken();
                System.out.println("COLUMN: " + column);
                System.out.println("ROW: " + row);
                corrParams.col = Integer.parseInt(column);
                corrParams.row = Integer.parseInt(row);
                corrParams.dataSet = new double[corrParams.row][corrParams.col];
                for (i = 0; i < corrParams.row; ++i) {
                    tokens = new StringTokenizer(lines.nextToken(), "\t");
                    for (j = 0; j < corrParams.col; ++j) {
                        corrParams.dataSet[i][j] = Double.parseDouble(tokens.nextToken());
                    }
                }
                System.out.println("[ProleControl]: Read the following data set:");
                for (i = 0; i < corrParams.row; ++i) {
                    for (j = 0; j < corrParams.col; ++j) {
                        System.out.print(corrParams.dataSet[i][j] + "\t");
                    }
                    System.out.println();
                }
                corrParams.evalTrials = Integer.parseInt(lines.nextToken());
                corrParams.nodeId = Integer.parseInt(lines.nextToken());
                System.out.println("evalTrials: " + corrParams.evalTrials);
                System.out.println("node ID: " + corrParams.nodeId);
                this.prole.handle(corrParams);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

