/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import java.util.LinkedList;
import java.util.List;

public class RegressionUtils {
    public static DataSet residuals(DataSet dataSet, Dag dag) {
        RegressionDataset regression = new RegressionDataset(dataSet);
        DenseDoubleMatrix2D residuals = new DenseDoubleMatrix2D(dataSet.getNumRows(), dataSet.getNumColumns());
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            Node target = dataSet.getVariable(i);
            Node _target = dag.getNode(target.getName());
            if (!dag.containsNode(_target)) continue;
            List<Node> _regressors = dag.getParents(_target);
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (Node node : _regressors) {
                regressors.add(dataSet.getVariable(node.getName()));
            }
            RegressionResult result = regression.regress(target, regressors);
            DoubleMatrix1D residualsColumn = result.getResiduals();
            residuals.viewColumn(i).assign(residualsColumn);
        }
        return ColtDataSet.makeContinuousData(dataSet.getVariables(), residuals);
    }
}

