/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionCovariance;
import edu.cmu.tetrad.regression.RegressionDatasetGeneralized;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRegression
extends TestCase {
    DataSet data;

    public TestRegression(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        RandomUtil.getInstance().setSeed(342233L);
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        this.data = im.simulateDataReducedForm(1000, false);
    }

    public void testTabular() {
        List<Node> nodes = this.data.getVariables();
        Node target = nodes.get(0);
        ArrayList<Node> regressors = new ArrayList<Node>();
        for (int i = 1; i < nodes.size(); ++i) {
            regressors.add(nodes.get(i));
        }
        RegressionDatasetGeneralized regression = new RegressionDatasetGeneralized(this.data);
        RegressionResult result = regression.regress(target, regressors);
        System.out.println(result);
        double[] coeffs = result.getCoef();
        TestRegression.assertEquals(-0.05, coeffs[0], 0.01);
        TestRegression.assertEquals(0.0239, coeffs[1], 0.01);
        TestRegression.assertEquals(0.48322, coeffs[2], 0.01);
        TestRegression.assertEquals(-0.99115, coeffs[3], 0.01);
        TestRegression.assertEquals(-0.86942, coeffs[4], 0.01);
    }

    public void testCovariance() {
        CovarianceMatrix cov = new CovarianceMatrix(this.data);
        List<Node> nodes = cov.getVariables();
        Node target = nodes.get(0);
        ArrayList<Node> regressors = new ArrayList<Node>();
        for (int i = 1; i < nodes.size(); ++i) {
            regressors.add(nodes.get(i));
        }
        RegressionCovariance regression = new RegressionCovariance(cov);
        RegressionResult result = regression.regress(target, regressors);
        System.out.println(result);
        double[] coeffs = result.getCoef();
        TestRegression.assertEquals(0.0, coeffs[0], 0.01);
        TestRegression.assertEquals(0.0239, coeffs[1], 0.01);
        TestRegression.assertEquals(0.48322, coeffs[2], 0.01);
        TestRegression.assertEquals(-0.99115, coeffs[3], 0.01);
        TestRegression.assertEquals(-0.86942, coeffs[4], 0.01);
    }

    private double[] getArray(DataSet data, Node node) {
        return data.getDoubleData().viewColumn(data.getColumn(node)).toArray();
    }

    private char[] fileToCharArray(File file) {
        try {
            int c;
            FileReader reader = new FileReader(file);
            CharArrayWriter writer = new CharArrayWriter();
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            return writer.toCharArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private DataSet loadCarsFile() {
        File file = new File("test_data/cars.dat");
        char[] chars = this.fileToCharArray(file);
        DataReader reader = new DataReader();
        reader.setDelimiter(DelimiterType.WHITESPACE);
        return reader.parseTabular(chars);
    }

    private DataSet loadRegressionDataFile() {
        File file = new File("test_data/regressiondata.dat");
        char[] chars = this.fileToCharArray(file);
        DataReader reader = new DataReader();
        reader.setDelimiter(DelimiterType.WHITESPACE);
        DataSet data = reader.parseTabular(chars);
        return data;
    }

    public static Test suite() {
        return new TestSuite(TestRegression.class);
    }
}

