/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.regression.RegressionOld;
import edu.cmu.tetrad.regression.RegressionResult;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRegressionOld
extends TestCase {
    public TestRegressionOld(String name) {
        super(name);
    }

    public void testSimpleRegression() {
        double[] accel = new double[]{7.1, 6.1, 5.8, 4.0, 3.6, 5.5, 4.4, 6.7, 7.8};
        double[] hp = new double[]{250.0, 227.0, 340.0, 180.0, 348.0, 240.0, 190.0, 178.0, 200.0};
        double[] torque = new double[]{250.0, 217.0, 302.0, 145.0, 328.0, 162.0, 138.0, 166.0, 220.0};
        double[] weight = new double[]{3640.0, 3256.0, 4173.0, 1257.0, 2062.0, 2866.0, 1930.0, 2596.0, 3460.0};
        double[] ratio = new double[]{3.6, 3.9, 3.89, 3.62, 3.55, 4.1, 4.53, 4.1, 3.29};
        double[] disp = new double[]{2457.0, 1994.0, 4163.0, 1988.0, 4942.0, 2157.0, 1796.0, 1840.0, 3498.0};
        double[][] regressors = new double[][]{hp, torque, weight, ratio, disp};
        System.out.println("regressors " + regressors[0][0] + " " + regressors[0][1] + " " + regressors[0][2]);
        System.out.println("regressors " + regressors[1][0] + " " + regressors[1][1] + " " + regressors[1][2]);
        String[] names = new String[]{"HP", "Torque", "Weight", "RAR", "Disp"};
        System.out.println("target " + accel[0] + " " + accel[1] + " " + accel[2]);
        RegressionOld regression = new RegressionOld();
        regression.setRegressors(regressors);
        regression.setRegressorNames(names);
        RegressionResult result = regression.regress(accel, "Accel");
        System.out.println(result);
        double[] coeffs = result.getCoef();
        TestRegressionOld.assertEquals(6.5, coeffs[0], 0.05);
        TestRegressionOld.assertEquals(-0.02, coeffs[1], 0.005);
        TestRegressionOld.assertEquals(0.007, coeffs[2], 0.001);
        TestRegressionOld.assertEquals(0.0014, coeffs[3], 2.0E-4);
        TestRegressionOld.assertEquals(-0.318, coeffs[4], 0.001);
        TestRegressionOld.assertEquals(2.0E-4, coeffs[5], 5.0E-5);
    }

    public static Test suite() {
        return new TestSuite(TestRegressionOld.class);
    }
}

