/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.search.BinaryFunction;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.PermutationGenerator;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class BinaryFunctionUtils {
    private int numArgs;

    public BinaryFunctionUtils(int numArgs) {
        this.numArgs = numArgs;
    }

    public void printAllFunctions() {
        int i = 0;
        while ((long)i < this.getNumFunctions()) {
            System.out.println(new BinaryFunction(this.numArgs, i));
            ++i;
        }
    }

    public long getNumFunctions() {
        int numRows = this.getNumRows();
        long numFunctions = 1L;
        for (int i = 0; i < numRows; ++i) {
            numFunctions *= 2L;
        }
        return numFunctions;
    }

    public int getNumRows() {
        BinaryFunction first = new BinaryFunction(this.numArgs, 0L);
        return first.getNumRows();
    }

    public long count() {
        HashSet<Integer> variables = new HashSet<Integer>();
        for (int i = 0; i < this.numArgs; ++i) {
            variables.add(i);
        }
        long numValidated = 0L;
        long numFunctions = this.getNumFunctions();
        BinaryFunction function = new BinaryFunction(this.numArgs, 0L);
        block1: for (long index = 0L; index < numFunctions; ++index) {
            if (index % 100000L == 0L) {
                System.out.println("..." + index + " counted so far, " + numValidated + " validated tables so far...");
            }
            function.resetFunction(index);
            HashSet<Integer> validated = new HashSet<Integer>();
            for (int row = 0; row < this.getNumRows(); ++row) {
                boolean[] vals = function.getRow(row);
                boolean val1 = function.getValue(vals);
                Iterator i$ = variables.iterator();
                while (i$.hasNext()) {
                    int v = (Integer)i$.next();
                    if (validated.contains(v)) continue;
                    vals[v] = !vals[v];
                    boolean val2 = function.getValue(vals);
                    if (val1 != val2) {
                        validated.add(v);
                        if (validated.size() == this.numArgs) {
                            if (function.getOppositeFunction() < index || function.getSymmetricFunction() < index || function.getSymmetricOppositeFunction() < index) continue block1;
                            ++numValidated;
                            continue block1;
                        }
                    }
                    vals[v] = !vals[v];
                }
            }
        }
        return numValidated;
    }

    public boolean satisfiesTestPair(BinaryFunction function) {
        HashSet<Integer> variables = new HashSet<Integer>();
        for (int i = 0; i < this.numArgs; ++i) {
            variables.add(i);
        }
        HashSet<Integer> validated = new HashSet<Integer>();
        for (int row = 0; row < this.getNumRows(); ++row) {
            boolean[] vals = function.getRow(row);
            boolean val1 = function.getValue(vals);
            Iterator i$ = variables.iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                if (validated.contains(v)) continue;
                vals[v] = !vals[v];
                boolean val2 = function.getValue(vals);
                if (val1 != val2) {
                    validated.add(v);
                    if (validated.size() == this.numArgs) {
                        return true;
                    }
                }
                vals[v] = !vals[v];
            }
        }
        return false;
    }

    public List<BinaryFunction> findNontransitiveTriple() {
        long numFunctions = this.getNumFunctions();
        int n = 0;
        RandomUtil random = RandomUtil.getInstance();
        for (long t1 = 0L; t1 < numFunctions; ++t1) {
            int[] p1;
            BinaryFunction g1 = new BinaryFunction(this.numArgs, t1);
            if (!this.satisfiesTestPair(g1)) continue;
            PermutationGenerator cg1 = new PermutationGenerator(this.numArgs);
            while ((p1 = cg1.next()) != null) {
                int[] p2;
                long switched1 = g1.switchColsFull(p1);
                BinaryFunction g2 = new BinaryFunction(g1.getNumArgs(), switched1);
                if (g1.equals(g2) || !this.satisfiesTestPair(g2)) continue;
                PermutationGenerator cg2 = new PermutationGenerator(this.numArgs);
                while ((p2 = cg2.next()) != null) {
                    boolean transposable;
                    long switched2 = g2.switchColsFull(p2);
                    BinaryFunction g3 = new BinaryFunction(g2.getNumArgs(), switched2);
                    if (g3.equals(g1) || g3.equals(g2) || !this.satisfiesTestPair(g3) || (transposable = this.equalsUnderSomePermutation(g1, g3))) continue;
                    LinkedList<BinaryFunction> list = new LinkedList<BinaryFunction>();
                    list.add(g1);
                    list.add(g2);
                    list.add(g3);
                    System.out.println("#" + ++n);
                    System.out.println("G1" + g1);
                    System.out.println("G2" + g2);
                    System.out.println("G3" + g3);
                    System.out.println("==============");
                }
            }
        }
        return null;
    }

    public long count2() {
        HashSet<Integer> variables = new HashSet<Integer>();
        for (int i = 0; i < this.numArgs; ++i) {
            variables.add(i);
        }
        long numFunctions = this.getNumFunctions();
        HashSet<BinaryFunction> prototypes = new HashSet<BinaryFunction>();
        for (long index = 0L; index < numFunctions; ++index) {
            BinaryFunction candidate;
            if (index % 1000L == 0L) {
                System.out.println(index + " " + prototypes.size());
            }
            if ((candidate = new BinaryFunction(this.numArgs, index)).getOppositeFunction() < index || candidate.getSymmetricFunction() < index || candidate.getSymmetricOppositeFunction() < index || !this.satisfiesTestPair(candidate) || this.classOfSomePrototype(candidate, prototypes)) continue;
            prototypes.add(candidate);
        }
        return prototypes.size();
    }

    private boolean classOfSomePrototype(BinaryFunction candidate, Set<BinaryFunction> prototypes) {
        for (BinaryFunction f3 : prototypes) {
            if (!this.equalsUnderSomePermutation(candidate, f3)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsUnderSomePermutation(BinaryFunction f1, BinaryFunction f2) {
        int[] permutation;
        PermutationGenerator pg = new PermutationGenerator(f1.getNumArgs());
        while ((permutation = pg.next()) != null) {
            if (!this.equalsUnderPermutation(f1, f2, permutation)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsUnderBinaryPermutation(BinaryFunction f1, BinaryFunction f2) {
        int[] permutation;
        ChoiceGenerator pg = new ChoiceGenerator(f1.getNumArgs(), 2);
        while ((permutation = pg.next()) != null) {
            if (!this.equalsUnderBinaryPermutation(f1, f2, permutation)) continue;
            return true;
        }
        return false;
    }

    public boolean checkTriple(int numArgs, boolean[] g1Rows, boolean[] g2Rows, boolean[] g3Rows) {
        BinaryFunction g1 = new BinaryFunction(numArgs, g1Rows);
        BinaryFunction g2 = new BinaryFunction(numArgs, g2Rows);
        BinaryFunction g3 = new BinaryFunction(numArgs, g3Rows);
        System.out.println("g1");
        System.out.println(g1);
        System.out.println("g2");
        System.out.println(g2);
        System.out.println("g3");
        System.out.println(g3);
        if (g1.equals(g2) || g2.equals(g3) || g1.equals(g3)) {
            return false;
        }
        if (!this.satisfiesTestPair(g1)) {
            System.out.println("g1 fails test pair condition.");
        }
        if (!this.satisfiesTestPair(g2)) {
            System.out.println("g2 fails test pair condition.");
        }
        if (!this.satisfiesTestPair(g3)) {
            System.out.println("g3 fails test pair condition.");
        }
        if (!this.equalsUnderSomePermutation(g1, g2)) {
            System.out.println("g1 and g2 not transposable.");
        }
        if (!this.equalsUnderSomePermutation(g2, g3)) {
            System.out.println("g2 and g3 not transposable.");
        }
        if (this.equalsUnderSomePermutation(g1, g3)) {
            System.out.println("g1 and g3 transposable.");
        }
        return true;
    }

    private boolean equalsUnderBinaryPermutation(BinaryFunction f1, BinaryFunction f3, int[] choice) {
        boolean isTransposable = true;
        for (int i = 0; i < f1.getNumRows(); ++i) {
            boolean[] row = f1.getRow(i);
            boolean temp = row[choice[0]];
            row[choice[0]] = row[choice[1]];
            row[choice[1]] = temp;
            if (f1.getValue(row) == f3.getValue(row)) continue;
            isTransposable = false;
        }
        return isTransposable;
    }

    private boolean equalsUnderPermutation(BinaryFunction f1, BinaryFunction f3, int[] permutation) {
        for (int i = 0; i < f1.getNumRows(); ++i) {
            boolean[] row = f1.getRow(i);
            boolean[] newRow = new boolean[row.length];
            for (int j = 0; j < row.length; ++j) {
                newRow[j] = row[permutation[j]];
            }
            if (f1.getValue(row) == f3.getValue(newRow)) continue;
            return false;
        }
        return true;
    }
}

